/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Objects;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.assertj.core.presentation.BinaryRepresentation;
import org.assertj.core.presentation.HexadecimalRepresentation;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.UnicodeRepresentation;
import org.assertj.core.util.Strings;

public class WritableAssertionInfo
implements AssertionInfo {
    private static final String EMPTY_STRING = "";
    private String overridingErrorMessage;
    private Description description;
    private Representation representation;

    public WritableAssertionInfo(Representation customRepresentation) {
        this.useRepresentation(customRepresentation == null ? ConfigurationProvider.CONFIGURATION_PROVIDER.representation() : customRepresentation);
    }

    public WritableAssertionInfo() {
        this.useRepresentation(ConfigurationProvider.CONFIGURATION_PROVIDER.representation());
    }

    @Override
    public String overridingErrorMessage() {
        return this.overridingErrorMessage;
    }

    public void overridingErrorMessage(String newErrorMessage) {
        this.overridingErrorMessage = newErrorMessage;
    }

    @Override
    public Description description() {
        return this.description;
    }

    public String descriptionText() {
        return this.description == null ? EMPTY_STRING : this.description.value();
    }

    public boolean hasDescription() {
        return this.description != null && !Strings.isNullOrEmpty(this.description.value());
    }

    public void description(String newDescription, Object ... args) {
        this.description = new TextDescription(newDescription, args);
    }

    public void description(Description newDescription) {
        this.description = Description.emptyIfNull(newDescription);
    }

    @Override
    public Representation representation() {
        return this.representation;
    }

    public void useHexadecimalRepresentation() {
        this.representation = new HexadecimalRepresentation();
    }

    public void useUnicodeRepresentation() {
        this.representation = new UnicodeRepresentation();
    }

    public void useBinaryRepresentation() {
        this.representation = new BinaryRepresentation();
    }

    public void useRepresentation(Representation newRepresentation) {
        Objects.requireNonNull(newRepresentation, "The representation to use should not be null.");
        this.representation = newRepresentation;
    }

    public static String mostRelevantDescriptionIn(WritableAssertionInfo info, String newDescription) {
        return info.hasDescription() ? info.descriptionText() : newDescription;
    }

    public String toString() {
        String format = "%s[overridingErrorMessage=%s, description=%s, representation=%s]";
        return String.format(format, this.getClass().getSimpleName(), Strings.quote(this.overridingErrorMessage()), Strings.quote(this.descriptionText()), Strings.quote(this.representation()));
    }
}

