/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.SoftProxies;
import org.assertj.core.internal.Failures;

public class AbstractSoftAssertions
implements InstanceOfAssertFactories {
    protected final SoftProxies proxies = new SoftProxies();

    public <T, V> V proxy(Class<V> assertClass, Class<T> actualClass, T actual) {
        return this.proxies.createSoftAssertionProxy(assertClass, actualClass, actual);
    }

    public void check(ThrowingRunnable assertion) {
        try {
            assertion.run();
        }
        catch (AssertionError error) {
            this.proxies.collectError((Throwable)((Object)error));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void fail(String failureMessage) {
        AssertionError error = Failures.instance().failure(failureMessage);
        this.proxies.collectError((Throwable)((Object)error));
    }

    public void fail(String failureMessage, Object ... args) {
        AssertionError error = Failures.instance().failure(String.format(failureMessage, args));
        this.proxies.collectError((Throwable)((Object)error));
    }

    public void fail(String failureMessage, Throwable realCause) {
        AssertionError error = Failures.instance().failure(failureMessage);
        ((Throwable)((Object)error)).initCause(realCause);
        this.proxies.collectError((Throwable)((Object)error));
    }

    public void failBecauseExceptionWasNotThrown(Class<? extends Throwable> throwableClass) {
        this.shouldHaveThrown(throwableClass);
    }

    public void shouldHaveThrown(Class<? extends Throwable> throwableClass) {
        AssertionError error = Failures.instance().expectedThrowableNotThrown(throwableClass);
        this.proxies.collectError((Throwable)((Object)error));
    }

    public List<Throwable> errorsCollected() {
        return this.decorateErrorsCollected(this.proxies.errorsCollected());
    }

    protected List<Throwable> decorateErrorsCollected(List<Throwable> errors) {
        return this.addLineNumberToErrorMessages(errors);
    }

    public boolean wasSuccess() {
        return this.proxies.wasSuccess();
    }

    private List<Throwable> addLineNumberToErrorMessages(List<Throwable> errors) {
        return errors.stream().map(this::addLineNumberToErrorMessage).collect(Collectors.toList());
    }

    private Throwable addLineNumberToErrorMessage(Throwable error) {
        StackTraceElement testStackTraceElement = this.getFirstStackTraceElementFromTest(error.getStackTrace());
        if (testStackTraceElement != null) {
            try {
                return this.createNewInstanceWithLineNumberInErrorMessage(error, testStackTraceElement);
            }
            catch (ReflectiveOperationException | SecurityException exception) {
                // empty catch block
            }
        }
        return error;
    }

    private Throwable createNewInstanceWithLineNumberInErrorMessage(Throwable error, StackTraceElement testStackTraceElement) throws ReflectiveOperationException {
        Constructor<?> constructor = error.getClass().getConstructor(String.class, Throwable.class);
        Throwable errorWithLineNumber = (Throwable)constructor.newInstance(this.buildErrorMessageWithLineNumber(error.getMessage(), testStackTraceElement), error.getCause());
        errorWithLineNumber.setStackTrace(error.getStackTrace());
        for (Throwable suppressed : error.getSuppressed()) {
            errorWithLineNumber.addSuppressed(suppressed);
        }
        return errorWithLineNumber;
    }

    private String buildErrorMessageWithLineNumber(String originalErrorMessage, StackTraceElement testStackTraceElement) {
        String testClassName = this.simpleClassNameOf(testStackTraceElement);
        String testName = testStackTraceElement.getMethodName();
        int lineNumber = testStackTraceElement.getLineNumber();
        return String.format("%s%nat %s.%s(%s.java:%s)", originalErrorMessage, testClassName, testName, testClassName, lineNumber);
    }

    private String simpleClassNameOf(StackTraceElement testStackTraceElement) {
        String className = testStackTraceElement.getClassName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private StackTraceElement getFirstStackTraceElementFromTest(StackTraceElement[] stacktrace) {
        for (StackTraceElement element : stacktrace) {
            String className = element.getClassName();
            if (this.isProxiedAssertionClass(className) || className.startsWith("sun.reflect") || className.startsWith("jdk.internal.reflect") || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("org.junit.") || className.startsWith("org.eclipse.jdt.internal.junit.") || className.startsWith("org.eclipse.jdt.internal.junit4.") || className.startsWith("org.eclipse.jdt.internal.junit5.") || className.startsWith("com.intellij.junit5.") || className.startsWith("com.intellij.rt.execution.junit.") || className.startsWith("org.apache.maven.surefire") || className.startsWith("org.assertj")) continue;
            return element;
        }
        return null;
    }

    private boolean isProxiedAssertionClass(String className) {
        return className.contains("$ByteBuddy$");
    }

    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

