/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.fit.factory.ResourceCreationSpecifierFactory;
import org.apache.uima.fit.internal.ExtendedExternalResourceDescription_impl;
import org.apache.uima.fit.internal.ReflectionUtil;
import org.apache.uima.fit.internal.ResourceList;
import org.apache.uima.resource.CustomResourceSpecifier;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.Parameter;
import org.apache.uima.resource.ParameterizedDataResource;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.SharedResourceObject;
import org.apache.uima.resource.impl.ConfigurableDataResourceSpecifier_impl;
import org.apache.uima.resource.impl.ConfigurableDataResource_impl;
import org.apache.uima.resource.impl.ExternalResourceDescription_impl;
import org.apache.uima.resource.impl.FileResourceSpecifier_impl;
import org.apache.uima.resource.impl.Parameter_impl;
import org.apache.uima.resource.metadata.ExternalResourceBinding;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.impl.ResourceManagerConfiguration_impl;
import org.apache.uima.resource.metadata.impl.ResourceMetaData_impl;
import org.apache.uima.util.InvalidXMLException;

public final class ExternalResourceFactory {
    public static final String PARAM_RESOURCE_NAME = "__UIMAFIT_RESOURCE_NAME__";
    public static final String PREFIX_SEPARATOR = "##";
    private static final AtomicLong DISAMBIGUATOR = new AtomicLong();

    private ExternalResourceFactory() {
    }

    public static boolean isExternalResourceField(Field field) {
        return ReflectionUtil.isAnnotationPresent(field, ExternalResource.class);
    }

    public static ExternalResourceDescription createResourceDescription(Class<? extends Resource> aInterface, Object ... aParams) {
        return ExternalResourceFactory.createNamedResourceDescription(ExternalResourceFactory.uniqueResourceKey(aInterface.getName()), aInterface, aParams);
    }

    public static ExternalResourceDescription createNamedResourceDescription(String aName, Class<? extends Resource> aInterface, Object ... aParams) {
        CustomResourceSpecifier spec;
        ConfigurationParameterFactory.ensureParametersComeInPairs(aParams);
        ArrayList<ExternalResourceBinding> bindings = new ArrayList<ExternalResourceBinding>();
        ArrayList<ExternalResourceDescription> descs = new ArrayList<ExternalResourceDescription>();
        for (Map.Entry<String, ExternalResourceDescription> res : ExternalResourceFactory.extractResourceParameters(aParams).entrySet()) {
            bindings.add(ExternalResourceFactory.createResourceBinding(res.getKey(), res.getValue()));
            descs.add(res.getValue());
        }
        if (ConfigurableDataResource_impl.class.isAssignableFrom(aInterface)) {
            ConfigurationParameterFactory.ConfigurationData cfg = ConfigurationParameterFactory.createConfigurationData(aParams);
            ResourceMetaData_impl meta = new ResourceMetaData_impl();
            ConfigurationParameterFactory.ConfigurationData reflectedConfigurationData = ConfigurationParameterFactory.createConfigurationData(aInterface);
            ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceMetaData)meta, reflectedConfigurationData.configurationParameters, reflectedConfigurationData.configurationValues);
            ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceMetaData)meta, cfg.configurationParameters, cfg.configurationValues);
            ConfigurableDataResourceSpecifier_impl spec1 = new ConfigurableDataResourceSpecifier_impl();
            spec1.setUrl("");
            spec1.setMetaData((ResourceMetaData)meta);
            spec = spec1;
        } else {
            ArrayList<Parameter_impl> params = new ArrayList<Parameter_impl>();
            if (aParams != null) {
                for (int i = 0; i < aParams.length / 2; ++i) {
                    if (ExternalResourceFactory.getResourceParameterType(aParams[i * 2 + 1]) != ResourceValueType.NO_RESOURCE) continue;
                    Parameter_impl param = new Parameter_impl();
                    param.setName((String)aParams[i * 2]);
                    param.setValue((String)aParams[i * 2 + 1]);
                    params.add(param);
                }
            }
            CustomResourceSpecifier spec1 = UIMAFramework.getResourceSpecifierFactory().createCustomResourceSpecifier();
            spec1.setResourceClassName(aInterface.getName());
            spec1.setParameters(params.toArray(new Parameter[params.size()]));
            spec = spec1;
        }
        ExtendedExternalResourceDescription_impl extRes = new ExtendedExternalResourceDescription_impl();
        extRes.setName(aName);
        extRes.setResourceSpecifier((ResourceSpecifier)spec);
        extRes.setExternalResourceBindings(bindings);
        extRes.setExternalResources(descs);
        return extRes;
    }

    public static ExternalResourceDescription createSharedResourceDescription(String aUrl, Class<? extends SharedResourceObject> aInterface, Object ... aParams) {
        return ExternalResourceFactory.createNamedResourceDescriptionUsingUrl(ExternalResourceFactory.uniqueResourceKey(aInterface.getName()), aInterface, aUrl, aParams);
    }

    public static ExternalResourceDescription createSharedResourceDescription(URL aUrl, Class<? extends SharedResourceObject> aInterface, Object ... aParams) {
        return ExternalResourceFactory.createNamedResourceDescriptionUsingUrl(ExternalResourceFactory.uniqueResourceKey(aInterface.getName()), aInterface, aUrl.toString(), aParams);
    }

    public static ExternalResourceDescription createSharedResourceDescription(File aFile, Class<? extends SharedResourceObject> aInterface, Object ... aParams) {
        try {
            return ExternalResourceFactory.createSharedResourceDescription(aFile.toURI().toURL(), aInterface, aParams);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("File converts to illegal URL [" + aFile + "]");
        }
    }

    public static ExternalResourceDescription createNamedResourceDescriptionUsingUrl(String aName, Class<? extends SharedResourceObject> aInterface, String aUrl, Object ... aParams) {
        ArrayList<ExternalResourceBinding> bindings = new ArrayList<ExternalResourceBinding>();
        ArrayList<ExternalResourceDescription> descs = new ArrayList<ExternalResourceDescription>();
        for (Map.Entry<String, ExternalResourceDescription> res : ExternalResourceFactory.extractResourceParameters(aParams).entrySet()) {
            bindings.add(ExternalResourceFactory.createResourceBinding(res.getKey(), res.getValue()));
            descs.add(res.getValue());
        }
        ConfigurationParameterFactory.ConfigurationData cfg = ConfigurationParameterFactory.createConfigurationData(aParams);
        ResourceMetaData_impl meta = new ResourceMetaData_impl();
        ConfigurationParameterFactory.ConfigurationData reflectedConfigurationData = ConfigurationParameterFactory.createConfigurationData(aInterface);
        ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceMetaData)meta, reflectedConfigurationData.configurationParameters, reflectedConfigurationData.configurationValues);
        ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceMetaData)meta, cfg.configurationParameters, cfg.configurationValues);
        ConfigurableDataResourceSpecifier_impl spec = new ConfigurableDataResourceSpecifier_impl();
        spec.setUrl(aUrl);
        spec.setMetaData((ResourceMetaData)meta);
        ExtendedExternalResourceDescription_impl extRes = new ExtendedExternalResourceDescription_impl();
        extRes.setName(aName);
        extRes.setResourceSpecifier((ResourceSpecifier)spec);
        extRes.setImplementationName(aInterface.getName());
        extRes.setExternalResourceBindings(bindings);
        extRes.setExternalResources(descs);
        return extRes;
    }

    public static ExternalResourceDescription createNamedFileResourceDescription(String aName, String aUrl) {
        ExternalResourceDescription_impl extRes = new ExternalResourceDescription_impl();
        extRes.setName(aName);
        FileResourceSpecifier_impl frs = new FileResourceSpecifier_impl();
        frs.setFileUrl(aUrl);
        extRes.setResourceSpecifier((ResourceSpecifier)frs);
        return extRes;
    }

    public static ExternalResourceBinding createResourceBinding(String aKey, ExternalResourceDescription aResource) {
        return ExternalResourceFactory.createResourceBinding(aKey, aResource.getName());
    }

    public static ExternalResourceBinding createResourceBinding(String aKey, String aResourceKey) {
        ExternalResourceBinding extResBind = UIMAFramework.getResourceSpecifierFactory().createExternalResourceBinding();
        extResBind.setResourceName(aResourceKey);
        extResBind.setKey(aKey);
        return extResBind;
    }

    public static ExternalResourceDependency createResourceDependency(Field field) {
        Class<Object> api;
        ExternalResource era = ReflectionUtil.getAnnotation(field, ExternalResource.class);
        String key = era.key();
        if (key.length() == 0) {
            key = field.getName();
        }
        if ((api = era.api()) == Resource.class) {
            api = Resource.class.isAssignableFrom(field.getType()) || SharedResourceObject.class.isAssignableFrom(field.getType()) ? field.getType() : Object.class;
        }
        return ExternalResourceFactory.createResourceDependency(key, api, !era.mandatory(), era.description());
    }

    public static ExternalResourceDependency createResourceDependency(String aKey, Class<?> aInterface, boolean aOptional, String aDescription) {
        ExternalResourceDependency dep = UIMAFramework.getResourceSpecifierFactory().createExternalResourceDependency();
        dep.setInterfaceName(aInterface.getName());
        dep.setKey(aKey);
        dep.setOptional(aOptional);
        dep.setDescription(aDescription);
        return dep;
    }

    public static ExternalResourceDependency[] createResourceDependencies(Class<?> cls) throws ResourceInitializationException {
        HashMap<String, ExternalResourceDependency> depMap = new HashMap<String, ExternalResourceDependency>();
        ExternalResourceFactory.createResourceDependencies(cls, cls, depMap);
        Collection deps = depMap.values();
        return deps.toArray(new ExternalResourceDependency[deps.size()]);
    }

    private static <T> void createResourceDependencies(Class<?> baseCls, Class<?> cls, Map<String, ExternalResourceDependency> dependencies) throws ResourceInitializationException {
        if (cls.getSuperclass() != null) {
            ExternalResourceFactory.createResourceDependencies(baseCls, cls.getSuperclass(), dependencies);
        }
        for (Field field : cls.getDeclaredFields()) {
            if (!ReflectionUtil.isAnnotationPresent(field, ExternalResource.class)) continue;
            ExternalResourceDependency dep = ExternalResourceFactory.createResourceDependency(field);
            if (dependencies.containsKey(dep.getKey())) {
                throw new ResourceInitializationException((Throwable)new IllegalStateException("Key [" + dep.getKey() + "] may only be used on a single field."));
            }
            dependencies.put(dep.getKey(), dep);
        }
    }

    public static void bindResource(ResourceSpecifier aDesc, String aKey, URL aUrl) throws InvalidXMLException {
        ExternalResourceFactory.bindResource(aDesc, aKey, aUrl.toString());
    }

    public static void bindResource(ResourceSpecifier aDesc, String aKey, File aFile) throws InvalidXMLException {
        try {
            ExternalResourceFactory.bindResource(aDesc, aKey, aFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("File converts to illegal URL [" + aFile + "]");
        }
    }

    @Deprecated
    public static void bindResource(ResourceSpecifier aDesc, String aKey, String aUrl) throws InvalidXMLException {
        ExternalResourceFactory.bindResourceUsingUrl(aDesc, aKey, aUrl);
    }

    public static void bindResourceUsingUrl(ResourceSpecifier aDesc, String aKey, String aUrl) throws InvalidXMLException {
        ExternalResourceDescription extRes = ExternalResourceFactory.createNamedFileResourceDescription(aKey, aUrl);
        ExternalResourceFactory.bindResource(aDesc, aKey, extRes);
    }

    public static void bindResource(ResourceSpecifier aDesc, Class<? extends Resource> aRes, String ... aParams) throws InvalidXMLException, ClassNotFoundException {
        ExternalResourceFactory.bindResource(aDesc, aRes, aRes, aParams);
    }

    public static void bindResource(ResourceSpecifier aDesc, Class<?> aApi, Class<? extends Resource> aRes, String ... aParams) throws InvalidXMLException, ClassNotFoundException {
        ExternalResourceDescription extRes = ExternalResourceFactory.createNamedResourceDescription(ExternalResourceFactory.uniqueResourceKey(aRes.getName()), aRes, aParams);
        ExternalResourceFactory.bindResource(aDesc, extRes);
    }

    public static void bindResourceUsingUrl(ResourceSpecifier aDesc, Class<? extends SharedResourceObject> aRes, String aUrl, Object ... aParams) throws InvalidXMLException, ClassNotFoundException {
        ExternalResourceDescription extRes = ExternalResourceFactory.createNamedResourceDescriptionUsingUrl(ExternalResourceFactory.uniqueResourceKey(aRes.getName()), aRes, aUrl, aParams);
        ExternalResourceFactory.scanRecursivelyForDependenciesByInterfaceAndBind((AnalysisEngineDescription)aDesc, extRes);
    }

    public static void bindResourceUsingUrl(ResourceSpecifier aDesc, Class<?> aApi, Class<? extends SharedResourceObject> aRes, String aUrl, Object ... aParams) throws InvalidXMLException {
        ExternalResourceFactory.bindResourceUsingUrl(aDesc, aApi.getName(), aRes, aUrl, aParams);
    }

    public static void bindResourceUsingUrl(ResourceSpecifier aDesc, String aKey, Class<? extends SharedResourceObject> aRes, String aUrl, Object ... aParams) throws InvalidXMLException {
        ExternalResourceDescription extRes = ExternalResourceFactory.createNamedResourceDescriptionUsingUrl(ExternalResourceFactory.uniqueResourceKey(aRes.getName()), aRes, aUrl, aParams);
        ExternalResourceFactory.scanRecursivelyForDependenciesByKeyAndBind((AnalysisEngineDescription)aDesc, aKey, extRes);
    }

    public static void bindResource(ResourceSpecifier aDesc, String aKey, Class<? extends Resource> aRes, String ... aParams) throws InvalidXMLException {
        if (ParameterizedDataResource.class.isAssignableFrom(aRes)) {
            ExternalResourceFactory.createDependency(aDesc, aKey, DataResource.class);
        }
        ExternalResourceDescription extRes = ExternalResourceFactory.createNamedResourceDescription(ExternalResourceFactory.uniqueResourceKey(aRes.getName()), aRes, aParams);
        ExternalResourceFactory.bindResource(aDesc, aKey, extRes);
    }

    public static void bindResource(ResourceSpecifier aDesc, ExternalResourceDescription aResDesc) throws InvalidXMLException, ClassNotFoundException {
        if (aDesc instanceof AnalysisEngineDescription) {
            ExternalResourceFactory.scanRecursivelyForDependenciesByInterfaceAndBind((AnalysisEngineDescription)aDesc, aResDesc);
        }
    }

    public static void bindResource(ResourceSpecifier aDesc, String aKey, ExternalResourceDescription aResDesc) throws InvalidXMLException {
        if (aDesc instanceof AnalysisEngineDescription) {
            ExternalResourceFactory.scanRecursivelyForDependenciesByKeyAndBind((AnalysisEngineDescription)aDesc, aKey, aResDesc);
        }
    }

    public static void createDependencyAndBind(ResourceSpecifier aDesc, String aKey, Class<? extends Resource> aImpl, String ... aParams) throws InvalidXMLException {
        Class api = ParameterizedDataResource.class.isAssignableFrom(aImpl) ? DataResource.class : aImpl;
        ExternalResourceFactory.createDependencyAndBind(aDesc, aKey, aImpl, api, aParams);
    }

    public static void createDependencyAndBind(ResourceSpecifier aDesc, String aKey, Class<? extends Resource> aImpl, Class<?> aApi, String ... aParams) throws InvalidXMLException {
        ExternalResourceFactory.createDependency(aDesc, aKey, aApi);
        ExternalResourceFactory.bindResource(aDesc, aKey, aImpl, aParams);
    }

    public static void createDependency(ResourceSpecifier aDesc, String aKey, Class<?> aApi) {
        Object[] deps = ExternalResourceFactory.getResourceDependencies(aDesc);
        if (deps == null) {
            deps = new ExternalResourceDependency[]{};
        }
        boolean found = false;
        for (ExternalResourceDependency externalResourceDependency : deps) {
            if (!externalResourceDependency.getKey().equals(aKey)) continue;
            found = true;
            break;
        }
        if (!found) {
            ExternalResourceFactory.setResourceDependencies(aDesc, (ExternalResourceDependency[])ArrayUtils.add((Object[])deps, (Object)ExternalResourceFactory.createResourceDependency(aKey, aApi, false, null)));
        }
    }

    private static void setResourceDependencies(ResourceSpecifier aDesc, ExternalResourceDependency[] aDependencies) {
        if (aDesc instanceof CollectionReaderDescription) {
            ((CollectionReaderDescription)aDesc).setExternalResourceDependencies(aDependencies);
        } else if (aDesc instanceof AnalysisEngineDescription) {
            ((AnalysisEngineDescription)aDesc).setExternalResourceDependencies(aDependencies);
        } else {
            throw new IllegalArgumentException("Resource specified cannot have external resource dependencies");
        }
    }

    private static ExternalResourceDependency[] getResourceDependencies(ResourceSpecifier aDesc) {
        if (aDesc instanceof CollectionReaderDescription) {
            return ((CollectionReaderDescription)aDesc).getExternalResourceDependencies();
        }
        if (aDesc instanceof AnalysisEngineDescription) {
            return ((AnalysisEngineDescription)aDesc).getExternalResourceDependencies();
        }
        throw new IllegalArgumentException("Resource specified cannot have external resource dependencies");
    }

    public static void createDependencyAndBindUsingUrl(AnalysisEngineDescription aDesc, String aKey, Class<? extends SharedResourceObject> aImpl, String aUrl, Object ... aParams) throws InvalidXMLException {
        if (aDesc.getExternalResourceDependency(aKey) == null) {
            Object[] deps = aDesc.getExternalResourceDependencies();
            if (deps == null) {
                deps = new ExternalResourceDependency[]{};
            }
            aDesc.setExternalResourceDependencies((ExternalResourceDependency[])ArrayUtils.add((Object[])deps, (Object)ExternalResourceFactory.createResourceDependency(aKey, aImpl, false, null)));
        }
        ExternalResourceFactory.bindResourceUsingUrl((ResourceSpecifier)aDesc, aKey, aImpl, aUrl, aParams);
    }

    private static void scanRecursivelyForDependenciesByInterfaceAndBind(AnalysisEngineDescription aDesc, ExternalResourceDescription aResDesc) throws InvalidXMLException, ClassNotFoundException {
        if (!aDesc.isPrimitive()) {
            for (ResourceSpecifier delegate : aDesc.getDelegateAnalysisEngineSpecifiers().values()) {
                ExternalResourceFactory.bindResource(delegate, aResDesc);
            }
        }
        Class<?> resClass = Class.forName(ExternalResourceFactory.getImplementationName(aResDesc));
        for (ExternalResourceDependency dep : aDesc.getExternalResourceDependencies()) {
            Class<?> apiClass = Class.forName(dep.getInterfaceName());
            if (apiClass.equals(Object.class) || !apiClass.isAssignableFrom(resClass)) continue;
            ExternalResourceFactory.bindResourceOnce((ResourceCreationSpecifier)aDesc, dep.getKey(), aResDesc);
        }
    }

    private static void scanRecursivelyForDependenciesByKeyAndBind(AnalysisEngineDescription aDesc, String aKey, ExternalResourceDescription aResDesc) throws InvalidXMLException {
        if (!aDesc.isPrimitive()) {
            for (ResourceSpecifier delegate : aDesc.getDelegateAnalysisEngineSpecifiers().values()) {
                ExternalResourceFactory.bindResource(delegate, aKey, aResDesc);
            }
        }
        for (ExternalResourceDependency dep : aDesc.getExternalResourceDependencies()) {
            if (!aKey.equals(dep.getKey())) continue;
            ExternalResourceFactory.bindResourceOnce((ResourceCreationSpecifier)aDesc, aKey, aResDesc);
        }
    }

    @Deprecated
    public static void bindResource(ResourceManagerConfiguration aResMgrCfg, String aBindTo, ExternalResourceDescription aRes) {
        ExternalResourceFactory.bindResourceOnce(aResMgrCfg, aBindTo, aRes);
    }

    public static void bindResourceOnce(ResourceManagerConfiguration aResMgrCfg, String aBindTo, ExternalResourceDescription aRes) {
        HashMap<String, ExternalResourceBinding> bindings = new HashMap<String, ExternalResourceBinding>();
        for (ExternalResourceBinding b : aResMgrCfg.getExternalResourceBindings()) {
            bindings.put(b.getKey(), b);
        }
        HashMap<String, ExternalResourceDescription> resources = new HashMap<String, ExternalResourceDescription>();
        for (ExternalResourceDescription r : aResMgrCfg.getExternalResources()) {
            resources.put(r.getName(), r);
        }
        ExternalResourceBinding extResBind = ExternalResourceFactory.createResourceBinding(aBindTo, aRes);
        bindings.put(extResBind.getKey(), extResBind);
        resources.put(aRes.getName(), aRes);
        ExternalResourceFactory.bindNestedResources(aRes, bindings, resources);
        aResMgrCfg.setExternalResourceBindings(bindings.values().toArray(new ExternalResourceBinding[bindings.size()]));
        aResMgrCfg.setExternalResources(resources.values().toArray(new ExternalResourceDescription[resources.size()]));
    }

    @Deprecated
    public static void bindResource(ExternalResourceDescription aRes, String aBindTo, ExternalResourceDescription aNestedRes) {
        ExternalResourceFactory.bindResourceOnce(aRes, aBindTo, aNestedRes);
    }

    public static void bindResourceOnce(ExternalResourceDescription aRes, String aBindTo, ExternalResourceDescription aNestedRes) {
        if (!(aRes instanceof ExtendedExternalResourceDescription_impl)) {
            throw new IllegalArgumentException("Nested resources are only supported on instances of [" + ExtendedExternalResourceDescription_impl.class.getName() + "] whichcan be created with uimaFIT's createExternalResourceDescription() methods.");
        }
        ExtendedExternalResourceDescription_impl extRes = (ExtendedExternalResourceDescription_impl)aRes;
        HashMap<String, ExternalResourceBinding> bindings = new HashMap<String, ExternalResourceBinding>();
        for (ExternalResourceBinding externalResourceBinding : extRes.getExternalResourceBindings()) {
            bindings.put(externalResourceBinding.getKey(), externalResourceBinding);
        }
        HashMap<String, ExternalResourceDescription> resources = new HashMap<String, ExternalResourceDescription>();
        for (ExternalResourceDescription r : extRes.getExternalResources()) {
            resources.put(r.getName(), r);
        }
        ExternalResourceBinding externalResourceBinding = ExternalResourceFactory.createResourceBinding(aBindTo, aNestedRes);
        bindings.put(externalResourceBinding.getKey(), externalResourceBinding);
        resources.put(aNestedRes.getName(), aNestedRes);
        ExternalResourceFactory.bindNestedResources(aRes, bindings, resources);
        extRes.setExternalResourceBindings(bindings.values());
        extRes.setExternalResources(resources.values());
    }

    private static void bindNestedResources(ExternalResourceDescription aRes, Map<String, ExternalResourceBinding> aBindings, Map<String, ExternalResourceDescription> aResources) {
        if (aRes instanceof ExtendedExternalResourceDescription_impl) {
            ExtendedExternalResourceDescription_impl extRes = (ExtendedExternalResourceDescription_impl)aRes;
            if (ConfigurationParameterFactory.canParameterBeSet(extRes.getResourceSpecifier(), PARAM_RESOURCE_NAME)) {
                ConfigurationParameterFactory.setParameter(extRes.getResourceSpecifier(), PARAM_RESOURCE_NAME, aRes.getName());
            }
            HashMap<String, ExternalResourceDescription> res = new HashMap<String, ExternalResourceDescription>();
            for (ExternalResourceDescription r : extRes.getExternalResources()) {
                res.put(r.getName(), r);
            }
            for (ExternalResourceBinding b : extRes.getExternalResourceBindings()) {
                String key = b.getKey();
                if (!key.startsWith(aRes.getName() + PREFIX_SEPARATOR)) {
                    key = aRes.getName() + PREFIX_SEPARATOR + b.getKey();
                }
                if (aBindings.containsKey(key)) continue;
                aBindings.put(key, b);
                ExternalResourceDescription nestedRes = (ExternalResourceDescription)res.get(b.getResourceName());
                aResources.put(nestedRes.getName(), nestedRes);
                ExternalResourceFactory.bindNestedResources(nestedRes, aBindings, aResources);
                b.setKey(key);
            }
        }
    }

    public static void bindResourceOnce(ResourceCreationSpecifier aDesc, String aBindTo, ExternalResourceDescription aRes) {
        ResourceManagerConfiguration resMgrCfg = aDesc.getResourceManagerConfiguration();
        if (resMgrCfg == null) {
            resMgrCfg = new ResourceManagerConfiguration_impl();
            aDesc.setResourceManagerConfiguration(resMgrCfg);
        }
        ExternalResourceFactory.bindResourceOnce(resMgrCfg, aBindTo, aRes);
    }

    @Deprecated
    public static void bindResource(ResourceManagerConfiguration aResMgrCfg, String aBindTo, String aRes) {
        ExternalResourceFactory.bindResourceOnceWithoutNested(aResMgrCfg, aBindTo, aRes);
    }

    public static void bindResourceOnceWithoutNested(ResourceManagerConfiguration aResMgrCfg, String aBindTo, String aRes) {
        ExternalResourceBinding extResBind = ExternalResourceFactory.createResourceBinding(aBindTo, aRes);
        aResMgrCfg.addExternalResourceBinding(extResBind);
    }

    public static void bindResourceOnceWithoutNested(ResourceCreationSpecifier aDesc, String aBindTo, String aRes) {
        ResourceManagerConfiguration resMgrCfg = aDesc.getResourceManagerConfiguration();
        if (resMgrCfg == null) {
            resMgrCfg = new ResourceManagerConfiguration_impl();
            aDesc.setResourceManagerConfiguration(resMgrCfg);
        }
        ExternalResourceFactory.bindResourceOnceWithoutNested(resMgrCfg, aBindTo, aRes);
    }

    static String uniqueResourceKey(String aKey) {
        return aKey + '-' + DISAMBIGUATOR.getAndIncrement();
    }

    protected static String getImplementationName(ExternalResourceDescription aDesc) {
        if (aDesc.getResourceSpecifier() instanceof CustomResourceSpecifier) {
            return ((CustomResourceSpecifier)aDesc.getResourceSpecifier()).getResourceClassName();
        }
        return aDesc.getImplementationName();
    }

    protected static Map<String, ExternalResourceDescription> extractResourceParameters(Object[] configurationData) {
        if (configurationData == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ExternalResourceDescription> extRes = new HashMap<String, ExternalResourceDescription>();
        for (int i = 0; i < configurationData.length - 1; i += 2) {
            String key = (String)configurationData[i];
            Object value = configurationData[i + 1];
            if (value == null) continue;
            ResourceValueType type = ExternalResourceFactory.getResourceParameterType(value);
            if (type == ResourceValueType.PRIMITIVE) {
                ExternalResourceDescription description = (ExternalResourceDescription)value;
                extRes.put(key, description);
                continue;
            }
            if (!type.isMultiValued()) continue;
            List<ExternalResourceDescription> resList = type == ResourceValueType.ARRAY ? Arrays.asList((ExternalResourceDescription[])value) : (List<ExternalResourceDescription>)value;
            ArrayList<String> params = new ArrayList<String>();
            params.add("size");
            params.add(String.valueOf(resList.size()));
            int n = 0;
            for (ExternalResourceDescription res : resList) {
                params.add("ELEMENT[" + n + "]");
                params.add((String)res);
                ++n;
            }
            extRes.put(key, ExternalResourceFactory.createResourceDescription(ResourceList.class, params.toArray()));
        }
        return extRes;
    }

    static ResourceValueType getResourceParameterType(Object aValue) {
        boolean isResourceCollection;
        if (aValue == null) {
            return ResourceValueType.NO_RESOURCE;
        }
        boolean isResourcePrimitive = aValue instanceof ExternalResourceDescription;
        boolean isResourceArray = aValue.getClass().isArray() && ExternalResourceDescription.class.isAssignableFrom(aValue.getClass().getComponentType());
        boolean bl = isResourceCollection = Collection.class.isAssignableFrom(aValue.getClass()) && !((Collection)aValue).isEmpty() && ((Collection)aValue).iterator().next() instanceof ExternalResourceDescription;
        if (isResourcePrimitive) {
            return ResourceValueType.PRIMITIVE;
        }
        if (isResourceArray) {
            return ResourceValueType.ARRAY;
        }
        if (isResourceCollection) {
            return ResourceValueType.COLLECTION;
        }
        return ResourceValueType.NO_RESOURCE;
    }

    public static <R extends Resource> R createResource(Class<R> resourceClass, Object ... params) throws ResourceInitializationException {
        return ExternalResourceFactory.createResource(resourceClass, null, params);
    }

    public static <R extends Resource> R createResource(Class<R> resourceClass, ResourceManager resMgr, Object ... params) throws ResourceInitializationException {
        ExternalResourceDescription res = ExternalResourceFactory.createResourceDescription(resourceClass, params);
        return (R)UIMAFramework.produceResource(resourceClass, (ResourceSpecifier)res.getResourceSpecifier(), (ResourceManager)resMgr, Collections.emptyMap());
    }

    static enum ResourceValueType {
        NO_RESOURCE,
        PRIMITIVE,
        ARRAY,
        COLLECTION;


        public boolean isMultiValued() {
            return this == COLLECTION || this == ARRAY;
        }
    }
}

