/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.scheduler;

import org.apache.activemq.broker.scheduler.Job;
import org.apache.activemq.broker.scheduler.JobSupport;
import org.apache.activemq.store.kahadb.scheduler.JobLocation;
import org.apache.activemq.util.ByteSequence;

public class JobImpl
implements Job {
    private final JobLocation jobLocation;
    private final byte[] payload;
    private String destinationName;

    protected JobImpl(JobLocation location, ByteSequence bs) {
        this.jobLocation = location;
        this.payload = new byte[bs.getLength()];
        System.arraycopy(bs.getData(), bs.getOffset(), this.payload, 0, bs.getLength());
    }

    public String getJobId() {
        return this.jobLocation.getJobId();
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public long getPeriod() {
        return this.jobLocation.getPeriod();
    }

    public int getRepeat() {
        return this.jobLocation.getRepeat();
    }

    public long getStart() {
        return this.jobLocation.getStartTime();
    }

    public long getDelay() {
        return this.jobLocation.getDelay();
    }

    public String getCronEntry() {
        return this.jobLocation.getCronEntry();
    }

    public String getNextExecutionTime() {
        return JobSupport.getDateTime((long)this.jobLocation.getNextTime());
    }

    public String getStartTime() {
        return JobSupport.getDateTime((long)this.getStart());
    }

    public int getExecutionCount() {
        return this.jobLocation.getRescheduledCount();
    }

    public String toString() {
        return "Job: " + this.getJobId();
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }
}

