/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.result.Result;

public class StatementExpression
extends StatementDMQL {
    Expression expression;

    StatementExpression(Session session, ParserDQL.CompileContext compileContext, int n, Expression expression) {
        super(n, 2007, null);
        switch (n) {
            case 62: 
            case 1211: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "");
            }
        }
        this.isTransactionStatement = false;
        this.expression = expression;
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case 62: {
                return this.sql;
            }
            case 1211: {
                stringBuilder.append(this.expression.getSQL());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    TableDerived[] getSubqueries(Session session) {
        OrderedHashSet<TableDerived> orderedHashSet = null;
        if (this.expression != null) {
            orderedHashSet = this.expression.collectAllSubqueries(null);
        }
        if (orderedHashSet == null || orderedHashSet.isEmpty()) {
            return TableDerived.emptyArray;
        }
        TableDerived[] tableDerivedArray = new TableDerived[orderedHashSet.size()];
        orderedHashSet.toArray(tableDerivedArray);
        for (int i = 0; i < this.subqueries.length; ++i) {
            tableDerivedArray[i].prepareTable(session);
        }
        return tableDerivedArray;
    }

    protected String describe(Session session, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("STATEMENT");
        return stringBuilder.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        switch (this.type) {
            case 62: 
            case 1211: {
                Result result = this.expression.getResult(session);
                if (result.isData()) {
                    RowSetNavigatorData rowSetNavigatorData = new RowSetNavigatorData(session, result.getNavigator());
                    result.setNavigator(rowSetNavigatorData);
                }
                return result;
            }
        }
        throw Error.runtimeError(201, "");
    }

    @Override
    public void resolve(Session session) {
    }

    @Override
    String describeImpl(Session session) {
        return this.getSQL();
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
        int n;
        for (n = 0; n < this.subqueries.length; ++n) {
            if (this.subqueries[n].queryExpression == null) continue;
            this.subqueries[n].queryExpression.getBaseTableNames(orderedHashSet);
        }
        for (n = 0; n < this.routines.length; ++n) {
            orderedHashSet.addAll((HsqlNameManager.HsqlName[])this.routines[n].getTableNamesForRead());
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
    }
}

