/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.util.zip.Checksum;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.MutableCheckedOutputStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.DiskBlockObjectWriter;
import org.apache.spark.storage.DiskBlockObjectWriter$;
import org.apache.spark.storage.FileSegment;
import org.apache.spark.storage.TimeTrackingOutputStream;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.collection.PairsWriter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tug!\u0002*T\u0001U[\u0006\u0002\u0003:\u0001\u0005\u000b\u0007I\u0011\u0001;\t\u0011a\u0004!\u0011!Q\u0001\nUD\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\u000b\u0003\u0003\u0001!\u0011!Q\u0001\n\u0005\r\u0001BCA\u0005\u0001\t\u0005\t\u0015!\u0003\u0002\f!Q\u0011q\u0003\u0001\u0003\u0002\u0003\u0006I!!\u0007\t\u0015\u0005}\u0001A!A!\u0002\u0013\t\t\u0003\u0003\u0006\u0002.\u0001\u0011)\u0019!C\u0001\u0003_A!\"!\u000f\u0001\u0005\u0003\u0005\u000b\u0011BA\u0019\u0011\u001d\tY\u0004\u0001C\u0001\u0003{1\u0011\"a\u0014\u0001!\u0003\rI!!\u0015\t\u000f\u0005M3\u0002\"\u0001\u0002V!A\u0011QL\u0006\u0011\n\u0003\t)\u0006C\u0004\u0002`-!\t!!\u0016\t\u001d\u0005\u00054\u0002%A\u0002\u0002\u0003%I!!\u0016\u0002d!I\u0011Q\r\u0001A\u0002\u0013%\u0011q\r\u0005\n\u0003s\u0002\u0001\u0019!C\u0005\u0003wB\u0001\"!!\u0001A\u0003&\u0011\u0011\u000e\u0005\n\u0003\u0007\u0003\u0001\u0019!C\u0005\u0003\u000bC\u0011\"a#\u0001\u0001\u0004%I!!$\t\u0011\u0005E\u0005\u0001)Q\u0005\u0003\u000fC\u0011\"a%\u0001\u0001\u0004%I!!&\t\u0013\u0005]\u0005\u00011A\u0005\n\u0005e\u0005bBAO\u0001\u0001\u0006K\u0001\u0018\u0005\n\u0003?\u0003\u0001\u0019!C\u0005\u0003CC\u0011\"!+\u0001\u0001\u0004%I!a+\t\u0011\u0005=\u0006\u0001)Q\u0005\u0003GC\u0011\"!-\u0001\u0001\u0004%I!a-\t\u0013\u0005m\u0006\u00011A\u0005\n\u0005u\u0006\u0002CAa\u0001\u0001\u0006K!!.\t\u0013\u0005\r\u0007\u00011A\u0005\n\u0005\u0015\u0007\"CAg\u0001\u0001\u0007I\u0011BAh\u0011!\t\u0019\u000e\u0001Q!\n\u0005\u001d\u0007\"CAk\u0001\u0001\u0007I\u0011BAl\u0011%\tI\u000e\u0001a\u0001\n\u0013\tY\u000e\u0003\u0005\u0002`\u0002\u0001\u000b\u0015BA\r\u0011%\t\t\u000f\u0001a\u0001\n\u0013\t9\u000eC\u0005\u0002d\u0002\u0001\r\u0011\"\u0003\u0002f\"A\u0011\u0011\u001e\u0001!B\u0013\tI\u0002C\u0005\u0002l\u0002\u0001\r\u0011\"\u0003\u0002X\"I\u0011Q\u001e\u0001A\u0002\u0013%\u0011q\u001e\u0005\t\u0003g\u0004\u0001\u0015)\u0003\u0002\u001a!I\u0011Q\u001f\u0001A\u0002\u0013%\u0011q\u001b\u0005\n\u0003o\u0004\u0001\u0019!C\u0005\u0003sD\u0001\"!@\u0001A\u0003&\u0011\u0011\u0004\u0005\f\u0003\u007f\u0004\u0001\u0019!a\u0001\n\u0013\u0011\t\u0001C\u0006\u0003\u000e\u0001\u0001\r\u00111A\u0005\n\t=\u0001b\u0003B\n\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0007A1B!\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0018!Y!q\u0005\u0001A\u0002\u0003\u0007I\u0011\u0002B\u0015\u0011-\u0011i\u0003\u0001a\u0001\u0002\u0003\u0006KA!\u0007\t\u0013\t=\u0002\u00011A\u0005\n\tE\u0002\"\u0003B\u001d\u0001\u0001\u0007I\u0011\u0002B\u001e\u0011!\u0011y\u0004\u0001Q!\n\tM\u0002\"\u0003B!\u0001\u0001\u0007I\u0011\u0002B\u0019\u0011%\u0011\u0019\u0005\u0001a\u0001\n\u0013\u0011)\u0005\u0003\u0005\u0003J\u0001\u0001\u000b\u0015\u0002B\u001a\u0011%\u0011Y\u0005\u0001a\u0001\n\u0013\u0011i\u0005C\u0005\u0003P\u0001\u0001\r\u0011\"\u0003\u0003R!A!Q\u000b\u0001!B\u0013\tY\u0001C\u0005\u0003X\u0001\u0001\r\u0011\"\u0003\u00032!I!\u0011\f\u0001A\u0002\u0013%!1\f\u0005\t\u0005?\u0002\u0001\u0015)\u0003\u00034!9!\u0011\r\u0001\u0005\u0002\t\r\u0004b\u0002B4\u0001\u0011%\u0011Q\u000b\u0005\b\u0005S\u0002A\u0011\u0001B6\u0011\u001d\u0011i\u0007\u0001C\u0005\u0003+Bq!!\u0018\u0001\t\u0003\n)\u0006C\u0004\u0003p\u0001!\tA!\u001d\t\u000f\te\u0004\u0001\"\u0001\u0003|!9!Q\u0010\u0001\u0005\u0002\u0005U\u0003b\u0002B@\u0001\u0011\u0005#\u0011\u0011\u0005\b\u0005\u007f\u0002A\u0011\tBI\u0011\u001d\u0011y\b\u0001C!\u0005/CqA!-\u0001\t\u0003\t)\u0006C\u0004\u00034\u0002!I!!\u0016\t\u000f\tU\u0006\u0001\"\u0011\u0002V\u001dQ!qW*\u0002\u0002#\u0005QK!/\u0007\u0013I\u001b\u0016\u0011!E\u0001+\nm\u0006bBA\u001e\u001f\u0012\u0005!1\u0019\u0005\n\u0005\u000b|\u0015\u0013!C\u0001\u0005\u000f\u0014Q\u0003R5tW\ncwnY6PE*,7\r^,sSR,'O\u0003\u0002U+\u000691\u000f^8sC\u001e,'B\u0001,X\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0016,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0006\u0019qN]4\u0014\t\u0001aFM\u001b\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\f!![8\u000b\u0003\u0005\fAA[1wC&\u00111M\u0018\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\t\u0003K\"l\u0011A\u001a\u0006\u0003OV\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003S\u001a\u0014q\u0001T8hO&tw\r\u0005\u0002la6\tAN\u0003\u0002n]\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005=,\u0016\u0001B;uS2L!!\u001d7\u0003\u0017A\u000b\u0017N]:Xe&$XM]\u0001\u0005M&dWm\u0001\u0001\u0016\u0003U\u0004\"!\u0018<\n\u0005]t&\u0001\u0002$jY\u0016\fQAZ5mK\u0002\n\u0011c]3sS\u0006d\u0017N_3s\u001b\u0006t\u0017mZ3s!\tYh0D\u0001}\u0015\tiX+\u0001\u0006tKJL\u0017\r\\5{KJL!a ?\u0003#M+'/[1mSj,'/T1oC\u001e,'/\u0001\ntKJL\u0017\r\\5{KJLen\u001d;b]\u000e,\u0007cA>\u0002\u0006%\u0019\u0011q\u0001?\u0003%M+'/[1mSj,'/\u00138ti\u0006t7-Z\u0001\u000bEV4g-\u001a:TSj,\u0007\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0005\u0005E\u0011!B:dC2\f\u0017\u0002BA\u000b\u0003\u001f\u00111!\u00138u\u0003)\u0019\u0018P\\2Xe&$Xm\u001d\t\u0005\u0003\u001b\tY\"\u0003\u0003\u0002\u001e\u0005=!a\u0002\"p_2,\u0017M\\\u0001\roJLG/Z'fiJL7m\u001d\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE+\u0002\u000fMDWO\u001a4mK&!\u00111FA\u0013\u0005m\u0019\u0006.\u001e4gY\u0016<&/\u001b;f\u001b\u0016$(/[2t%\u0016\u0004xN\u001d;fe\u00069!\r\\8dW&#WCAA\u0019!\u0011\t\u0019$!\u000e\u000e\u0003MK1!a\u000eT\u0005\u001d\u0011En\\2l\u0013\u0012\f\u0001B\u00197pG.LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005}\u0012\u0011IA\"\u0003\u000b\n9%!\u0013\u0002L\u00055\u0003cAA\u001a\u0001!)!O\u0003a\u0001k\")\u0011P\u0003a\u0001u\"9\u0011\u0011\u0001\u0006A\u0002\u0005\r\u0001bBA\u0005\u0015\u0001\u0007\u00111\u0002\u0005\b\u0003/Q\u0001\u0019AA\r\u0011\u001d\tyB\u0003a\u0001\u0003CA\u0011\"!\f\u000b!\u0003\u0005\r!!\r\u0003/5\u000bg.^1m\u00072|7/Z(viB,Ho\u0015;sK\u0006l7CA\u0006]\u0003\u0019!\u0013N\\5uIQ\u0011\u0011q\u000b\t\u0005\u0003\u001b\tI&\u0003\u0003\u0002\\\u0005=!\u0001B+oSR\fQa\u00197pg\u0016\f1\"\\1ok\u0006d7\t\\8tK\u0006Y1/\u001e9fe\u0012\u001aGn\\:f\u0013\r\tiFY\u0001\bG\"\fgN\\3m+\t\tI\u0007\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\u0011\rD\u0017M\u001c8fYNT1!a\u001da\u0003\rq\u0017n\\\u0005\u0005\u0003o\niGA\u0006GS2,7\t[1o]\u0016d\u0017aC2iC:tW\r\\0%KF$B!a\u0016\u0002~!I\u0011qP\t\u0002\u0002\u0003\u0007\u0011\u0011N\u0001\u0004q\u0012\n\u0014\u0001C2iC:tW\r\u001c\u0011\u0002\u00075\u001c7/\u0006\u0002\u0002\bB\u0019\u0011\u0011R\u0006\u000e\u0003\u0001\tq!\\2t?\u0012*\u0017\u000f\u0006\u0003\u0002X\u0005=\u0005\"CA@)\u0005\u0005\t\u0019AAD\u0003\u0011i7m\u001d\u0011\u0002\u0005\t\u001cX#\u0001/\u0002\r\t\u001cx\fJ3r)\u0011\t9&a'\t\u0011\u0005}t#!AA\u0002q\u000b1AY:!\u0003\r1wn]\u000b\u0003\u0003G\u00032!XAS\u0013\r\t9K\u0018\u0002\u0011\r&dWmT;uaV$8\u000b\u001e:fC6\fqAZ8t?\u0012*\u0017\u000f\u0006\u0003\u0002X\u00055\u0006\"CA@5\u0005\u0005\t\u0019AAR\u0003\u00111wn\u001d\u0011\u0002\u0005Q\u001cXCAA[!\u0011\t\u0019$a.\n\u0007\u0005e6K\u0001\rUS6,GK]1dW&twmT;uaV$8\u000b\u001e:fC6\fa\u0001^:`I\u0015\fH\u0003BA,\u0003\u007fC\u0011\"a \u001e\u0003\u0003\u0005\r!!.\u0002\u0007Q\u001c\b%\u0001\u0004pE*|U\u000f^\u000b\u0003\u0003\u000f\u00042a_Ae\u0013\r\tY\r \u0002\u0014'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8TiJ,\u0017-\\\u0001\u000b_\nTw*\u001e;`I\u0015\fH\u0003BA,\u0003#D\u0011\"a !\u0003\u0003\u0005\r!a2\u0002\u000f=\u0014'nT;uA\u0005Y\u0011N\\5uS\u0006d\u0017N_3e+\t\tI\"A\bj]&$\u0018.\u00197ju\u0016$w\fJ3r)\u0011\t9&!8\t\u0013\u0005}4%!AA\u0002\u0005e\u0011\u0001D5oSRL\u0017\r\\5{K\u0012\u0004\u0013AC:ue\u0016\fWn\u00149f]\u0006q1\u000f\u001e:fC6|\u0005/\u001a8`I\u0015\fH\u0003BA,\u0003OD\u0011\"a '\u0003\u0003\u0005\r!!\u0007\u0002\u0017M$(/Z1n\u001fB,g\u000eI\u0001\u000eQ\u0006\u001c()Z3o\u00072|7/\u001a3\u0002#!\f7OQ3f]\u000ecwn]3e?\u0012*\u0017\u000f\u0006\u0003\u0002X\u0005E\b\"CA@S\u0005\u0005\t\u0019AA\r\u00039A\u0017m\u001d\"fK:\u001cEn\\:fI\u0002\nqb\u00195fG.\u001cX/\\#oC\ndW\rZ\u0001\u0014G\",7m[:v[\u0016s\u0017M\u00197fI~#S-\u001d\u000b\u0005\u0003/\nY\u0010C\u0005\u0002\u00001\n\t\u00111\u0001\u0002\u001a\u0005\u00012\r[3dWN,X.\u00128bE2,G\rI\u0001\u0015G\",7m[:v[>+H\u000f];u'R\u0014X-Y7\u0016\u0005\t\r\u0001\u0003\u0002B\u0003\u0005\u0013i!Aa\u0002\u000b\u0005}+\u0016\u0002\u0002B\u0006\u0005\u000f\u0011!$T;uC\ndWm\u00115fG.,GmT;uaV$8\u000b\u001e:fC6\f\u0001d\u00195fG.\u001cX/\\(viB,Ho\u0015;sK\u0006lw\fJ3r)\u0011\t9F!\u0005\t\u0013\u0005}t&!AA\u0002\t\r\u0011!F2iK\u000e\\7/^7PkR\u0004X\u000f^*ue\u0016\fW\u000eI\u0001\tG\",7m[:v[V\u0011!\u0011\u0004\t\u0005\u00057\u0011\u0019#\u0004\u0002\u0003\u001e)!!q\u0004B\u0011\u0003\rQ\u0018\u000e\u001d\u0006\u0003_\u0002LAA!\n\u0003\u001e\tA1\t[3dWN,X.\u0001\u0007dQ\u0016\u001c7n];n?\u0012*\u0017\u000f\u0006\u0003\u0002X\t-\u0002\"CA@e\u0005\u0005\t\u0019\u0001B\r\u0003%\u0019\u0007.Z2lgVl\u0007%A\td_6l\u0017\u000e\u001e;fIB{7/\u001b;j_:,\"Aa\r\u0011\t\u00055!QG\u0005\u0005\u0005o\tyA\u0001\u0003M_:<\u0017!F2p[6LG\u000f^3e!>\u001c\u0018\u000e^5p]~#S-\u001d\u000b\u0005\u0003/\u0012i\u0004C\u0005\u0002\u0000U\n\t\u00111\u0001\u00034\u0005\u00112m\\7nSR$X\r\u001a)pg&$\u0018n\u001c8!\u0003A\u0011X\r]8si\u0016$\u0007k\\:ji&|g.\u0001\u000bsKB|'\u000f^3e!>\u001c\u0018\u000e^5p]~#S-\u001d\u000b\u0005\u0003/\u00129\u0005C\u0005\u0002\u0000a\n\t\u00111\u0001\u00034\u0005\t\"/\u001a9peR,G\rU8tSRLwN\u001c\u0011\u0002#9,XNU3d_J$7o\u0016:jiR,g.\u0006\u0002\u0002\f\u0005)b.^7SK\u000e|'\u000fZ:Xe&$H/\u001a8`I\u0015\fH\u0003BA,\u0005'B\u0011\"a <\u0003\u0003\u0005\r!a\u0003\u0002%9,XNU3d_J$7o\u0016:jiR,g\u000eI\u0001\u0014]Vl'+Z2pe\u0012\u001c8i\\7nSR$X\rZ\u0001\u0018]Vl'+Z2pe\u0012\u001c8i\\7nSR$X\rZ0%KF$B!a\u0016\u0003^!I\u0011q\u0010 \u0002\u0002\u0003\u0007!1G\u0001\u0015]Vl'+Z2pe\u0012\u001c8i\\7nSR$X\r\u001a\u0011\u0002\u0017M,Go\u00115fG.\u001cX/\u001c\u000b\u0005\u0003/\u0012)\u0007C\u0004\u0003\u0016\u0001\u0003\rA!\u0007\u0002\u0015%t\u0017\u000e^5bY&TX-\u0001\u0003pa\u0016tGCAA \u00039\u0019Gn\\:f%\u0016\u001cx.\u001e:dKN\fAbY8n[&$\u0018I\u001c3HKR$\"Aa\u001d\u0011\t\u0005M\"QO\u0005\u0004\u0005o\u001a&a\u0003$jY\u0016\u001cVmZ7f]R\f1D]3wKJ$\b+\u0019:uS\u0006dwK]5uKN\fe\u000eZ\"m_N,G#A;\u0002\u001d\rdwn]3B]\u0012$U\r\\3uK\u0006)qO]5uKR1\u0011q\u000bBB\u0005\u001bCqA!\"I\u0001\u0004\u00119)A\u0002lKf\u0004B!!\u0004\u0003\n&!!1RA\b\u0005\r\te.\u001f\u0005\b\u0005\u001fC\u0005\u0019\u0001BD\u0003\u00151\u0018\r\\;f)\u0011\t9Fa%\t\u000f\tU\u0015\n1\u0001\u0002\f\u0005\t!\r\u0006\u0005\u0002X\te%\u0011\u0016BW\u0011\u001d\u0011YJ\u0013a\u0001\u0005;\u000bqa\u001b<CsR,7\u000f\u0005\u0004\u0002\u000e\t}%1U\u0005\u0005\u0005C\u000byAA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\u000e\t\u0015\u0016\u0002\u0002BT\u0003\u001f\u0011AAQ=uK\"9!1\u0016&A\u0002\u0005-\u0011\u0001B8gMNDqAa,K\u0001\u0004\tY!A\u0002mK:\fQB]3d_J$wK]5ui\u0016t\u0017AE;qI\u0006$XMQ=uKN<&/\u001b;uK:\fQA\u001a7vg\"\fQ\u0003R5tW\ncwnY6PE*,7\r^,sSR,'\u000fE\u0002\u00024=\u001b2a\u0014B_!\u0011\tiAa0\n\t\t\u0005\u0017q\u0002\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\te\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0003J*\"\u0011\u0011\u0007BfW\t\u0011i\r\u0005\u0003\u0003P\neWB\u0001Bi\u0015\u0011\u0011\u0019N!6\u0002\u0013Ut7\r[3dW\u0016$'\u0002\u0002Bl\u0003\u001f\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YN!5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DiskBlockObjectWriter
extends OutputStream
implements Logging,
PairsWriter {
    private final File file;
    private final SerializerManager serializerManager;
    private final SerializerInstance serializerInstance;
    public final int org$apache$spark$storage$DiskBlockObjectWriter$$bufferSize;
    private final boolean syncWrites;
    private final ShuffleWriteMetricsReporter writeMetrics;
    private final BlockId blockId;
    private FileChannel channel;
    private ManualCloseOutputStream mcs;
    private OutputStream bs;
    private FileOutputStream fos;
    private TimeTrackingOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$ts;
    private SerializationStream objOut;
    private boolean initialized;
    private boolean streamOpen;
    private boolean hasBeenClosed;
    private boolean org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled;
    private MutableCheckedOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream;
    private Checksum checksum;
    private long committedPosition;
    private long reportedPosition;
    private int numRecordsWritten;
    private long numRecordsCommitted;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static BlockId $lessinit$greater$default$7() {
        return DiskBlockObjectWriter$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public File file() {
        return this.file;
    }

    public BlockId blockId() {
        return this.blockId;
    }

    private FileChannel channel() {
        return this.channel;
    }

    private void channel_$eq(FileChannel x$1) {
        this.channel = x$1;
    }

    private ManualCloseOutputStream mcs() {
        return this.mcs;
    }

    private void mcs_$eq(ManualCloseOutputStream x$1) {
        this.mcs = x$1;
    }

    private OutputStream bs() {
        return this.bs;
    }

    private void bs_$eq(OutputStream x$1) {
        this.bs = x$1;
    }

    private FileOutputStream fos() {
        return this.fos;
    }

    private void fos_$eq(FileOutputStream x$1) {
        this.fos = x$1;
    }

    public TimeTrackingOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$ts() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$ts;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$ts_$eq(TimeTrackingOutputStream x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$ts = x$1;
    }

    private SerializationStream objOut() {
        return this.objOut;
    }

    private void objOut_$eq(SerializationStream x$1) {
        this.objOut = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private boolean streamOpen() {
        return this.streamOpen;
    }

    private void streamOpen_$eq(boolean x$1) {
        this.streamOpen = x$1;
    }

    private boolean hasBeenClosed() {
        return this.hasBeenClosed;
    }

    private void hasBeenClosed_$eq(boolean x$1) {
        this.hasBeenClosed = x$1;
    }

    public boolean org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled_$eq(boolean x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled = x$1;
    }

    public MutableCheckedOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream_$eq(MutableCheckedOutputStream x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream = x$1;
    }

    private Checksum checksum() {
        return this.checksum;
    }

    private void checksum_$eq(Checksum x$1) {
        this.checksum = x$1;
    }

    private long committedPosition() {
        return this.committedPosition;
    }

    private void committedPosition_$eq(long x$1) {
        this.committedPosition = x$1;
    }

    private long reportedPosition() {
        return this.reportedPosition;
    }

    private void reportedPosition_$eq(long x$1) {
        this.reportedPosition = x$1;
    }

    private int numRecordsWritten() {
        return this.numRecordsWritten;
    }

    private void numRecordsWritten_$eq(int x$1) {
        this.numRecordsWritten = x$1;
    }

    private long numRecordsCommitted() {
        return this.numRecordsCommitted;
    }

    private void numRecordsCommitted_$eq(long x$1) {
        this.numRecordsCommitted = x$1;
    }

    public void setChecksum(Checksum checksum) {
        if (this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream() == null) {
            this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled_$eq(true);
            this.checksum_$eq(checksum);
        } else {
            this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream().setChecksum(checksum);
        }
    }

    private void initialize() {
        this.fos_$eq(new FileOutputStream(this.file(), true));
        this.channel_$eq(this.fos().getChannel());
        this.org$apache$spark$storage$DiskBlockObjectWriter$$ts_$eq(new TimeTrackingOutputStream(this.writeMetrics, this.fos()));
        if (this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled()) {
            Predef$.MODULE$.assert(this.checksum() != null, (Function0 & Serializable & scala.Serializable)() -> "Checksum is not set");
            this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream_$eq(new MutableCheckedOutputStream(this.org$apache$spark$storage$DiskBlockObjectWriter$$ts()));
            this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream().setChecksum(this.checksum());
        }
        public class Org_apache_spark_storage_DiskBlockObjectWriter$ManualCloseBufferedOutputStream$1
        extends BufferedOutputStream
        implements ManualCloseOutputStream {
            private final /* synthetic */ DiskBlockObjectWriter $outer;

            public /* synthetic */ void org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$super$close() {
                super.close();
            }

            public void close() {
                ManualCloseOutputStream.close$(this);
            }

            public void manualClose() {
                ManualCloseOutputStream.manualClose$(this);
            }

            public /* synthetic */ DiskBlockObjectWriter org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$$outer() {
                return this.$outer;
            }

            public Org_apache_spark_storage_DiskBlockObjectWriter$ManualCloseBufferedOutputStream$1(DiskBlockObjectWriter $outer) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled() ? $outer.org$apache$spark$storage$DiskBlockObjectWriter$$checksumOutputStream() : $outer.org$apache$spark$storage$DiskBlockObjectWriter$$ts(), $outer.org$apache$spark$storage$DiskBlockObjectWriter$$bufferSize);
                ManualCloseOutputStream.$init$(this);
            }
        }
        this.mcs_$eq(new Org_apache_spark_storage_DiskBlockObjectWriter$ManualCloseBufferedOutputStream$1(this));
    }

    public DiskBlockObjectWriter open() {
        if (this.hasBeenClosed()) {
            throw new IllegalStateException("Writer already closed. Cannot be reopened.");
        }
        if (!this.initialized()) {
            this.initialize();
            this.initialized_$eq(true);
        }
        this.bs_$eq(this.serializerManager.wrapStream(this.blockId(), (OutputStream)((Object)this.mcs())));
        this.objOut_$eq(this.serializerInstance.serializeStream(this.bs()));
        this.streamOpen_$eq(true);
        return this;
    }

    private void closeResources() {
        block0: {
            if (!this.initialized()) break block0;
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.mcs().manualClose(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.channel_$eq(null);
                this.mcs_$eq(null);
                this.bs_$eq(null);
                this.fos_$eq(null);
                this.org$apache$spark$storage$DiskBlockObjectWriter$$ts_$eq(null);
                this.objOut_$eq(null);
                this.initialized_$eq(false);
                this.streamOpen_$eq(false);
                this.hasBeenClosed_$eq(true);
            });
        }
    }

    @Override
    public void close() {
        block0: {
            if (!this.initialized()) break block0;
            Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> this.commitAndGet(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeResources());
        }
    }

    public FileSegment commitAndGet() {
        FileSegment fileSegment;
        if (this.streamOpen()) {
            this.objOut().flush();
            this.bs().flush();
            this.objOut().close();
            this.streamOpen_$eq(false);
            if (this.syncWrites) {
                long start = System.nanoTime();
                this.fos().getFD().sync();
                this.writeMetrics.incWriteTime(System.nanoTime() - start);
            }
            long pos = this.channel().position();
            FileSegment fileSegment2 = new FileSegment(this.file(), this.committedPosition(), pos - this.committedPosition());
            this.committedPosition_$eq(pos);
            this.writeMetrics.incBytesWritten(this.committedPosition() - this.reportedPosition());
            this.reportedPosition_$eq(this.committedPosition());
            this.numRecordsCommitted_$eq(this.numRecordsCommitted() + (long)this.numRecordsWritten());
            this.numRecordsWritten_$eq(0);
            fileSegment = fileSegment2;
        } else {
            fileSegment = new FileSegment(this.file(), this.committedPosition(), 0L);
        }
        return fileSegment;
    }

    public File revertPartialWritesAndClose() {
        Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!this.initialized()) break block0;
                $this.writeMetrics.decBytesWritten(this.reportedPosition() - this.committedPosition());
                $this.writeMetrics.decRecordsWritten(this.numRecordsWritten());
                this.streamOpen_$eq(false);
                this.closeResources();
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FileOutputStream truncateStream = null;
            try {
                try {
                    truncateStream = new FileOutputStream(this.file(), true);
                    truncateStream.getChannel().truncate(this.committedPosition());
                }
                catch (ClosedByInterruptException ce) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Exception occurred while reverting partial writes to file ").append(this.file()).append(", ").append(ce.getMessage()).toString());
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Uncaught exception while reverting partial writes to file ").append(this.file()).toString(), e);
                }
            }
            finally {
                if (truncateStream != null) {
                    truncateStream.close();
                    truncateStream = null;
                }
            }
        });
        return this.file();
    }

    public void closeAndDelete() {
        Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!this.initialized()) break block0;
                $this.writeMetrics.decBytesWritten(this.reportedPosition());
                $this.writeMetrics.decRecordsWritten(this.numRecordsCommitted() + (long)this.numRecordsWritten());
                this.closeResources();
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (Files.deleteIfExists(this.file().toPath())) break block0;
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Error deleting ").append(this.file()).toString());
            }
        });
    }

    @Override
    public void write(Object key, Object value) {
        Object object = !this.streamOpen() ? this.open() : BoxedUnit.UNIT;
        this.objOut().writeKey(key, ClassTag$.MODULE$.Any());
        this.objOut().writeValue(value, ClassTag$.MODULE$.Any());
        this.recordWritten();
    }

    @Override
    public void write(int b) {
        throw SparkCoreErrors$.MODULE$.unsupportedOperationError();
    }

    @Override
    public void write(byte[] kvBytes, int offs, int len) {
        Object object = !this.streamOpen() ? this.open() : BoxedUnit.UNIT;
        this.bs().write(kvBytes, offs, len);
    }

    public void recordWritten() {
        block0: {
            this.numRecordsWritten_$eq(this.numRecordsWritten() + 1);
            this.writeMetrics.incRecordsWritten(1L);
            if (this.numRecordsWritten() % 16384 != 0) break block0;
            this.updateBytesWritten();
        }
    }

    private void updateBytesWritten() {
        long pos = this.channel().position();
        this.writeMetrics.incBytesWritten(pos - this.reportedPosition());
        this.reportedPosition_$eq(pos);
    }

    @Override
    public void flush() {
        this.objOut().flush();
        this.bs().flush();
    }

    public DiskBlockObjectWriter(File file, SerializerManager serializerManager, SerializerInstance serializerInstance, int bufferSize, boolean syncWrites, ShuffleWriteMetricsReporter writeMetrics, BlockId blockId) {
        this.file = file;
        this.serializerManager = serializerManager;
        this.serializerInstance = serializerInstance;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$bufferSize = bufferSize;
        this.syncWrites = syncWrites;
        this.writeMetrics = writeMetrics;
        this.blockId = blockId;
        Logging.$init$(this);
        this.channel = null;
        this.mcs = null;
        this.bs = null;
        this.fos = null;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$ts = null;
        this.objOut = null;
        this.initialized = false;
        this.streamOpen = false;
        this.hasBeenClosed = false;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$checksumEnabled = false;
        this.committedPosition = file.length();
        this.reportedPosition = this.committedPosition();
        this.numRecordsWritten = 0;
        this.numRecordsCommitted = 0L;
    }

    private interface ManualCloseOutputStream {
        public /* synthetic */ void org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$super$close();

        public static /* synthetic */ void close$(ManualCloseOutputStream $this) {
            $this.close();
        }

        default public void close() {
            ((OutputStream)((Object)this)).flush();
        }

        public static /* synthetic */ void manualClose$(ManualCloseOutputStream $this) {
            $this.manualClose();
        }

        default public void manualClose() {
            try {
                this.org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$super$close();
            }
            catch (IOException e) {
                this.org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Exception occurred while manually close the output stream to file ").append(this.org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$$outer().file()).append(", ").append(e.getMessage()).toString());
            }
        }

        public /* synthetic */ DiskBlockObjectWriter org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$$outer();

        public static void $init$(ManualCloseOutputStream $this) {
        }
    }
}

