/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.observation;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.jackrabbit.jcr2spi.observation.EventImpl;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

class FilteredEventIterator
implements EventIterator {
    protected final Iterator<org.apache.jackrabbit.spi.Event> actualEvents;
    private final EventFilter filter;
    private final boolean isLocal;
    private final NamePathResolver resolver;
    private final IdFactory idFactory;
    private Event next;
    private long pos = 0L;

    public FilteredEventIterator(Iterator<org.apache.jackrabbit.spi.Event> events, boolean isLocal, EventFilter filter, NamePathResolver resolver, IdFactory idFactory) {
        this.actualEvents = events;
        this.filter = filter;
        this.isLocal = isLocal;
        this.resolver = resolver;
        this.idFactory = idFactory;
        this.fetchNext();
    }

    public Object next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Event e = this.next;
        this.fetchNext();
        ++this.pos;
        return e;
    }

    @Override
    public Event nextEvent() {
        return (Event)this.next();
    }

    @Override
    public void skip(long skipNum) {
        while (skipNum-- > 0L) {
            this.next();
        }
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("EventIterator.remove()");
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    private void fetchNext() {
        this.next = null;
        while (this.next == null && this.actualEvents.hasNext()) {
            org.apache.jackrabbit.spi.Event event = this.actualEvents.next();
            this.next = this.filter.accept(event, this.isLocal) ? new EventImpl(event, this.resolver, this.idFactory) : null;
        }
    }
}

