/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.engine;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.ParseAndValidate;
import graphql.ParseAndValidateResult;
import graphql.execution.values.InputInterceptor;
import graphql.execution.values.legacycoercing.LegacyCoercingInputInterceptor;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.SourceLocation;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.normalized.ExecutableNormalizedOperationFactory;
import graphql.parser.ParserOptions;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import javax.script.ScriptException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.graphql.api.SchemaProvider;
import org.apache.sling.graphql.api.SlingDataFetcher;
import org.apache.sling.graphql.api.SlingGraphQLException;
import org.apache.sling.graphql.api.SlingTypeResolver;
import org.apache.sling.graphql.api.engine.QueryExecutor;
import org.apache.sling.graphql.api.engine.ValidationResult;
import org.apache.sling.graphql.core.directives.Directives;
import org.apache.sling.graphql.core.engine.DefaultValidationResult;
import org.apache.sling.graphql.core.engine.SlingDataFetcherSelector;
import org.apache.sling.graphql.core.engine.SlingDataFetcherWrapper;
import org.apache.sling.graphql.core.engine.SlingTypeResolverSelector;
import org.apache.sling.graphql.core.engine.SlingTypeResolverWrapper;
import org.apache.sling.graphql.core.hash.SHA256Hasher;
import org.apache.sling.graphql.core.scalars.SlingScalarsProvider;
import org.apache.sling.graphql.core.schema.RankedSchemaProviders;
import org.apache.sling.graphql.core.util.LogSanitizer;
import org.apache.sling.graphql.core.util.SlingGraphQLErrorHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={QueryExecutor.class})
@Designate(ocd=Config.class)
public class DefaultQueryExecutor
implements QueryExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultQueryExecutor.class);
    public static final String FETCHER_DIRECTIVE = "fetcher";
    public static final String FETCHER_NAME = "name";
    public static final String FETCHER_OPTIONS = "options";
    public static final String FETCHER_SOURCE = "source";
    public static final String RESOLVER_DIRECTIVE = "resolver";
    public static final String RESOLVER_NAME = "name";
    public static final String RESOLVER_OPTIONS = "options";
    public static final String RESOLVER_SOURCE = "source";
    public static final String CONNECTION_FOR = "for";
    public static final String CONNECTION_FETCHER = "fetcher";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_BOOLEAN = "Boolean";
    public static final String TYPE_PAGE_INFO = "PageInfo";
    private static final LogSanitizer cleanLog = new LogSanitizer();
    private Map<String, String> resourceToHashMap;
    private Map<String, TypeDefinitionRegistry> hashToSchemaMap;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final SchemaGenerator schemaGenerator = new SchemaGenerator();
    private int maxQueryTokens;
    private int maxWhitespaceTokens;
    @Reference
    private RankedSchemaProviders schemaProvider;
    @Reference
    private SlingDataFetcherSelector dataFetcherSelector;
    @Reference
    private SlingTypeResolverSelector typeResolverSelector;
    @Reference
    private SlingScalarsProvider scalarsProvider;

    @Activate
    public void activate(Config config) {
        int schemaCacheSize = config.schemaCacheSize();
        if (schemaCacheSize < 0) {
            schemaCacheSize = 0;
        }
        this.maxQueryTokens = config.maxQueryTokens();
        this.maxWhitespaceTokens = config.maxWhitespaceTokens();
        this.resourceToHashMap = new LRUCache<String>(schemaCacheSize);
        this.hashToSchemaMap = new LRUCache<TypeDefinitionRegistry>(schemaCacheSize);
        ExecutableNormalizedOperationFactory.Options.setDefaultOptions((ExecutableNormalizedOperationFactory.Options)ExecutableNormalizedOperationFactory.Options.defaultOptions().maxFieldsCount(config.maxFieldCount()));
    }

    @Override
    public ValidationResult validate(@NotNull String query, @NotNull Map<String, Object> variables, @NotNull Resource queryResource, @NotNull String[] selectors) {
        try {
            ExecutionContext ctx = new ExecutionContext(query, variables, queryResource, selectors);
            ParseAndValidateResult parseAndValidateResult = ParseAndValidate.parseAndValidate((GraphQLSchema)ctx.schema, (ExecutionInput)ctx.input);
            if (!parseAndValidateResult.isFailure()) {
                return DefaultValidationResult.Builder.newBuilder().withValidFlag(true).build();
            }
            DefaultValidationResult.Builder validationResultBuilder = DefaultValidationResult.Builder.newBuilder().withValidFlag(false);
            for (GraphQLError error : parseAndValidateResult.getErrors()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Error: type=").append(error.getErrorType().toString()).append("; ");
                sb.append("message=").append(error.getMessage()).append("; ");
                for (SourceLocation location : error.getLocations()) {
                    sb.append("location=").append(location.getLine()).append(",").append(location.getColumn()).append(";");
                }
                validationResultBuilder.withErrorMessage(sb.toString());
            }
            return validationResultBuilder.build();
        }
        catch (Exception e) {
            return DefaultValidationResult.Builder.newBuilder().withValidFlag(false).withErrorMessage(e.getMessage()).build();
        }
    }

    @Override
    @NotNull
    public Map<String, Object> execute(@NotNull String query, @NotNull Map<String, Object> variables, @NotNull Resource queryResource, @NotNull String[] selectors) {
        try {
            ExecutionResult result;
            ExecutionContext ctx = new ExecutionContext(query, variables, queryResource, selectors);
            GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)ctx.schema).build();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing query\n[{}]\nat [{}] with variables [{}]", new Object[]{cleanLog.sanitize(query), queryResource.getPath(), cleanLog.sanitize(variables.toString())});
            }
            if (!(result = graphQL.execute(ctx.input)).getErrors().isEmpty()) {
                StringBuilder errors = new StringBuilder();
                for (GraphQLError error : result.getErrors()) {
                    errors.append("Error: type=").append(error.getErrorType().toString()).append("; message=").append(error.getMessage()).append(System.lineSeparator());
                    if (error.getLocations() == null) continue;
                    for (SourceLocation location : error.getLocations()) {
                        errors.append("location=").append(location.getLine()).append(",").append(location.getColumn()).append(";");
                    }
                }
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Query failed for Resource {}: query={} Errors:{}, selectors={}", new Object[]{queryResource.getPath(), cleanLog.sanitize(query), errors, Arrays.toString(selectors)});
                }
            }
            LOGGER.debug("ExecutionResult.isDataPresent={}", (Object)result.isDataPresent());
            return result.toSpecification();
        }
        catch (Exception e) {
            String message = String.format("Query failed for Resource %s: query=%s, selectors=%s", queryResource.getPath(), cleanLog.sanitize(query), Arrays.toString(selectors));
            LOGGER.error(message, (Throwable)e);
            return SlingGraphQLErrorHelper.toSpecification(message, e);
        }
    }

    private RuntimeWiring buildWiring(TypeDefinitionRegistry typeRegistry, Iterable<GraphQLScalarType> scalars, Resource r) {
        List types = typeRegistry.getTypes(ObjectTypeDefinition.class);
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        for (Object type : types) {
            builder.type(type.getName(), arg_0 -> this.lambda$buildWiring$0((ObjectTypeDefinition)type, r, typeRegistry, arg_0));
        }
        scalars.forEach(arg_0 -> ((RuntimeWiring.Builder)builder).scalar(arg_0));
        List unionTypes = typeRegistry.getTypes(UnionTypeDefinition.class);
        for (UnionTypeDefinition type : unionTypes) {
            this.wireTypeResolver(builder, (TypeDefinition)type, r);
        }
        List interfaceTypes = typeRegistry.getTypes(InterfaceTypeDefinition.class);
        for (InterfaceTypeDefinition type : interfaceTypes) {
            this.wireTypeResolver(builder, (TypeDefinition)type, r);
        }
        return builder.build();
    }

    private <T extends TypeDefinition<T>> void wireTypeResolver(RuntimeWiring.Builder builder, TypeDefinition<T> type, Resource r) {
        try {
            TypeResolver resolver = this.getTypeResolver(type, r);
            if (resolver != null) {
                builder.type(type.getName(), typeWriting -> typeWriting.typeResolver(resolver));
            }
        }
        catch (SlingGraphQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SlingGraphQLException("Exception while building wiring.", e);
        }
    }

    private String getDirectiveArgumentValue(Directive d, String name) {
        Argument a = d.getArgument(name);
        if (a != null && a.getValue() instanceof StringValue) {
            return ((StringValue)a.getValue()).getValue();
        }
        return null;
    }

    @NotNull
    private String validateFetcherName(String name) {
        if (SlingDataFetcherSelector.nameMatchesPattern(name)) {
            return name;
        }
        throw new SlingGraphQLException(String.format("Invalid fetcher name %s, does not match %s", name, SlingDataFetcherSelector.FETCHER_NAME_PATTERN));
    }

    @NotNull
    private String validateResolverName(String name) {
        if (SlingTypeResolverSelector.nameMatchesPattern(name)) {
            return name;
        }
        throw new SlingGraphQLException(String.format("Invalid type resolver name %s, does not match %s", name, SlingTypeResolverSelector.RESOLVER_NAME_PATTERN));
    }

    private DataFetcher<Object> getDataFetcher(FieldDefinition field, Resource currentResource) {
        SlingDataFetcherWrapper<Object> result = null;
        Directive d = field.getDirectives().stream().filter(i -> "fetcher".equals(i.getName())).findFirst().orElse(null);
        if (d != null) {
            String name = this.validateFetcherName(this.getDirectiveArgumentValue(d, "name"));
            String options = this.getDirectiveArgumentValue(d, "options");
            String source = this.getDirectiveArgumentValue(d, "source");
            SlingDataFetcher<Object> f = this.dataFetcherSelector.getSlingFetcher(name);
            if (f != null) {
                result = new SlingDataFetcherWrapper<Object>(f, currentResource, options, source);
            }
        }
        return result;
    }

    private <T extends TypeDefinition<T>> TypeResolver getTypeResolver(TypeDefinition<T> typeDefinition, Resource currentResource) {
        SlingTypeResolverWrapper resolver = null;
        Directive d = typeDefinition.getDirectives().stream().filter(i -> RESOLVER_DIRECTIVE.equals(i.getName())).findFirst().orElse(null);
        if (d != null) {
            String name = this.validateResolverName(this.getDirectiveArgumentValue(d, "name"));
            String options = this.getDirectiveArgumentValue(d, "options");
            String source = this.getDirectiveArgumentValue(d, "source");
            SlingTypeResolver<Object> r = this.typeResolverSelector.getSlingTypeResolver(name);
            if (r != null) {
                resolver = new SlingTypeResolverWrapper(r, currentResource, options, source);
            }
        }
        return resolver;
    }

    @Nullable
    private String prepareSchemaDefinition(@NotNull SchemaProvider schemaProvider, @NotNull Resource resource, @NotNull String[] selectors) throws ScriptException {
        try {
            return schemaProvider.getSchema(resource, selectors);
        }
        catch (Exception e) {
            ScriptException up = new ScriptException("Schema provider failed");
            up.initCause(e);
            LOGGER.info("Schema provider Exception", (Throwable)up);
            throw up;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeDefinitionRegistry getTypeDefinitionRegistry(@NotNull String sdl, @NotNull Resource currentResource, @NotNull String[] selectors) {
        TypeDefinitionRegistry typeRegistry = null;
        this.readLock.lock();
        String newHash = SHA256Hasher.getHash(sdl);
        String resourceToHashMapKey = this.getCacheKey(currentResource, selectors);
        String oldHash = this.resourceToHashMap.get(resourceToHashMapKey);
        if (!newHash.equals(oldHash) || this.hashToSchemaMap.get(newHash) == null) {
            this.readLock.unlock();
            this.writeLock.lock();
            try {
                oldHash = this.resourceToHashMap.get(resourceToHashMapKey);
                if (!newHash.equals(oldHash) || this.hashToSchemaMap.get(newHash) == null) {
                    typeRegistry = new SchemaParser().parse(sdl);
                    typeRegistry.add((SDLDefinition)Directives.CONNECTION);
                    typeRegistry.add((SDLDefinition)Directives.FETCHER);
                    typeRegistry.add((SDLDefinition)Directives.RESOLVER);
                    for (ObjectTypeDefinition typeDefinition : typeRegistry.getTypes(ObjectTypeDefinition.class)) {
                        this.handleConnectionTypes(typeDefinition, typeRegistry);
                    }
                    this.resourceToHashMap.put(resourceToHashMapKey, newHash);
                    this.hashToSchemaMap.put(newHash, typeRegistry);
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to generate a TypeRegistry.", (Throwable)e);
            }
            finally {
                this.readLock.lock();
                this.writeLock.unlock();
            }
        }
        try {
            Object object;
            if (typeRegistry != null) {
                object = typeRegistry;
                return object;
            }
            object = this.hashToSchemaMap.get(newHash);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private GraphQLSchema buildSchema(@NotNull TypeDefinitionRegistry typeRegistry, @NotNull Resource currentResource) {
        Iterable<GraphQLScalarType> scalars = this.scalarsProvider.getCustomScalars(typeRegistry.scalars());
        RuntimeWiring runtimeWiring = this.buildWiring(typeRegistry, scalars, currentResource);
        return this.schemaGenerator.makeExecutableSchema(typeRegistry, runtimeWiring);
    }

    private String getCacheKey(@NotNull Resource resource, @NotNull String[] selectors) {
        return resource.getPath() + ":" + String.join((CharSequence)".", selectors);
    }

    private void handleConnectionTypes(ObjectTypeDefinition typeDefinition, TypeDefinitionRegistry typeRegistry) {
        for (FieldDefinition fieldDefinition : typeDefinition.getFieldDefinitions()) {
            Directive directive = fieldDefinition.getDirectives().stream().filter(i -> "connection".equals(i.getName())).findFirst().orElse(null);
            if (directive == null) continue;
            if (directive.getArgument(CONNECTION_FOR) != null) {
                String forType = ((StringValue)directive.getArgument(CONNECTION_FOR).getValue()).getValue();
                Optional forTypeDefinition = typeRegistry.getType(forType);
                if (!forTypeDefinition.isPresent()) {
                    throw new SlingGraphQLException("Type '" + forType + "' has not been defined.");
                }
                TypeDefinition forOTD = (TypeDefinition)forTypeDefinition.get();
                ObjectTypeDefinition edge = ObjectTypeDefinition.newObjectTypeDefinition().name(forOTD.getName() + "Edge").fieldDefinition(new FieldDefinition("cursor", (Type)new TypeName(TYPE_STRING))).fieldDefinition(new FieldDefinition("node", (Type)new TypeName(forOTD.getName()))).build();
                ObjectTypeDefinition connection = ObjectTypeDefinition.newObjectTypeDefinition().name(forOTD.getName() + "Connection").fieldDefinition(new FieldDefinition("edges", (Type)new ListType((Type)new TypeName(forType + "Edge")))).fieldDefinition(new FieldDefinition("pageInfo", (Type)new TypeName(TYPE_PAGE_INFO))).build();
                if (!typeRegistry.getType(TYPE_PAGE_INFO).isPresent()) {
                    ObjectTypeDefinition pageInfo = ObjectTypeDefinition.newObjectTypeDefinition().name(TYPE_PAGE_INFO).fieldDefinition(new FieldDefinition("hasPreviousPage", (Type)new NonNullType((Type)new TypeName(TYPE_BOOLEAN)))).fieldDefinition(new FieldDefinition("hasNextPage", (Type)new NonNullType((Type)new TypeName(TYPE_BOOLEAN)))).fieldDefinition(new FieldDefinition("startCursor", (Type)new TypeName(TYPE_STRING))).fieldDefinition(new FieldDefinition("endCursor", (Type)new TypeName(TYPE_STRING))).build();
                    typeRegistry.add((SDLDefinition)pageInfo);
                }
                typeRegistry.add((SDLDefinition)edge);
                typeRegistry.add((SDLDefinition)connection);
                continue;
            }
            throw new SlingGraphQLException("The connection directive requires a 'for' argument.");
        }
    }

    private /* synthetic */ TypeRuntimeWiring.Builder lambda$buildWiring$0(ObjectTypeDefinition type, Resource r, TypeDefinitionRegistry typeRegistry, TypeRuntimeWiring.Builder typeWiring) {
        for (FieldDefinition field : type.getFieldDefinitions()) {
            try {
                DataFetcher<Object> fetcher = this.getDataFetcher(field, r);
                if (fetcher == null) continue;
                typeWiring.dataFetcher(field.getName(), fetcher);
            }
            catch (SlingGraphQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SlingGraphQLException("Exception while building wiring.", e);
            }
        }
        this.handleConnectionTypes(type, typeRegistry);
        return typeWiring;
    }

    @ObjectClassDefinition(name="Apache Sling Default GraphQL Query Executor")
    static @interface Config {
        @AttributeDefinition(name="Schema Cache Size", description="The number of compiled GraphQL schemas to cache. Since a schema normally doesn't change often, they can be cached and reused, rather than parsed by the engine all the time. The cache is a LRU and will store up to this number of schemas.")
        public int schemaCacheSize() default 128;

        @AttributeDefinition(name="Max Query Tokens", description="The number of GraphQL query tokens to parse. This is a safety measure to avoid denial of service attacks. Change ONLY if you know exactly what you are doing.")
        public int maxQueryTokens() default 15000;

        @AttributeDefinition(name="Max Whitespace Tokens", description="The number of GraphQL query whitespace tokens to parse. This is a safety measure to avoid denial of service attacks. Change ONLY if you know exactly what you are doing.")
        public int maxWhitespaceTokens() default 200000;

        @AttributeDefinition(name="Maximum Field Count", description="The number of fields queried with an GraphQL request. This is a safety measure to avoid denial of service attacks. Change ONLY if you know exactly what you are doing.")
        public int maxFieldCount() default 100000;
    }

    private static class LRUCache<T>
    extends LinkedHashMap<String, T> {
        private final int capacity;

        public LRUCache(int capacity) {
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, T> eldest) {
            return this.size() > this.capacity;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + Objects.hashCode(this.capacity);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof LRUCache) {
                LRUCache other = (LRUCache)o;
                return super.equals(o) && this.capacity == other.capacity;
            }
            return false;
        }
    }

    private class ExecutionContext {
        final GraphQLSchema schema;
        final ExecutionInput input;

        ExecutionContext(@NotNull String query, @NotNull Map<String, Object> variables, @NotNull Resource queryResource, String[] selectors) throws ScriptException {
            String schemaSdl = DefaultQueryExecutor.this.prepareSchemaDefinition(DefaultQueryExecutor.this.schemaProvider, queryResource, selectors);
            if (schemaSdl == null) {
                throw new SlingGraphQLException(String.format("Cannot get a schema for resource %s and selectors %s.", queryResource, Arrays.toString(selectors)));
            }
            LOGGER.debug("Resource {} maps to GQL schema {}", (Object)queryResource.getPath(), (Object)schemaSdl);
            TypeDefinitionRegistry typeDefinitionRegistry = DefaultQueryExecutor.this.getTypeDefinitionRegistry(schemaSdl, queryResource, selectors);
            this.schema = DefaultQueryExecutor.this.buildSchema(typeDefinitionRegistry, queryResource);
            this.input = ExecutionInput.newExecutionInput().query(query).variables(variables).graphQLContext(this.getGraphQLContextBuilder()).build();
        }

        private Consumer<GraphQLContext.Builder> getGraphQLContextBuilder() {
            ParserOptions parserOptions = ParserOptions.getDefaultParserOptions().transform(builder -> builder.maxTokens(DefaultQueryExecutor.this.maxQueryTokens).maxWhitespaceTokens(DefaultQueryExecutor.this.maxWhitespaceTokens).build());
            return builder -> builder.put(ParserOptions.class, (Object)parserOptions).put(InputInterceptor.class, (Object)LegacyCoercingInputInterceptor.migratesValues());
        }
    }
}

