/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.PropertyMap;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.xml.NilReason;
import org.opengis.annotation.Obligation;

final class NilReasonMap
extends PropertyMap<NilReason> {
    private static final Set<Class<?>> AS_OBJECTS = Set.of(Double.class, Float.class, String.class, URI.class);
    private final Object metadata;
    private final Map<Integer, NilReason> nilReasons;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NilReasonMap(Object metadata, PropertyAccessor accessor, KeyNamePolicy keyPolicy) {
        super(accessor, keyPolicy);
        this.metadata = metadata;
        if (metadata instanceof AbstractMetadata) {
            AbstractMetadata c;
            AbstractMetadata abstractMetadata = c = (AbstractMetadata)metadata;
            synchronized (abstractMetadata) {
                if (c.nilReasons == null) {
                    c.nilReasons = new HashMap(4);
                }
                this.nilReasons = c.nilReasons;
            }
        } else {
            this.nilReasons = new HashMap<Integer, NilReason>(4);
        }
    }

    @Override
    public boolean isEmpty() {
        int count = this.accessor.count();
        for (int i = 0; i < count; ++i) {
            if (!this.contains(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        int n = 0;
        int count = this.accessor.count();
        for (int i = 0; i < count; ++i) {
            if (!this.contains(i)) continue;
            ++n;
        }
        return n;
    }

    @Override
    final boolean contains(int index) {
        Object value = this.accessor.get(index, this.metadata);
        if (value != null) {
            this.nilReasons.remove(index);
            return NilReason.forObject(value) != null;
        }
        return this.nilReasons.containsKey(index) || this.accessor.obligation(index) == Obligation.MANDATORY;
    }

    @Override
    final NilReason getReflectively(int index) {
        return this.getNilReason(index, this.accessor.get(index, this.metadata));
    }

    final NilReason getNilReason(int index, Object value) {
        if (value != null) {
            this.nilReasons.remove(index);
            return NilReason.forObject(value);
        }
        return this.nilReasons.get(index);
    }

    @Override
    final NilReason setReflectively(int index, NilReason value) {
        if (value == null) {
            Object oldObject = this.accessor.get(index, this.metadata);
            NilReason oldReason = NilReason.forObject(oldObject);
            if (oldReason == null) {
                NilReason oldStored = this.nilReasons.remove(index);
                return oldObject == null ? oldStored : null;
            }
            this.accessor.set(index, this.metadata, null, 0);
            this.nilReasons.remove(index);
            return oldReason;
        }
        Class<?> type = this.accessor.type(index, TypeValuePolicy.PROPERTY_TYPE);
        Object nilObject = NilReasonMap.asNilObject(type) ? value.createNilObject(type) : null;
        Object oldObject = this.accessor.set(index, this.metadata, nilObject, 1);
        NilReason oldReason = NilReason.forObject(oldObject);
        NilReason oldStored = nilObject == null ? this.nilReasons.put(index, value) : this.nilReasons.remove(index);
        return oldReason != null ? oldReason : oldStored;
    }

    private static boolean asNilObject(Class<?> type) {
        return type.isInterface() || AS_OBJECTS.contains(type);
    }

    @Override
    final Iterator<Map.Entry<String, NilReason>> iterator() {
        return new PropertyMap.ReflectiveIterator(this);
    }
}

