/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.base;

import org.apache.sis.util.resources.Errors;

public enum Predictor {
    NONE(1),
    HORIZONTAL_DIFFERENCING(2),
    FLOAT(3),
    UNKNOWN(0);

    public final int code;

    private Predictor(int code) {
        this.code = code;
    }

    public static Predictor valueOf(int code) {
        switch (code) {
            case 1: {
                return NONE;
            }
            case 2: {
                return HORIZONTAL_DIFFERENCING;
            }
            case 3: {
                return FLOAT;
            }
        }
        return UNKNOWN;
    }

    public static Predictor supported(int code) {
        Predictor value = Predictor.valueOf(code);
        if (value.ordinal() <= HORIZONTAL_DIFFERENCING.ordinal()) {
            return value;
        }
        throw new IllegalArgumentException(Errors.format((short)191, (Object)code));
    }
}

