/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.MatrixParameterValues;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.EPSGName;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;

public class MatrixParameters<E>
implements CheckedContainer<E>,
Serializable {
    private static final long serialVersionUID = 8161073830003749123L;
    public static final MatrixParameters<Double> WKT1 = new MatrixParameters<Double>(Double.class, "elt_", "_", MatrixParameters.dimensionsForMatrix(1));
    public static final MatrixParameters<Double> ALPHANUM = new MatrixParameters<Double>(WKT1){

        @Override
        protected int[] nameToIndices(String name) {
            int col;
            int row;
            if (name.length() == 2 && (row = name.charAt(0) - 65) >= 0 && row <= 25 && (col = name.charAt(1) - 48) >= 0 && col <= 9) {
                return new int[]{row, col};
            }
            return super.nameToIndices(name);
        }

        @Override
        protected String indicesToName(int[] indices) {
            int col;
            int row = indices[0];
            if (row >= 0 && row <= 25 && (col = indices[1]) >= 0 && col <= 9) {
                return String.valueOf(new char[]{(char)(65 + row), (char)(48 + col)});
            }
            return null;
        }

        @Override
        protected Map<String, ?> properties(int[] indices) {
            NamedIdentifier alias = new NamedIdentifier((Citation)Citations.OGC, super.indicesToName(indices));
            HashMap<String, NamedIdentifier> properties = new HashMap<String, NamedIdentifier>(4);
            String name = this.indicesToName(indices);
            if (name != null) {
                properties.put("name", new NamedIdentifier(Citations.SIS, name));
                properties.put("alias", alias);
            } else {
                properties.put("name", alias);
            }
            return properties;
        }

        @Override
        public String toString() {
            return "ALPHANUM";
        }
    };
    public static final MatrixParameters<Double> EPSG = new MatrixParameters<Double>(Double.class, "elt_", "_", MatrixParameters.dimensionsForMatrix(0)){

        @Override
        protected int[] nameToIndices(String name) {
            int col;
            int row;
            if (name.length() == 2 && ((row = name.charAt(0) - 65) == 0 || row == 1) && (col = name.charAt(1) - 49) >= -1 && col <= 1) {
                if (col < 0) {
                    col = 2;
                }
                return new int[]{row, col};
            }
            return super.nameToIndices(name);
        }

        @Override
        protected String indicesToName(int[] indices) {
            int col;
            int row = indices[0];
            if ((row == 0 || row == 1) && (col = indices[1]) >= 0 && col <= 2) {
                if (col == 2) {
                    col = -1;
                }
                return String.valueOf(new char[]{(char)(65 + row), (char)(49 + col)});
            }
            return null;
        }

        @Override
        protected Map<String, ?> properties(int[] indices) {
            NamedIdentifier alias = new NamedIdentifier((Citation)Citations.OGC, super.indicesToName(indices));
            HashMap<String, NamedIdentifier> properties = new HashMap<String, NamedIdentifier>(6);
            String name = this.indicesToName(indices);
            if (name != null) {
                properties.put("name", new NamedIdentifier((Citation)Citations.EPSG, name));
                properties.put("alias", alias);
                switch (name.charAt(0)) {
                    case 'A': {
                        int code = 8575;
                        break;
                    }
                    case 'B': {
                        int code = 8591;
                        break;
                    }
                    default: {
                        return properties;
                    }
                }
                properties.put("identifiers", (NamedIdentifier)EPSGName.identifier(code += name.charAt(1)));
            } else {
                properties.put("name", alias);
            }
            return properties;
        }

        @Override
        public String toString() {
            return "EPSG";
        }
    };
    static final int MAX_CACHE_SIZE = 5;
    private static final int MAX_CACHE_DIMENSION = 2;
    private final Class<E> elementType;
    private final ParameterDescriptor<Integer>[] dimensions;
    private transient ParameterDescriptor<E>[] parameters;
    private transient E zero;
    private transient E one;
    protected final String prefix;
    protected final String separator;

    private static ParameterDescriptor<Integer>[] dimensionsForMatrix(int minimumOccurs) {
        NumberRange valueDomain = NumberRange.create((int)1, (boolean)true, (int)50, (boolean)true);
        Integer defaultSize = 3;
        return new DefaultParameterDescriptor[]{new DefaultParameterDescriptor<Integer>(Map.of("authority", Citations.OGC, "code", "num_row"), minimumOccurs, 1, Integer.class, (Range<?>)valueDomain, null, defaultSize), new DefaultParameterDescriptor<Integer>(Map.of("authority", Citations.OGC, "code", "num_col"), minimumOccurs, 1, Integer.class, (Range<?>)valueDomain, null, defaultSize)};
    }

    protected MatrixParameters(MatrixParameters<E> other) {
        this.elementType = other.elementType;
        this.prefix = other.prefix;
        this.separator = other.separator;
        this.dimensions = other.dimensions;
        this.parameters = this.createCache();
    }

    @SafeVarargs
    public MatrixParameters(Class<E> elementType, String prefix, String separator, ParameterDescriptor<Integer> ... dimensions) {
        ArgumentChecks.ensureNonNull((String)"elementType", elementType);
        ArgumentChecks.ensureNonNull((String)"prefix", (Object)prefix);
        ArgumentChecks.ensureNonNull((String)"separator", (Object)separator);
        ArgumentChecks.ensureNonEmpty((String)"dimensions", (Object[])dimensions);
        this.elementType = elementType;
        this.prefix = prefix;
        this.separator = separator;
        this.dimensions = new ParameterDescriptor[dimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            this.dimensions[i] = dimensions[i];
            ArgumentChecks.ensureNonNullElement((String)"dimensions", (int)i, this.dimensions[i]);
        }
        this.parameters = this.createCache();
    }

    private <T> ParameterDescriptor<T>[] createCache() {
        if (Number.class.isAssignableFrom(this.elementType)) {
            try {
                this.one = Numbers.wrap((long)1L, this.elementType);
                this.zero = Numbers.wrap((long)0L, this.elementType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        int length = 1;
        int i = Math.min(this.order(), 2);
        while (--i >= 0) {
            length *= 5;
        }
        return new ParameterDescriptor[length];
    }

    public final Class<E> getElementType() {
        return this.elementType;
    }

    public final int order() {
        return this.dimensions.length;
    }

    private void verifyOrder(int[] indices) {
        if (indices.length != this.order()) {
            throw new IllegalArgumentException(Errors.format((short)164, (Object)this.order(), (Object)indices.length));
        }
    }

    public final ParameterDescriptor<Integer> getDimensionDescriptor(int i) {
        return this.dimensions[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ParameterDescriptor<E> getElementDescriptor(int ... indices) {
        ParameterDescriptor<E>[] parameters;
        this.verifyOrder(indices);
        int cacheIndex = 0;
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            ArgumentChecks.ensurePositive((String)"indices", (int)index);
            if (i < 2 && index < 5) {
                cacheIndex = cacheIndex * 5 + index;
                continue;
            }
            if (index == 0) continue;
            return this.createElementDescriptor(indices);
        }
        ParameterDescriptor<E>[] parameterDescriptorArray = parameters = this.parameters;
        synchronized (parameters) {
            ParameterDescriptor<E> param = parameters[cacheIndex];
            // ** MonitorExit[var5_7] (shouldn't be in output)
            if (param != null) return param;
            param = this.createElementDescriptor(indices);
            parameterDescriptorArray = parameters;
            synchronized (parameters) {
                ParameterDescriptor<E> existing = parameters[cacheIndex];
                if (existing != null) {
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    return existing;
                }
                parameters[cacheIndex] = param;
                // ** MonitorExit[var5_7] (shouldn't be in output)
                return param;
            }
        }
    }

    protected ParameterDescriptor<E> createElementDescriptor(int[] indices) {
        return new DefaultParameterDescriptor<E>(this.properties(indices), 0, 1, this.elementType, null, null, this.getDefaultValue(indices));
    }

    protected Map<String, ?> properties(int[] indices) {
        String name = this.indicesToName(indices);
        if (name == null) {
            return Map.of();
        }
        Citation authority = this.dimensions[0].getName().getAuthority();
        return Map.of("name", new NamedIdentifier(authority, name));
    }

    protected String indicesToName(int[] indices) {
        this.verifyOrder(indices);
        StringBuilder name = new StringBuilder();
        String s = this.prefix;
        for (int i : indices) {
            name.append(s).append(i);
            s = this.separator;
        }
        return name.toString();
    }

    protected int[] nameToIndices(String name) {
        int s = this.prefix.length();
        if (!name.regionMatches(true, 0, this.prefix, 0, s)) {
            return null;
        }
        int[] indices = new int[this.order()];
        int last = indices.length - 1;
        for (int i = 0; i < last; ++i) {
            int split = name.indexOf(this.separator, s);
            if (split < 0) {
                return null;
            }
            indices[i] = Integer.parseInt(name.substring(s, split));
            s = split + 1;
        }
        indices[last] = Integer.parseInt(name.substring(s));
        return indices;
    }

    protected E getDefaultValue(int[] indices) {
        for (int i = 1; i < indices.length; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            return this.zero;
        }
        return this.one;
    }

    final ParameterDescriptor<?> descriptor(ParameterDescriptorGroup caller, String name, int[] actualSize) throws ParameterNotFoundException {
        IllegalArgumentException cause = null;
        int[] indices = null;
        try {
            indices = this.nameToIndices(name);
        }
        catch (IllegalArgumentException exception) {
            cause = exception;
        }
        if (indices != null && MatrixParameters.isInBounds(indices, actualSize)) {
            return this.getElementDescriptor(indices);
        }
        for (ParameterDescriptor<Integer> param : this.dimensions) {
            if (!IdentifiedObjects.isHeuristicMatchForName(param, name)) continue;
            return param;
        }
        throw (ParameterNotFoundException)new ParameterNotFoundException(Resources.format((short)61, caller.getName(), name), name).initCause((Throwable)cause);
    }

    static boolean isInBounds(int[] indices, int[] actualSize) {
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            if (index >= 0 && index < actualSize[i]) continue;
            return false;
        }
        return true;
    }

    public ParameterDescriptor<?>[] getAllDescriptors(int ... actualSize) {
        this.verifyOrder(actualSize);
        int numElements = 1;
        for (int s : actualSize) {
            ArgumentChecks.ensurePositive((String)"actualSize", (int)s);
            numElements *= s;
        }
        int order = this.order();
        ParameterDescriptor[] descriptors = new ParameterDescriptor[order + numElements];
        System.arraycopy(this.dimensions, 0, descriptors, 0, order);
        int[] indices = new int[order];
        block1: for (int i = 0; i < numElements; ++i) {
            descriptors[order + i] = this.getElementDescriptor(indices);
            int j = indices.length;
            while (--j >= 0) {
                int n = j;
                indices[n] = indices[n] + 1;
                if (indices[n] < actualSize[j]) continue block1;
                indices[j] = 0;
            }
        }
        return descriptors;
    }

    public ParameterValueGroup createValueGroup(Map<String, ?> properties) {
        return new MatrixParameterValues(properties, this);
    }

    public ParameterValueGroup createValueGroup(Map<String, ?> properties, Matrix matrix) {
        if (this.order() != 2) {
            throw new IllegalStateException();
        }
        ArgumentChecks.ensureNonNull((String)"matrix", (Object)matrix);
        MatrixParameterValues values = new MatrixParameterValues(properties, this);
        values.setMatrix(matrix);
        return values;
    }

    public Matrix toMatrix(ParameterValueGroup parameters) {
        if (this.order() != 2) {
            throw new IllegalStateException();
        }
        if (Objects.requireNonNull(parameters) instanceof MatrixParameterValues) {
            return ((MatrixParameterValues)parameters).toMatrix();
        }
        ParameterValue numRow = parameters.parameter(this.dimensions[0].getName().getCode());
        ParameterValue numCol = parameters.parameter(this.dimensions[1].getName().getCode());
        MatrixSIS matrix = Matrices.createDiagonal(numRow.intValue(), numCol.intValue());
        List values = parameters.values();
        if (values != null) {
            for (GeneralParameterValue param : values) {
                if (param == numRow || param == numCol) continue;
                String name = param.getDescriptor().getName().getCode();
                IllegalArgumentException cause = null;
                int[] indices = null;
                try {
                    indices = this.nameToIndices(name);
                }
                catch (IllegalArgumentException e) {
                    cause = e;
                }
                if (indices == null) {
                    throw (InvalidParameterNameException)new InvalidParameterNameException(Errors.format((short)172, (Object)name), name).initCause((Throwable)cause);
                }
                matrix.setElement(indices[0], indices[1], ((ParameterValue)param).doubleValue());
            }
        }
        return matrix;
    }

    public int hashCode() {
        return Objects.hash(this.elementType, this.prefix, this.separator) ^ Arrays.hashCode(this.dimensions);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other.getClass() == this.getClass()) {
            MatrixParameters that = (MatrixParameters)other;
            return this.elementType.equals(that.elementType) && this.prefix.equals(that.prefix) && this.separator.equals(that.separator) && Arrays.equals(this.dimensions, that.dimensions);
        }
        return false;
    }

    public String toString() {
        if (this.equals(WKT1)) {
            return "WKT1";
        }
        int order = this.order();
        String[] names = new String[order + 1];
        for (int i = 0; i < order; ++i) {
            names[i] = this.dimensions[i].getName().getCode();
        }
        names[order] = this.prefix + "*";
        return Strings.toString(this.getClass(), (Object[])new Object[]{"descriptors", names});
    }

    final Object readResolve() throws ObjectStreamException {
        if (this.equals(WKT1)) {
            return WKT1;
        }
        if (this.equals(EPSG)) {
            return EPSG;
        }
        if (this.equals(ALPHANUM)) {
            return ALPHANUM;
        }
        this.parameters = this.createCache();
        return this;
    }
}

