/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.sis.referencing.gazetteer.GazetteerException;
import org.apache.sis.referencing.gazetteer.GeohashReferenceSystem;
import org.apache.sis.referencing.gazetteer.MilitaryGridReferenceSystem;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.referencing.gazetteer.internal.Resources;
import org.apache.sis.util.iso.AbstractFactory;

public class GazetteerFactory
extends AbstractFactory {
    public Set<String> getSupportedNames() {
        return new LinkedHashSet<String>(List.of("MGRS", "Geohash"));
    }

    public ReferencingByIdentifiers forName(String name) throws GazetteerException {
        return this.forNameIfKnown(name).orElseThrow(() -> new GazetteerException(Resources.format((short)16, name)));
    }

    public Optional<ReferencingByIdentifiers> forNameIfKnown(String name) throws GazetteerException {
        int s = name.lastIndexOf(58);
        if (s < 0 || name.substring(0, s).trim().equalsIgnoreCase("SIS")) {
            switch (name = name.substring(s + 1).trim()) {
                case "MGRS": {
                    return Optional.of(MilitaryGridReferenceSystem.getInstance());
                }
                case "Geohash": {
                    return Optional.of(GeohashReferenceSystem.getInstance());
                }
            }
        }
        return Optional.empty();
    }
}

