/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.interceptors.SystemExceptionHelper;
import org.apache.cxf.binding.corba.utils.CorbaUtils;
import org.apache.cxf.binding.corba.wsdl.AddressType;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;

public class OrbConfig {
    protected String orbClass;
    protected String orbSingletonClass;
    protected List<String> orbArgs = new ArrayList<String>();
    protected Properties orbProperties = new Properties();

    public void setOrbClass(String cls) {
        this.orbClass = cls;
    }

    public String getOrbClass() {
        return this.orbClass;
    }

    public void setOrbSingletonClass(String cls) {
        this.orbSingletonClass = cls;
    }

    public String getOrbSingletonClass() {
        return this.orbSingletonClass;
    }

    public void setOrbArgs(List<String> args) {
        this.orbArgs = args;
    }

    public List<String> getOrbArgs() {
        return this.orbArgs;
    }

    public void setOrbProperties(Properties props) {
        this.orbProperties = props;
    }

    public Properties getOrbProperties() {
        return this.orbProperties;
    }

    public void addPOAPolicies(ORB orb, String poaName, POA parentPOA, POAManager poaManager, List<Policy> policies) {
    }

    public Any createSystemExceptionAny(ORB orb, SystemException sysEx) {
        Any exAny = orb.create_any();
        SystemExceptionHelper.insert(exAny, sysEx);
        return exAny;
    }

    public void exportObjectReference(ORB orb, Object ref, String url, AddressType address) throws URISyntaxException, IOException {
        if (url.startsWith("ior:") || url.startsWith("IOR:")) {
            String ior = CorbaUtils.exportObjectReference(ref, orb);
            address.setLocation(ior);
        } else if (url.startsWith("file:")) {
            URI uri = new URI(url);
            this.exportObjectReferenceToFile(orb, ref, uri);
        } else if (url.startsWith("relfile:")) {
            URI uri = new URI(url.substring(3));
            this.exportObjectReferenceToFile(orb, ref, uri);
        } else if (url.startsWith("corbaloc:")) {
            this.exportObjectReferenceToCorbaloc(orb, ref, url);
        } else if (url.startsWith("corbaname:")) {
            this.exportObjectReferenceToNamingService(orb, ref, url);
        } else {
            String ior = orb.object_to_string(ref);
            address.setLocation(ior);
            URI uri = new URI("endpoint.ior");
            this.exportObjectReferenceToFile(orb, ref, uri);
        }
    }

    public void exportObjectReferenceToNamingService(ORB orb, Object ref, String location) {
        int idx = location.indexOf("#");
        String name = location.substring(idx + 1);
        try {
            Object nsObj = orb.resolve_initial_references("NameService");
            NamingContextExt rootContext = NamingContextExtHelper.narrow((Object)nsObj);
            NameComponent[] nc = rootContext.to_name(name);
            rootContext.rebind(nc, ref);
        }
        catch (Exception ex) {
            throw new CorbaBindingException(ex);
        }
    }

    public void exportObjectReferenceToCorbaloc(ORB orb, Object object, String location) {
        int keyIndex = location.indexOf(47);
        String key = location.substring(keyIndex + 1);
        try {
            Class<?> bootMgrHelperClass = Class.forName("org.apache.yoko.orb.OB.BootManagerHelper");
            Class<?> bootMgrClass = Class.forName("org.apache.yoko.orb.OB.BootManager");
            Method narrowMethod = bootMgrHelperClass.getMethod("narrow", Object.class);
            java.lang.Object bootMgr = narrowMethod.invoke(null, orb.resolve_initial_references("BootManager"));
            Method addBindingMethod = bootMgrClass.getMethod("add_binding", byte[].class, Object.class);
            addBindingMethod.invoke(bootMgr, key.getBytes(), object);
        }
        catch (ClassNotFoundException bootMgrHelperClass) {
        }
        catch (InvocationTargetException bootMgrHelperClass) {
        }
        catch (Exception ex) {
            throw new CorbaBindingException(ex.getMessage(), ex);
        }
    }

    public void exportObjectReferenceToFile(ORB orb, Object obj, URI iorFile) throws IOException {
        String ref = orb.object_to_string(obj);
        File f = null;
        f = iorFile.isOpaque() ? new File(iorFile.getSchemeSpecificPart()) : new File(iorFile);
        try (FileOutputStream file = new FileOutputStream(f);
             PrintWriter out = new PrintWriter(file);){
            out.println(ref);
            out.flush();
        }
    }
}

