/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.util;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.felix.utils.properties.Properties;

public class BootstrapLogManager {
    private static final String KARAF_BOOTSTRAP_LOG = "karaf.bootstrap.log";
    private static final String LOG4J_APPENDER_FILE = "log4j.appender.out.file";
    private static BootstrapLogManager instance;
    private Handler handler;
    private Properties configProps;
    private String log4jConfigPath;

    public BootstrapLogManager(Properties configProps, String log4jConfigPath) {
        this.configProps = configProps;
        this.log4jConfigPath = log4jConfigPath;
        this.handler = null;
    }

    public static synchronized Handler getDefaultHandler() {
        if (instance == null) {
            throw new IllegalStateException("Properties must be set before calling getDefaultHandler");
        }
        return instance.getDefaultHandlerInternal();
    }

    public static void setProperties(Properties configProps) {
        BootstrapLogManager.setProperties(configProps, null);
    }

    public static void setProperties(Properties configProps, String log4jConfigPath) {
        instance = new BootstrapLogManager(configProps, log4jConfigPath);
    }

    private Handler getDefaultHandlerInternal() {
        if (this.handler != null) {
            return this.handler;
        }
        String filename = this.getLogFilePath();
        filename = InterpolationHelper.substVars(filename, LOG4J_APPENDER_FILE, null, this.configProps);
        File logFile = new File(filename);
        try {
            return new SimpleFileHandler(logFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPaxLoggingConfig() {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.log4jConfigPath);
            props.load(fis);
        }
        catch (Exception exception) {
            BootstrapLogManager.close(fis);
        }
        catch (Throwable throwable) {
            BootstrapLogManager.close(fis);
            throw throwable;
        }
        BootstrapLogManager.close(fis);
        return props;
    }

    private static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String getLogFilePath() {
        String filename;
        String string = filename = this.configProps == null ? null : this.configProps.getProperty(KARAF_BOOTSTRAP_LOG);
        if (filename != null) {
            return filename;
        }
        Properties props = this.loadPaxLoggingConfig();
        return props.getProperty(LOG4J_APPENDER_FILE, "${karaf.data}/log/karaf.log");
    }

    public static class SimpleFileHandler
    extends StreamHandler {
        public SimpleFileHandler(File file) throws IOException {
            this.open(file, true);
        }

        private void open(File logfile, boolean append) throws IOException {
            if (!logfile.getParentFile().exists()) {
                try {
                    logfile.getParentFile().mkdirs();
                }
                catch (SecurityException se) {
                    throw new IOException(se.getMessage());
                }
            }
            FileOutputStream fout = new FileOutputStream(logfile, append);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            this.setOutputStream(out);
        }

        @Override
        public synchronized void publish(LogRecord record) {
            if (!this.isLoggable(record)) {
                return;
            }
            super.publish(record);
            this.flush();
        }
    }
}

