/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.MemoizedScopeCreator;
import com.google.javascript.jscomp.ModuleMetadataMap;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class NodeTraversal {
    private final AbstractCompiler compiler;
    private final Callback callback;
    private Node curNode;
    private Node curScript;
    private Node currentChangeScope;
    private final Deque<AbstractScope<?, ?>> scopes = new ArrayDeque();
    private final List<Node> scopeRoots = new ArrayList<Node>();
    private final Deque<Object> cfgs = new ArrayDeque<Object>();
    private String sourceName;
    private InputId inputId;
    private CompilerInput compilerInput;
    private final ScopeCreator scopeCreator;
    private final boolean useBlockScope;
    private ScopedCallback scopeCallback;
    private static final String MISSING_SOURCE = "[source unknown]";

    private static Callback makePostOrderCallback(final AbstractPostOrderCallbackInterface lambda) {
        return new Callback(){

            @Override
            public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
                return true;
            }

            @Override
            public final void visit(NodeTraversal t, Node n, Node parent) {
                lambda.visit(t, n, parent);
            }
        };
    }

    public NodeTraversal(AbstractCompiler compiler, Callback cb, ScopeCreator scopeCreator) {
        this.callback = cb;
        if (cb instanceof ScopedCallback) {
            this.scopeCallback = (ScopedCallback)cb;
        }
        this.compiler = compiler;
        this.scopeCreator = scopeCreator;
        this.useBlockScope = scopeCreator.hasBlockScope();
    }

    private void throwUnexpectedException(Throwable unexpectedException) {
        String message = unexpectedException.getMessage();
        if (this.inputId != null) {
            message = unexpectedException.getMessage() + "\n" + this.formatNodeContext("Node", this.curNode) + (this.curNode == null ? "" : this.formatNodeContext("Parent", this.curNode.getParent()));
        }
        this.compiler.throwInternalError(message, unexpectedException);
    }

    private String formatNodeContext(String label, Node n) {
        if (n == null) {
            return "  " + label + ": NULL";
        }
        return "  " + label + "(" + n.toString(false, false, false) + "): " + this.formatNodePosition(n);
    }

    public void traverse(Node root) {
        try {
            this.initTraversal(root);
            this.curNode = root;
            this.pushScope(root);
            this.traverseBranch(root, null);
            this.popScope();
        }
        catch (Error | Exception unexpectedException) {
            this.throwUnexpectedException(unexpectedException);
        }
    }

    public static void traverse(AbstractCompiler compiler, Node root, Callback cb) {
        NodeTraversal t = new NodeTraversal(compiler, cb, new Es6SyntacticScopeCreator(compiler));
        t.traverse(root);
    }

    public static void traversePostOrder(AbstractCompiler compiler, Node root, AbstractPostOrderCallbackInterface cb) {
        NodeTraversal.traverse(compiler, root, NodeTraversal.makePostOrderCallback(cb));
    }

    void traverseRoots(Node externs, Node root) {
        try {
            Node scopeRoot = externs.getParent();
            Preconditions.checkNotNull(scopeRoot);
            this.initTraversal(scopeRoot);
            this.curNode = scopeRoot;
            this.pushScope(scopeRoot);
            this.traverseBranch(externs, scopeRoot);
            Preconditions.checkState(root.getParent() == scopeRoot);
            this.traverseBranch(root, scopeRoot);
            this.popScope();
        }
        catch (Error | Exception unexpectedException) {
            this.throwUnexpectedException(unexpectedException);
        }
    }

    public static void traverseRoots(AbstractCompiler compiler, Callback cb, Node externs, Node root) {
        NodeTraversal t = new NodeTraversal(compiler, cb, new Es6SyntacticScopeCreator(compiler));
        t.traverseRoots(externs, root);
    }

    private String formatNodePosition(Node n) {
        String sourceFileName = this.getBestSourceFileName(n);
        if (sourceFileName == null) {
            return "[source unknown]\n";
        }
        int lineNumber = n.getLineno();
        int columnNumber = n.getCharno();
        String src = this.compiler.getSourceLine(sourceFileName, lineNumber);
        if (src == null) {
            src = MISSING_SOURCE;
        }
        return sourceFileName + ":" + lineNumber + ":" + columnNumber + "\n" + src + "\n";
    }

    void traverseWithScope(Node root, AbstractScope<?, ?> s) {
        Preconditions.checkState(s.isGlobal() || s.isModuleScope(), s);
        try {
            this.initTraversal(root);
            this.curNode = root;
            this.pushScope(s);
            this.traverseBranch(root, null);
            this.popScope();
        }
        catch (Error | Exception unexpectedException) {
            this.throwUnexpectedException(unexpectedException);
        }
    }

    void traverseAtScope(AbstractScope<?, ?> s) {
        Node n = s.getRootNode();
        this.initTraversal(n);
        this.curNode = n;
        ArrayDeque parentScopes = new ArrayDeque();
        for (Object temp = s.getParent(); temp != null; temp = ((AbstractScope)temp).getParent()) {
            parentScopes.push(temp);
        }
        while (!parentScopes.isEmpty()) {
            this.pushScope((AbstractScope)parentScopes.pop(), true);
        }
        if (n.isFunction()) {
            if (this.callback.shouldTraverse(this, n, null)) {
                this.pushScope(s);
                Node fnName = n.getFirstChild();
                Node args = fnName.getNext();
                Node body = args.getNext();
                if (!NodeUtil.isFunctionDeclaration(n)) {
                    this.traverseBranch(fnName, n);
                }
                this.traverseBranch(args, n);
                this.traverseBranch(body, n);
                this.popScope();
                this.callback.visit(this, n, null);
            }
        } else if (n.isClass()) {
            if (this.callback.shouldTraverse(this, n, null)) {
                this.pushScope(s);
                Node className = n.getFirstChild();
                Node body = n.getLastChild();
                if (NodeUtil.isClassExpression(n)) {
                    this.traverseBranch(className, n);
                }
                this.traverseBranch(body, n);
                this.popScope();
                this.callback.visit(this, n, null);
            }
        } else if (n.isBlock()) {
            if (this.callback.shouldTraverse(this, n, null)) {
                this.pushScope(s);
                this.traverseChildren(n);
                this.popScope();
                this.callback.visit(this, n, null);
            }
        } else if (NodeUtil.isAnyFor(n)) {
            if (this.callback.shouldTraverse(this, n, null)) {
                Preconditions.checkState(this.scopeCreator.hasBlockScope());
                this.pushScope(s);
                Node forAssignmentParam = n.getFirstChild();
                Node forIterableParam = forAssignmentParam.getNext();
                Node forBodyScope = forIterableParam.getNext();
                this.traverseBranch(forAssignmentParam, n);
                this.traverseBranch(forIterableParam, n);
                this.traverseBranch(forBodyScope, n);
                this.popScope();
                this.callback.visit(this, n, null);
            }
        } else if (n.isSwitch()) {
            if (this.callback.shouldTraverse(this, n, null)) {
                Preconditions.checkState(this.scopeCreator.hasBlockScope());
                this.pushScope(s);
                this.traverseChildren(n);
                this.popScope();
                this.callback.visit(this, n, null);
            }
        } else {
            Preconditions.checkState(s.isGlobal() || s.isModuleScope(), "Expected global or module scope. Got:", s);
            this.traverseWithScope(n, s);
        }
    }

    private void traverseScopeRoot(Node scopeRoot) {
        try {
            this.initTraversal(scopeRoot);
            this.curNode = scopeRoot;
            this.initScopeRoots(scopeRoot.getParent());
            this.traverseBranch(scopeRoot, scopeRoot.getParent());
        }
        catch (Error | Exception unexpectedException) {
            this.throwUnexpectedException(unexpectedException);
        }
    }

    public static void traverseScopeRoots(AbstractCompiler compiler, @Nullable Node root, @Nullable List<Node> scopeNodes, Callback cb, boolean traverseNested) {
        NodeTraversal.traverseScopeRoots(compiler, root, scopeNodes, cb, null, traverseNested);
    }

    public static void traverseScopeRoots(AbstractCompiler compiler, @Nullable Node root, @Nullable List<Node> scopeNodes, Callback cb, @Nullable ChangeScopeRootCallback changeCallback, boolean traverseNested) {
        if (scopeNodes == null) {
            NodeTraversal.traverse(compiler, root, cb);
        } else {
            MemoizedScopeCreator scopeCreator = new MemoizedScopeCreator(new Es6SyntacticScopeCreator(compiler));
            for (Node scopeNode : scopeNodes) {
                NodeTraversal.traverseSingleScopeRoot(compiler, cb, changeCallback, traverseNested, scopeCreator, scopeNode);
            }
        }
    }

    private static void traverseSingleScopeRoot(AbstractCompiler compiler, final Callback cb, @Nullable ChangeScopeRootCallback changeCallback, final boolean traverseNested, MemoizedScopeCreator scopeCreator, final Node scopeNode) {
        if (changeCallback != null) {
            changeCallback.enterChangeScopeRoot(compiler, scopeNode);
        }
        ScopedCallback scb = new ScopedCallback(){
            boolean insideScopeNode = false;

            @Override
            public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
                if (scopeNode == n) {
                    this.insideScopeNode = true;
                }
                return (traverseNested || scopeNode == n || !NodeUtil.isChangeScopeRoot(n)) && cb.shouldTraverse(t, n, parent);
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (scopeNode == n) {
                    this.insideScopeNode = false;
                }
                cb.visit(t, n, parent);
            }

            @Override
            public void enterScope(NodeTraversal t) {
                if (this.insideScopeNode && cb instanceof ScopedCallback) {
                    ((ScopedCallback)cb).enterScope(t);
                }
            }

            @Override
            public void exitScope(NodeTraversal t) {
                if (this.insideScopeNode && cb instanceof ScopedCallback) {
                    ((ScopedCallback)cb).exitScope(t);
                }
            }
        };
        NodeTraversal.traverseEs6ScopeRoot(compiler, scopeNode, scb, scopeCreator);
    }

    public void traverseFunctionOutOfBand(Node node, AbstractScope<?, ?> scope) {
        Preconditions.checkNotNull(scope);
        Preconditions.checkState(node.isFunction(), node);
        Preconditions.checkNotNull(scope.getRootNode());
        this.initTraversal(node);
        this.curNode = node.getParent();
        this.pushScope(scope, true);
        this.traverseBranch(node, this.curNode);
        this.popScope(true);
    }

    void traverseInnerNode(Node node, Node parent, AbstractScope<?, ?> refinedScope) {
        Preconditions.checkNotNull(parent);
        this.initTraversal(node);
        if (refinedScope != null && this.getAbstractScope() != refinedScope) {
            this.curNode = node;
            this.pushScope(refinedScope);
            this.traverseBranch(node, parent);
            this.popScope();
        } else {
            this.traverseBranch(node, parent);
        }
    }

    public AbstractCompiler getCompiler() {
        return this.compiler;
    }

    public int getLineNumber() {
        for (Node cur = this.curNode; cur != null; cur = cur.getParent()) {
            int line = cur.getLineno();
            if (line < 0) continue;
            return line;
        }
        return 0;
    }

    public int getCharno() {
        for (Node cur = this.curNode; cur != null; cur = cur.getParent()) {
            int line = cur.getCharno();
            if (line < 0) continue;
            return line;
        }
        return 0;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public CompilerInput getInput() {
        if (this.compilerInput == null && this.inputId != null) {
            this.compilerInput = this.compiler.getInput(this.inputId);
        }
        return this.compilerInput;
    }

    public JSModule getModule() {
        CompilerInput input = this.getInput();
        return input == null ? null : input.getModule();
    }

    public Node getCurrentNode() {
        return this.curNode;
    }

    public static void traverseChangedFunctions(final AbstractCompiler compiler, final ChangeScopeRootCallback callback) {
        Node jsRoot = compiler.getJsRoot();
        NodeTraversal.traverse(compiler, jsRoot, new AbstractPreOrderCallback(){

            @Override
            public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
                if (NodeUtil.isChangeScopeRoot(n) && compiler.hasScopeChanged(n)) {
                    callback.enterChangeScopeRoot(compiler, n);
                }
                return true;
            }
        });
    }

    @Deprecated
    public static final void traverseEs6(AbstractCompiler compiler, Node root, Callback cb) {
        NodeTraversal.traverse(compiler, root, cb);
    }

    private static void traverseEs6ScopeRoot(AbstractCompiler compiler, Node scopeNode, Callback cb, MemoizedScopeCreator scopeCreator) {
        NodeTraversal t = new NodeTraversal(compiler, cb, scopeCreator);
        t.traverseScopeRoot(scopeNode);
    }

    @Deprecated
    public static void traverseTyped(AbstractCompiler compiler, Node root, Callback cb) {
        NodeTraversal t = new NodeTraversal(compiler, cb, SyntacticScopeCreator.makeTyped(compiler));
        t.traverse(root);
    }

    @Deprecated
    public static void traverseRootsTyped(AbstractCompiler compiler, Callback cb, Node externs, Node root) {
        NodeTraversal t = new NodeTraversal(compiler, cb, SyntacticScopeCreator.makeTyped(compiler));
        t.traverseRoots(externs, root);
    }

    private void handleScript(Node n, Node parent) {
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        this.setChangeScope(n);
        this.setInputId(n.getInputId(), NodeTraversal.getSourceName(n));
        this.curNode = n;
        this.curScript = n;
        if (this.callback.shouldTraverse(this, n, parent)) {
            this.traverseChildren(n);
            this.curNode = n;
            this.callback.visit(this, n, parent);
        }
        this.setChangeScope(null);
    }

    private void handleFunction(Node n, Node parent) {
        Node changeScope = this.currentChangeScope;
        this.setChangeScope(n);
        this.curNode = n;
        if (this.callback.shouldTraverse(this, n, parent)) {
            this.traverseFunction(n, parent);
            this.curNode = n;
            this.callback.visit(this, n, parent);
        }
        this.setChangeScope(changeScope);
    }

    private void traverseBranch(Node n, Node parent) {
        Token type = n.getToken();
        if (type == Token.SCRIPT) {
            this.handleScript(n, parent);
            return;
        }
        if (type == Token.FUNCTION) {
            this.handleFunction(n, parent);
            return;
        }
        this.curNode = n;
        if (!this.callback.shouldTraverse(this, n, parent)) {
            return;
        }
        if (type == Token.CLASS) {
            this.traverseClass(n);
        } else if (type == Token.CLASS_MEMBERS) {
            this.traverseClassMembers(n);
        } else if (type == Token.MODULE_BODY) {
            this.traverseModule(n);
        } else if (this.useBlockScope && NodeUtil.createsBlockScope(n)) {
            this.traverseBlockScope(n);
        } else {
            this.traverseChildren(n);
        }
        this.curNode = n;
        this.callback.visit(this, n, parent);
    }

    private void traverseFunction(Node n, Node parent) {
        boolean isFunctionDeclaration;
        Node fnName = n.getFirstChild();
        boolean bl = isFunctionDeclaration = parent != null && NodeUtil.isFunctionDeclaration(n);
        if (isFunctionDeclaration) {
            this.traverseBranch(fnName, n);
        }
        this.curNode = n;
        this.pushScope(n);
        if (!isFunctionDeclaration) {
            this.traverseBranch(fnName, n);
        }
        Node args = fnName.getNext();
        Node body = args.getNext();
        this.traverseBranch(args, n);
        this.traverseBranch(body, n);
        this.popScope();
    }

    private void traverseClass(Node n) {
        Node className = n.getFirstChild();
        Node extendsClause = className.getNext();
        Node body = extendsClause.getNext();
        boolean isClassExpression = NodeUtil.isClassExpression(n);
        this.traverseBranch(extendsClause, n);
        Node child = body.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (child.isComputedProp()) {
                this.traverseBranch(child.getFirstChild(), child);
            }
            child = next;
        }
        if (!isClassExpression) {
            this.traverseBranch(className, n);
        }
        this.curNode = n;
        this.pushScope(n);
        if (isClassExpression) {
            this.traverseBranch(className, n);
        }
        this.traverseBranch(body, n);
        this.popScope();
    }

    private void traverseClassMembers(Node n) {
        Node child = n.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (child.isComputedProp()) {
                this.curNode = n;
                if (this.callback.shouldTraverse(this, child, n)) {
                    this.traverseBranch(child.getLastChild(), child);
                    this.curNode = n;
                    this.callback.visit(this, child, n);
                }
            } else {
                this.traverseBranch(child, n);
            }
            child = next;
        }
    }

    private void traverseChildren(Node n) {
        Node child = n.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            this.traverseBranch(child, n);
            child = next;
        }
    }

    private void traverseModule(Node n) {
        this.pushScope(n);
        this.traverseChildren(n);
        this.popScope();
    }

    private void traverseBlockScope(Node n) {
        this.pushScope(n);
        this.traverseChildren(n);
        this.popScope();
    }

    public Node getEnclosingFunction() {
        Node root = this.getCfgRoot();
        return root.isFunction() ? root : null;
    }

    private void recordScopeRoot(Node node) {
        if (NodeUtil.isValidCfgRoot(node)) {
            this.cfgs.push(node);
        }
    }

    private void pushScope(Node node) {
        Preconditions.checkNotNull(this.curNode);
        Preconditions.checkNotNull(node);
        this.scopeRoots.add(node);
        this.recordScopeRoot(node);
        if (this.scopeCallback != null) {
            this.scopeCallback.enterScope(this);
        }
    }

    private void pushScope(AbstractScope<?, ?> s) {
        this.pushScope(s, false);
    }

    private void pushScope(AbstractScope<?, ?> s, boolean quietly) {
        Preconditions.checkNotNull(this.curNode);
        this.scopes.push(s);
        this.recordScopeRoot(s.getRootNode());
        if (!quietly && this.scopeCallback != null) {
            this.scopeCallback.enterScope(this);
        }
    }

    private void popScope() {
        this.popScope(false);
    }

    private void popScope(boolean quietly) {
        int roots;
        Node scopeRoot;
        if (!quietly && this.scopeCallback != null) {
            this.scopeCallback.exitScope(this);
        }
        if (NodeUtil.isValidCfgRoot(scopeRoot = (roots = this.scopeRoots.size()) > 0 ? this.scopeRoots.remove(roots - 1) : this.scopes.pop().getRootNode())) {
            this.cfgs.pop();
        }
    }

    public AbstractScope<?, ?> getAbstractScope() {
        AbstractScope<?, ?> scope = this.scopes.peek();
        for (int i = 0; i < this.scopeRoots.size(); ++i) {
            scope = this.scopeCreator.createScope(this.scopeRoots.get(i), scope);
            this.scopes.push(scope);
        }
        this.scopeRoots.clear();
        return scope;
    }

    private AbstractScope<?, ?> instantiateScopes(int count) {
        Preconditions.checkArgument(count <= this.scopeRoots.size());
        AbstractScope<?, ?> scope = this.scopes.peek();
        for (int i = 0; i < count; ++i) {
            scope = this.scopeCreator.createScope(this.scopeRoots.get(i), scope);
            this.scopes.push(scope);
        }
        this.scopeRoots.subList(0, count).clear();
        return scope;
    }

    public boolean isHoistScope() {
        return NodeTraversal.isHoistScopeRootNode(this.getScopeRoot());
    }

    public Node getClosestHoistScopeRoot() {
        int roots;
        for (int i = roots = this.scopeRoots.size(); i > 0; --i) {
            Node rootNode = this.scopeRoots.get(i - 1);
            if (!NodeTraversal.isHoistScopeRootNode(rootNode)) continue;
            return rootNode;
        }
        return ((AbstractScope)this.scopes.peek().getClosestHoistScope()).getRootNode();
    }

    public AbstractScope<?, ?> getClosestContainerScope() {
        for (int i = this.scopeRoots.size(); i > 0; --i) {
            if (NodeUtil.createsBlockScope(this.scopeRoots.get(i - 1))) continue;
            return this.instantiateScopes(i);
        }
        return this.scopes.peek().getClosestContainerScope();
    }

    public AbstractScope<?, ?> getClosestHoistScope() {
        for (int i = this.scopeRoots.size(); i > 0; --i) {
            if (!NodeTraversal.isHoistScopeRootNode(this.scopeRoots.get(i - 1))) continue;
            return this.instantiateScopes(i);
        }
        return this.scopes.peek().getClosestHoistScope();
    }

    private static boolean isHoistScopeRootNode(Node n) {
        switch (n.getToken()) {
            case SCRIPT: 
            case FUNCTION: 
            case MODULE_BODY: 
            case ROOT: {
                return true;
            }
        }
        return NodeUtil.isFunctionBlock(n);
    }

    public Scope getScope() {
        return this.getAbstractScope().untyped();
    }

    public TypedScope getTypedScope() {
        return this.getAbstractScope().typed();
    }

    public ControlFlowGraph<Node> getControlFlowGraph() {
        ControlFlowGraph<Node> result;
        Object o = this.cfgs.peek();
        if (o instanceof Node) {
            Node cfgRoot = (Node)o;
            ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, true);
            cfa.process(null, cfgRoot);
            result = cfa.getCfg();
            this.cfgs.pop();
            this.cfgs.push(result);
        } else {
            result = (ControlFlowGraph<Node>)o;
        }
        return result;
    }

    public Node getScopeRoot() {
        int roots = this.scopeRoots.size();
        if (roots > 0) {
            return this.scopeRoots.get(roots - 1);
        }
        AbstractScope<?, ?> s = this.scopes.peek();
        return s != null ? s.getRootNode() : null;
    }

    private Node getCfgRoot() {
        Object o = this.cfgs.peek();
        Node result = o instanceof Node ? (Node)o : (Node)((ControlFlowGraph)o).getEntry().getValue();
        return result;
    }

    public ScopeCreator getScopeCreator() {
        return this.scopeCreator;
    }

    public boolean inGlobalScope() {
        return this.getScopeDepth() == 0;
    }

    public boolean inFunctionBlockScope() {
        return NodeUtil.isFunctionBlock(this.getScopeRoot());
    }

    public boolean inGlobalHoistScope() {
        Node cfgRoot = this.getCfgRoot();
        Preconditions.checkState(cfgRoot.isScript() || cfgRoot.isRoot() || cfgRoot.isBlock() || cfgRoot.isFunction() || cfgRoot.isModuleBody(), cfgRoot);
        return cfgRoot.isScript() || cfgRoot.isRoot() || cfgRoot.isBlock();
    }

    public boolean inModuleScope() {
        return NodeUtil.isModuleScopeRoot(this.getScopeRoot());
    }

    public boolean inModuleHoistScope() {
        Node moduleRoot = this.getCfgRoot();
        if (moduleRoot.isFunction()) {
            moduleRoot = moduleRoot.getLastChild();
        }
        return NodeUtil.isModuleScopeRoot(moduleRoot);
    }

    int getScopeDepth() {
        int sum = this.scopes.size() + this.scopeRoots.size();
        Preconditions.checkState(sum > 0);
        return sum - 1;
    }

    public void report(Node n, DiagnosticType diagnosticType, String ... arguments) {
        JSError error = JSError.make(n, diagnosticType, arguments);
        this.compiler.report(error);
    }

    public void reportCodeChange() {
        Node changeScope = this.currentChangeScope;
        Preconditions.checkNotNull(changeScope);
        Preconditions.checkState(NodeUtil.isChangeScopeRoot(changeScope), changeScope);
        this.compiler.reportChangeToChangeScope(changeScope);
    }

    public void reportCodeChange(Node n) {
        this.compiler.reportChangeToEnclosingScope(n);
    }

    private static String getSourceName(Node n) {
        String name = n.getSourceFileName();
        return Strings.nullToEmpty(name);
    }

    public Node getCurrentFile() {
        return this.curScript;
    }

    private void setChangeScope(Node n) {
        this.currentChangeScope = n;
    }

    private Node getEnclosingScript(Node n) {
        while (n != null && !n.isScript()) {
            n = n.getParent();
        }
        return n;
    }

    private void initTraversal(Node traversalRoot) {
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        Node changeScope = NodeUtil.getEnclosingChangeScopeRoot(traversalRoot);
        this.setChangeScope(changeScope);
        Node script = this.getEnclosingScript(changeScope);
        if (script != null) {
            this.setInputId(script.getInputId(), script.getSourceFileName());
        } else {
            this.setInputId(null, "");
        }
        this.curScript = script;
    }

    private void initScopeRoots(Node n) {
        ArrayDeque<Node> queuedScopeRoots = new ArrayDeque<Node>();
        while (n != null) {
            if (this.isScopeRoot(n)) {
                queuedScopeRoots.addFirst(n);
            }
            n = n.getParent();
        }
        for (Node queuedScopeRoot : queuedScopeRoots) {
            this.pushScope(queuedScopeRoot);
        }
    }

    private boolean isScopeRoot(Node n) {
        if (n.isRoot() && n.getParent() == null) {
            return true;
        }
        if (n.isFunction()) {
            return true;
        }
        return this.useBlockScope && NodeUtil.createsBlockScope(n);
    }

    private void setInputId(InputId id, String sourceName) {
        this.inputId = id;
        this.sourceName = sourceName;
        this.compilerInput = null;
    }

    InputId getInputId() {
        return this.inputId;
    }

    public JSError makeError(Node n, CheckLevel level, DiagnosticType type, String ... arguments) {
        return JSError.make(n, level, type, arguments);
    }

    public JSError makeError(Node n, DiagnosticType type, String ... arguments) {
        return JSError.make(n, type, arguments);
    }

    private String getBestSourceFileName(Node n) {
        return n == null ? this.sourceName : n.getSourceFileName();
    }

    public static abstract class AbstractNodeTypePruningCallback
    implements Callback {
        private final Set<Token> nodeTypes;
        private final boolean include;

        public AbstractNodeTypePruningCallback(Set<Token> nodeTypes) {
            this(nodeTypes, true);
        }

        public AbstractNodeTypePruningCallback(Set<Token> nodeTypes, boolean include) {
            this.nodeTypes = nodeTypes;
            this.include = include;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return this.include == this.nodeTypes.contains((Object)n.getToken());
        }
    }

    public static abstract class AbstractModuleCallback
    implements Callback {
        protected final AbstractCompiler compiler;
        private final ModuleMetadataMap moduleMetadataMap;
        private ModuleMetadataMap.ModuleMetadata currentModule;
        private Node scopeRoot;
        private boolean inLoadModule;

        AbstractModuleCallback(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap) {
            this.compiler = compiler;
            this.moduleMetadataMap = moduleMetadataMap;
        }

        protected void enterModule(ModuleMetadataMap.ModuleMetadata currentModule, Node moduleScopeRoot) {
        }

        protected void exitModule(ModuleMetadataMap.ModuleMetadata oldModule, Node moduleScopeRoot) {
        }

        @Override
        public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case SCRIPT: {
                    this.currentModule = this.moduleMetadataMap.getModulesByPath().get(t.getInput().getPath().toString());
                    Preconditions.checkNotNull(this.currentModule);
                    this.scopeRoot = n.hasChildren() && n.getFirstChild().isModuleBody() ? n.getFirstChild() : n;
                    this.enterModule(this.currentModule, this.scopeRoot);
                    break;
                }
                case BLOCK: {
                    if (!NodeUtil.isBundledGoogModuleScopeRoot(n)) break;
                    this.scopeRoot = n;
                    this.inLoadModule = true;
                    break;
                }
                case CALL: {
                    if (!this.inLoadModule || !n.getFirstChild().matchesQualifiedName("goog.module")) break;
                    ModuleMetadataMap.ModuleMetadata newModule = this.moduleMetadataMap.getModulesByGoogNamespace().get(n.getLastChild().getString());
                    Preconditions.checkNotNull(newModule);
                    if (newModule == this.currentModule) break;
                    this.currentModule = newModule;
                    this.enterModule(this.currentModule, this.scopeRoot);
                    break;
                }
            }
            return this.shouldTraverse(t, n, this.currentModule, this.scopeRoot);
        }

        protected boolean shouldTraverse(NodeTraversal t, Node n, @Nullable ModuleMetadataMap.ModuleMetadata currentModule, @Nullable Node moduleScopeRoot) {
            return true;
        }

        @Override
        public final void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case SCRIPT: {
                    Preconditions.checkNotNull(this.currentModule);
                    this.exitModule(this.currentModule, this.scopeRoot);
                    this.currentModule = null;
                    this.scopeRoot = null;
                    break;
                }
                case BLOCK: {
                    if (!NodeUtil.isBundledGoogModuleScopeRoot(n)) break;
                    Preconditions.checkNotNull(this.currentModule);
                    this.exitModule(this.currentModule, this.scopeRoot);
                    this.scopeRoot = n.getGrandparent().getGrandparent();
                    this.inLoadModule = false;
                    this.currentModule = this.moduleMetadataMap.getModulesByPath().get(t.getInput().getPath().toString());
                    Preconditions.checkNotNull(this.currentModule);
                    break;
                }
            }
            this.visit(t, n, this.currentModule, this.scopeRoot);
        }

        protected void visit(NodeTraversal t, Node n, @Nullable ModuleMetadataMap.ModuleMetadata currentModule, @Nullable Node moduleScopeRoot) {
        }
    }

    public static abstract class AbstractShallowStatementCallback
    implements Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent);
        }
    }

    public static abstract class AbstractShallowCallback
    implements Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return parent == null || !parent.isFunction() || n == parent.getFirstChild();
        }
    }

    public static abstract class AbstractScopedCallback
    implements ScopedCallback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return true;
        }

        @Override
        public void enterScope(NodeTraversal t) {
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }
    }

    public static abstract class AbstractPreOrderCallback
    implements Callback {
        @Override
        public final void visit(NodeTraversal t, Node n, Node parent) {
        }
    }

    @FunctionalInterface
    public static interface AbstractPostOrderCallbackInterface {
        public void visit(NodeTraversal var1, Node var2, Node var3);
    }

    public static abstract class AbstractPostOrderCallback
    implements Callback {
        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return true;
        }
    }

    public static interface ScopedCallback
    extends Callback {
        public void enterScope(NodeTraversal var1);

        public void exitScope(NodeTraversal var1);
    }

    public static interface Callback {
        public boolean shouldTraverse(NodeTraversal var1, Node var2, Node var3);

        public void visit(NodeTraversal var1, Node var2, Node var3);
    }

    public static interface ChangeScopeRootCallback {
        public void enterChangeScopeRoot(AbstractCompiler var1, Node var2);
    }
}

