/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.ConformanceConfig;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Requirement;
import com.google.javascript.jscomp.ThreadSafeDelegatingErrorManager;
import com.google.javascript.rhino.Node;

@GwtIncompatible(value="Conformance")
public class ConformanceWhitelister {
    private ConformanceWhitelister() {
    }

    public static ImmutableSet<String> getViolatingPaths(Compiler compiler, Node externs, Node ast, Requirement requirement) {
        return ConformanceWhitelister.getConformanceErrors(compiler, externs, ast, requirement).stream().map(e -> e.sourceName).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<Node> getViolatingNodes(Compiler compiler, Node externs, Node ast, Requirement requirement) {
        return ConformanceWhitelister.getConformanceErrors(compiler, externs, ast, requirement).stream().map(e -> e.node).collect(ImmutableSet.toImmutableSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmutableList<JSError> getConformanceErrors(Compiler compiler, Node externs, Node ast, Requirement requirement) {
        Requirement cleanedRequirement = requirement.toBuilder().clearWhitelist().clearWhitelistRegexp().clearWhitelistEntry().setSeverity(Requirement.Severity.ERROR).build();
        ConformanceConfig cleanedConfig = ConformanceConfig.newBuilder().addRequirement(cleanedRequirement).build();
        ErrorManager oldErrorManager = compiler.getErrorManager();
        final ImmutableList.Builder errors = ImmutableList.builder();
        try {
            compiler.setErrorManager(new ThreadSafeDelegatingErrorManager(oldErrorManager){

                @Override
                public synchronized boolean shouldReportConformanceViolation(Requirement requirement, Optional<Requirement.WhitelistEntry> whitelistEntry, JSError diagnostic) {
                    errors.add(diagnostic);
                    return false;
                }
            });
            CheckConformance check = new CheckConformance(compiler, ImmutableList.of(cleanedConfig));
            check.process(externs, ast);
        }
        finally {
            compiler.setErrorManager(oldErrorManager);
        }
        return errors.build();
    }
}

