/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.ISWCDigest;
import org.apache.royale.swc.ISWCLibrary;
import org.apache.royale.swc.ISWCScript;
import org.apache.royale.swc.io.SWCReader;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.io.ISWFReader;

public class SWCLibrary
implements ISWCLibrary {
    private final Map<String, ISWCScript> scripts = new LinkedHashMap<String, ISWCScript>();
    private final Set<String> keepAS3MetadataSet = new HashSet<String>();
    private final List<ISWCDigest> digests = new ArrayList<ISWCDigest>();
    private final String path;
    private final ISWF librarySWF;

    public SWCLibrary(String path, ISWF swf) {
        this.path = path;
        this.librarySWF = swf;
    }

    public SWCLibrary(String path) {
        this(path, null);
    }

    @Override
    public void addScript(ISWCScript script) {
        assert (script != null);
        String name = script.getName();
        assert (!this.scripts.containsKey(name)) : "Adding duplicated script: " + name;
        this.scripts.put(name, script);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public List<ISWCScript> getScripts() {
        return new ArrayList<ISWCScript>(this.scripts.values());
    }

    @Override
    public Set<String> getKeepAS3MetadataSet() {
        return this.keepAS3MetadataSet;
    }

    @Override
    public void addNameToKeepAS3MetadataSet(String name) {
        this.keepAS3MetadataSet.add(name);
    }

    @Override
    public void readSWFInputStream(ISWFReader swfReader, ISWC swc) {
        ZipFile swcFile = null;
        try {
            swcFile = new ZipFile(swc.getSWCFile());
            InputStream swcFileInputStream = SWCReader.getInputStream(swcFile, this.path);
            if (swcFileInputStream != null) {
                BufferedInputStream inputStream = new BufferedInputStream(swcFileInputStream);
                swfReader.readFrom(inputStream, SWCReader.getReportingPath(swc.getSWCFile().getAbsolutePath(), this.path));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (swcFile != null) {
                try {
                    swcFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public ISWCScript getScript(String name) {
        return this.scripts.get(name);
    }

    @Override
    public List<ISWCDigest> getDigests() {
        return this.digests;
    }

    @Override
    public ISWF getSWF() {
        return this.librarySWF;
    }

    @Override
    public void addDigest(ISWCDigest digest) {
        this.digests.add(digest);
    }

    public void removeDigest(ISWCDigest digest) {
        this.digests.remove(digest);
    }

    public String toString() {
        return this.getPath();
    }
}

