/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.AppliedVectorDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.DynamicAccessNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorAtNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceAccessExpressionNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.utils.ASNodeUtils;

public class BinaryOperatorEmitter
extends JSSubEmitter
implements ISubEmitter<IBinaryOperatorNode> {
    public BinaryOperatorEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IBinaryOperatorNode node) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        String op = node.getOperator().getOperatorText();
        boolean isAssignment = op.contains("=") && !op.contains("==") && !op.startsWith("<") && !op.startsWith(">") && !op.startsWith("!");
        ASTNodeID id = node.getNodeID();
        if (id == ASTNodeID.Op_IsID || id == ASTNodeID.Op_AsID) {
            fjs.emitIsAs((IExpressionNode)node, node.getLeftOperandNode(), node.getRightOperandNode(), id, false);
        } else if (id == ASTNodeID.Op_InstanceOfID) {
            if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                this.write(ASEmitterTokens.PAREN_OPEN);
            }
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.startMapping((ISourceLocation)node, (ISourceLocation)node.getLeftOperandNode());
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.INSTANCEOF);
            this.endMapping((ISourceLocation)node);
            IDefinition dnode = node.getRightOperandNode().resolve(this.getProject());
            if (dnode != null) {
                String dnodeQname = dnode.getQualifiedName();
                boolean isPackageOrFileMember = false;
                if (dnode instanceof IVariableDefinition) {
                    IVariableDefinition variable = (IVariableDefinition)dnode;
                    IVariableDefinition.VariableClassification classification = variable.getVariableClassification();
                    if (classification == IVariableDefinition.VariableClassification.PACKAGE_MEMBER || classification == IVariableDefinition.VariableClassification.FILE_MEMBER) {
                        isPackageOrFileMember = true;
                    }
                } else if (dnode instanceof IFunctionDefinition) {
                    IFunctionDefinition func = (IFunctionDefinition)dnode;
                    IFunctionDefinition.FunctionClassification classification = func.getFunctionClassification();
                    if (classification == IFunctionDefinition.FunctionClassification.PACKAGE_MEMBER || classification == IFunctionDefinition.FunctionClassification.FILE_MEMBER) {
                        isPackageOrFileMember = true;
                    }
                } else if (dnode instanceof ITypeDefinition) {
                    isPackageOrFileMember = true;
                }
                if (isPackageOrFileMember) {
                    dnodeQname = this.getEmitter().formatQualifiedName(dnodeQname);
                }
                this.write(dnodeQname);
            } else {
                this.getWalker().walk((IASNode)node.getRightOperandNode());
            }
            if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                this.write(ASEmitterTokens.PAREN_CLOSE);
            }
        } else {
            IExpressionNode leftSide = node.getLeftOperandNode();
            ITypeDefinition leftDef = leftSide.resolveType(this.getWalker().getProject());
            if (leftSide.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                IASNode lnode = leftSide.getChild(0);
                IASNode rnode = leftSide.getChild(1);
                IDefinition rnodeDef = rnode instanceof IIdentifierNode ? ((IIdentifierNode)rnode).resolve(this.getWalker().getProject()) : null;
                boolean isDynamicAccess = rnode instanceof DynamicAccessNode;
                if (lnode.getNodeID() == ASTNodeID.SuperID && rnodeDef instanceof AccessorDefinition) {
                    if (isAssignment) {
                        IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
                        if (cnode != null) {
                            this.write(this.getEmitter().formatQualifiedName(cnode.getQualifiedName()));
                        } else {
                            this.write(this.getEmitter().formatQualifiedName(this.getModel().getCurrentClass().getQualifiedName()));
                        }
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSGoogEmitterTokens.SUPERCLASS);
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(fjs.formatSetter(rnodeDef.getBaseName()));
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSEmitterTokens.APPLY);
                        this.write(ASEmitterTokens.PAREN_OPEN);
                        this.write(ASEmitterTokens.THIS);
                        this.writeToken(ASEmitterTokens.COMMA);
                        this.write(ASEmitterTokens.SQUARE_OPEN);
                        if (op.length() > 1) {
                            this.write(this.getEmitter().formatQualifiedName(cnode.getQualifiedName()));
                            this.write(ASEmitterTokens.MEMBER_ACCESS);
                            this.write(JSGoogEmitterTokens.SUPERCLASS);
                            this.write(ASEmitterTokens.MEMBER_ACCESS);
                            this.write(fjs.formatGetter(rnodeDef.getBaseName()));
                            this.write(ASEmitterTokens.MEMBER_ACCESS);
                            this.write(JSEmitterTokens.APPLY);
                            this.write(ASEmitterTokens.PAREN_OPEN);
                            this.write(ASEmitterTokens.THIS);
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                            this.write(op.substring(0, 1));
                        }
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.SQUARE_CLOSE);
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                } else if (((JSRoyaleEmitter)this.getEmitter()).isXMLList((IMemberAccessExpressionNode)leftSide)) {
                    MemberAccessExpressionNode xmlNode = (MemberAccessExpressionNode)leftSide;
                    if (node.getNodeID() == ASTNodeID.Op_AssignId) {
                        boolean wrapQuotes = true;
                        this.getWalker().walk((IASNode)xmlNode.getLeftOperandNode());
                        IExpressionNode rightSide = xmlNode.getRightOperandNode();
                        if (rightSide instanceof UnaryOperatorAtNode) {
                            this.write(".setAttribute('");
                            this.getWalker().walk(rightSide.getChild(0));
                        } else if (rightSide instanceof IDynamicAccessNode && ((IDynamicAccessNode)rightSide).getLeftOperandNode().getNodeID() == ASTNodeID.Op_AtID) {
                            this.write(".setAttribute(");
                            wrapQuotes = false;
                            this.getWalker().walk((IASNode)((IDynamicAccessNode)rightSide).getRightOperandNode());
                        } else if (rightSide instanceof INamespaceAccessExpressionNode) {
                            this.write(".setChild(");
                            this.write("new QName(");
                            this.getWalker().walk((IASNode)((INamespaceAccessExpressionNode)rightSide).getLeftOperandNode());
                            this.write(",'");
                            this.getWalker().walk((IASNode)((INamespaceAccessExpressionNode)rightSide).getRightOperandNode());
                            this.write("')");
                            wrapQuotes = false;
                        } else {
                            this.write(".setChild('");
                            this.getWalker().walk((IASNode)rightSide);
                        }
                        if (wrapQuotes) {
                            this.write("'");
                        }
                        this.write(", ");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                    if (node.getNodeID() == ASTNodeID.Op_AddAssignID) {
                        this.getWalker().walk((IASNode)xmlNode.getLeftOperandNode());
                        IExpressionNode rightSide = xmlNode.getRightOperandNode();
                        if (rightSide instanceof UnaryOperatorAtNode) {
                            this.write(".setAttribute('");
                            this.getWalker().walk(((UnaryOperatorAtNode)rightSide).getChild(0));
                        } else {
                            this.write(".setChild('");
                            this.getWalker().walk((IASNode)rightSide);
                        }
                        this.write("', ");
                        this.getWalker().walk((IASNode)node.getLeftOperandNode());
                        this.write(".plus(");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                    if (node.getNodeID() == ASTNodeID.Op_AddID) {
                        this.getWalker().walk((IASNode)xmlNode);
                        this.write(".plus(");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                } else if (isDynamicAccess && ((JSRoyaleEmitter)this.getEmitter()).isXMLish((IExpressionNode)lnode)) {
                    DynamicAccessNode dyn = (DynamicAccessNode)rnode;
                    ITypeDefinition type = dyn.getRightOperandNode().resolveType(this.getProject());
                    if (type.isInstanceOf("String", this.getProject()) || type.isInstanceOf("Object", this.getProject()) || type == this.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE)) {
                        if (node.getNodeID() == ASTNodeID.Op_AssignId) {
                            String field;
                            this.getWalker().walk(lnode);
                            IExpressionNode dynLeft = dyn.getLeftOperandNode();
                            IExpressionNode dynRight = dyn.getRightOperandNode();
                            if (dynLeft instanceof UnaryOperatorAtNode) {
                                this.write(".setAttribute(");
                                field = fjs.stringifyNode((IASNode)dyn.getRightOperandNode());
                            } else if (dynRight instanceof UnaryOperatorAtNode) {
                                this.write(".setAttribute(");
                                field = fjs.stringifyNode(dynRight.getChild(0));
                            } else {
                                this.write(".setChild(");
                                field = fjs.stringifyNode((IASNode)dynLeft);
                            }
                            this.write(field + ", ");
                            this.getWalker().walk((IASNode)node.getRightOperandNode());
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                            return;
                        }
                        if (node.getNodeID() == ASTNodeID.Op_AddAssignID) {
                            String field;
                            this.getWalker().walk(lnode);
                            IExpressionNode rightSide = dyn.getRightOperandNode();
                            if (rightSide instanceof UnaryOperatorAtNode) {
                                this.write(".setAttribute('");
                                field = fjs.stringifyNode(((UnaryOperatorAtNode)rightSide).getChild(0));
                                field = field.replace("\"", "");
                            } else {
                                this.write(".setChild('");
                                field = fjs.stringifyNode((IASNode)rightSide);
                                field = field.replace("\"", "");
                            }
                            this.write(field + "', ");
                            this.getWalker().walk((IASNode)node.getLeftOperandNode());
                            this.write(".plus(");
                            this.getWalker().walk((IASNode)node.getRightOperandNode());
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                            return;
                        }
                        if (node.getNodeID() == ASTNodeID.Op_AddID) {
                            this.getWalker().walk((IASNode)dyn);
                            this.write(".plus(");
                            this.getWalker().walk((IASNode)node.getRightOperandNode());
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                            return;
                        }
                    }
                } else if (((JSRoyaleEmitter)this.getEmitter()).isProxy(((MemberAccessExpressionNode)leftSide).getLeftOperandNode()) && leftDef == null) {
                    MemberAccessExpressionNode proxyNode = (MemberAccessExpressionNode)leftSide;
                    if (node.getNodeID() == ASTNodeID.Op_AssignId) {
                        this.getWalker().walk((IASNode)proxyNode.getLeftOperandNode());
                        IExpressionNode rightSide = proxyNode.getRightOperandNode();
                        this.write(".setProperty('");
                        this.getWalker().walk((IASNode)rightSide);
                        this.write("', ");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                    if (node.getNodeID() == ASTNodeID.Op_AddAssignID) {
                        IExpressionNode rightSide = proxyNode.getRightOperandNode();
                        this.getWalker().walk((IASNode)proxyNode.getLeftOperandNode());
                        this.write(".setProperty('");
                        this.getWalker().walk((IASNode)rightSide);
                        this.write("', ");
                        this.getWalker().walk((IASNode)proxyNode.getLeftOperandNode());
                        this.write(".getProperty(");
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.getWalker().walk((IASNode)rightSide);
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        this.write(" + ");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                } else if (((JSRoyaleEmitter)this.getEmitter()).isDateProperty((IExpressionNode)((MemberAccessExpressionNode)leftSide), true)) {
                    this.specialCaseDate(node, (MemberAccessExpressionNode)leftSide);
                    return;
                }
            } else if (leftSide.getNodeID() == ASTNodeID.IdentifierID) {
                if (leftDef != null && SemanticUtils.isXMLish((IDefinition)leftDef, (ICompilerProject)this.getWalker().getProject()) && node.getNodeID() == ASTNodeID.Op_AddAssignID) {
                    this.getWalker().walk((IASNode)leftSide);
                    this.write(" = ");
                    this.getWalker().walk((IASNode)leftSide);
                    this.write(".plus(");
                    this.getWalker().walk((IASNode)node.getRightOperandNode());
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                    return;
                }
            } else if (leftSide.getNodeID() == ASTNodeID.ArrayIndexExpressionID) {
                DynamicAccessNode dyn = (DynamicAccessNode)leftSide;
                IExpressionNode dynLeft = dyn.getLeftOperandNode();
                ITypeDefinition type = dyn.getRightOperandNode().resolveType(this.getProject());
                if (((JSRoyaleEmitter)this.getEmitter()).isXMLish(dynLeft)) {
                    if (node.getNodeID() == ASTNodeID.Op_AssignId) {
                        String field;
                        this.getWalker().walk((IASNode)dynLeft);
                        IExpressionNode rightSide = dyn.getRightOperandNode();
                        if (rightSide instanceof UnaryOperatorAtNode) {
                            this.write(".setAttribute(");
                            field = fjs.stringifyNode(rightSide.getChild(0));
                        } else {
                            this.write(".setChild(");
                            field = fjs.stringifyNode((IASNode)rightSide);
                        }
                        if (field.startsWith("\"") && field.endsWith("\"")) {
                            field = "'" + field.substring(1, field.length() - 1) + "'";
                        }
                        this.write(field + ", ");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                    if (node.getNodeID() == ASTNodeID.Op_AddAssignID) {
                        String field;
                        this.getWalker().walk((IASNode)dynLeft);
                        IExpressionNode rightSide = dyn.getRightOperandNode();
                        if (rightSide instanceof UnaryOperatorAtNode) {
                            this.write(".setAttribute('");
                            field = fjs.stringifyNode(((UnaryOperatorAtNode)rightSide).getChild(0));
                            field = field.replace("\"", "");
                        } else {
                            this.write(".setChild('");
                            field = fjs.stringifyNode((IASNode)rightSide);
                            field = field.replace("\"", "");
                        }
                        this.write(field + "', ");
                        this.getWalker().walk((IASNode)node.getLeftOperandNode());
                        this.write(".plus(");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                    if (node.getNodeID() == ASTNodeID.Op_AddID) {
                        this.getWalker().walk((IASNode)dyn);
                        this.write(".plus(");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        return;
                    }
                } else if (((JSRoyaleEmitter)this.getEmitter()).isProxy(dynLeft)) {
                    if (isAssignment) {
                        this.getWalker().walk((IASNode)dynLeft);
                        IExpressionNode rightSide = dyn.getRightOperandNode();
                        this.write(".setProperty(");
                        this.getWalker().walk((IASNode)rightSide);
                        this.write(", ");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                    } else {
                        this.getWalker().walk((IASNode)dynLeft);
                        IExpressionNode rightSide = dyn.getRightOperandNode();
                        this.write(".getProperty(");
                        this.getWalker().walk((IASNode)rightSide);
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                        this.write(ASEmitterTokens.SPACE);
                        this.writeToken(op);
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                    }
                    return;
                }
            }
            if (id == ASTNodeID.Op_EqualID || id == ASTNodeID.Op_NotEqualID) {
                if (leftDef != null && leftDef.getQualifiedName().equals("QName")) {
                    ITypeDefinition rightDef = node.getRightOperandNode().resolveType(this.getProject());
                    if (rightDef != null && rightDef.getQualifiedName().equals("QName")) {
                        if (id == ASTNodeID.Op_NotEqualID) {
                            this.write("!");
                        }
                        this.write("QName.equality(");
                        this.getWalker().walk((IASNode)node.getLeftOperandNode());
                        this.write(",");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        this.write(")");
                        return;
                    }
                } else {
                    if (leftDef != null && this.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.BOOLEAN).equals(leftDef) && SemanticUtils.isXMLish((IExpressionNode)node.getRightOperandNode(), (ICompilerProject)this.getProject())) {
                        boolean literalBool;
                        boolean bl = literalBool = node.getLeftOperandNode().getNodeID() == ASTNodeID.LiteralBooleanID;
                        if (literalBool) {
                            this.write("'");
                        } else {
                            this.write("('' + ");
                        }
                        this.getWalker().walk((IASNode)node.getLeftOperandNode());
                        if (literalBool) {
                            this.write("'");
                        } else {
                            this.write(")");
                        }
                        this.write(" " + node.getOperator().getOperatorText() + " ");
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        return;
                    }
                    if (((leftDef == null || this.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE).equals(leftDef)) && SemanticUtils.isXMLish((IExpressionNode)node.getLeftOperandNode(), (ICompilerProject)this.getProject()) || SemanticUtils.isXMLish((IDefinition)leftDef, (ICompilerProject)this.getProject())) && this.getProject().getBuiltinType(IASLanguageConstants.BuiltinType.BOOLEAN).equals(node.getRightOperandNode().resolveType(this.getProject()))) {
                        boolean literalBool = node.getRightOperandNode().getNodeID() == ASTNodeID.LiteralBooleanID;
                        this.getWalker().walk((IASNode)node.getLeftOperandNode());
                        this.write(" " + node.getOperator().getOperatorText() + " ");
                        if (literalBool) {
                            this.write("'");
                        } else {
                            this.write("('' + ");
                        }
                        this.getWalker().walk((IASNode)node.getRightOperandNode());
                        if (literalBool) {
                            this.write("'");
                        } else {
                            this.write(")");
                        }
                        return;
                    }
                }
            }
            this.super_emitBinaryOperator(node, isAssignment);
        }
    }

    private void super_emitBinaryOperator(IBinaryOperatorNode node, boolean isAssignment) {
        ASTNodeID id;
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_OPEN);
        }
        if ((id = node.getNodeID()) == ASTNodeID.Op_IsID) {
            this.write(ASEmitterTokens.IS);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.writeToken(ASEmitterTokens.COMMA);
            this.getWalker().walk((IASNode)node.getRightOperandNode());
            this.write(ASEmitterTokens.PAREN_CLOSE);
        } else if (id == ASTNodeID.Op_AsID) {
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.IS);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.writeToken(ASEmitterTokens.COMMA);
            this.getWalker().walk((IASNode)node.getRightOperandNode());
            this.writeToken(ASEmitterTokens.PAREN_CLOSE);
            this.writeToken(ASEmitterTokens.TERNARY);
            this.getWalker().walk((IASNode)node.getLeftOperandNode());
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.NULL);
            this.write(ASEmitterTokens.PAREN_CLOSE);
        } else {
            if (isAssignment && this.getProject() instanceof RoyaleJSProject && ((RoyaleJSProject)this.getProject()).config != null && ((RoyaleJSProject)this.getProject()).config.getJsVectorEmulationClass() == null && node.getLeftOperandNode() instanceof MemberAccessExpressionNode && ((MemberAccessExpressionNode)node.getLeftOperandNode()).getRightOperandNode() instanceof IdentifierNode && ((IdentifierNode)((MemberAccessExpressionNode)node.getLeftOperandNode()).getRightOperandNode()).getName().equals("length") && ((MemberAccessExpressionNode)node.getLeftOperandNode()).getLeftOperandNode().resolveType(this.getProject()) instanceof AppliedVectorDefinition) {
                this.getWalker().walk((IASNode)((MemberAccessExpressionNode)node.getLeftOperandNode()).getLeftOperandNode());
                this.write(ASEmitterTokens.SQUARE_OPEN);
                this.write(JSRoyaleEmitterTokens.LANGUAGE_QNAME.getToken());
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSRoyaleEmitterTokens.ROYALE_SYNTH_TAG_FIELD_NAME);
                this.write(ASEmitterTokens.SQUARE_CLOSE);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.getWalker().walk((IASNode)((MemberAccessExpressionNode)node.getLeftOperandNode()).getRightOperandNode());
            } else if (isAssignment && node.getLeftOperandNode() instanceof NamespaceAccessExpressionNode) {
                this.getWalker().walk(node.getLeftOperandNode().getChild(1));
            } else {
                this.getWalker().walk((IASNode)node.getLeftOperandNode());
            }
            this.startMapping((ISourceLocation)node, (ISourceLocation)node.getLeftOperandNode());
            boolean xmlAdd = false;
            if (id == ASTNodeID.Op_AddID && SemanticUtils.isXMLish((IExpressionNode)node.getLeftOperandNode(), (ICompilerProject)this.getProject()) && SemanticUtils.isXMLish((IExpressionNode)node.getRightOperandNode(), (ICompilerProject)this.getProject())) {
                xmlAdd = true;
            }
            if (id != ASTNodeID.Op_CommaID && !xmlAdd) {
                this.write(ASEmitterTokens.SPACE);
            }
            if (id == ASTNodeID.Op_LogicalAndAssignID || id == ASTNodeID.Op_LogicalOrAssignID) {
                IExpressionNode lnode = node.getLeftOperandNode();
                this.writeToken(ASEmitterTokens.EQUAL);
                this.endMapping((ISourceLocation)node);
                this.getWalker().walk((IASNode)lnode);
                this.startMapping((ISourceLocation)node, (ISourceLocation)node.getLeftOperandNode());
                this.write(ASEmitterTokens.SPACE);
                this.write(id == ASTNodeID.Op_LogicalAndAssignID ? ASEmitterTokens.LOGICAL_AND : ASEmitterTokens.LOGICAL_OR);
            } else if (xmlAdd) {
                this.write(".plus(");
            } else {
                this.write(node.getOperator().getOperatorText());
            }
            this.write(ASEmitterTokens.SPACE);
            this.endMapping((ISourceLocation)node);
            if (isAssignment) {
                this.getEmitter().emitAssignmentCoercion(node.getRightOperandNode(), (IDefinition)node.getLeftOperandNode().resolveType(this.getProject()));
            } else {
                this.getWalker().walk((IASNode)node.getRightOperandNode());
                if (node.getNodeID() == ASTNodeID.Op_InID && ((JSRoyaleEmitter)this.getEmitter()).isXMLish(node.getRightOperandNode())) {
                    this.write(".elementNames()");
                } else if (node.getNodeID() == ASTNodeID.Op_InID && ((JSRoyaleEmitter)this.getEmitter()).isProxy(node.getRightOperandNode())) {
                    this.write(".propertyNames()");
                }
            }
            if (xmlAdd) {
                this.write(")");
            }
        }
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }

    void specialCaseDate(IBinaryOperatorNode node, MemberAccessExpressionNode leftSide) {
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_OPEN);
        }
        MemberAccessExpressionNode dateNode = leftSide;
        IIdentifierNode rightSide = (IIdentifierNode)dateNode.getRightOperandNode();
        String op = node.getOperator().getOperatorText();
        boolean isAssignment = op.contains("=") && !op.contains("==") && !op.startsWith("<") && !op.startsWith(">") && !op.startsWith("!");
        this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
        String rightName = rightSide.getName();
        if (isAssignment) {
            DatePropertiesSetters prop = DatePropertiesSetters.valueOf(rightName.toUpperCase());
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(prop.getFunctionName());
            this.write(ASEmitterTokens.PAREN_OPEN);
            if (op.length() > 1) {
                DatePropertiesGetters propGetter = DatePropertiesGetters.valueOf(rightName.toUpperCase());
                this.getWalker().walk((IASNode)dateNode.getLeftOperandNode());
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(propGetter.getFunctionName());
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.write(ASEmitterTokens.SPACE);
                this.write(op.substring(0, 1));
                this.write(ASEmitterTokens.SPACE);
            }
            this.getWalker().walk((IASNode)node.getRightOperandNode());
            this.write(ASEmitterTokens.PAREN_CLOSE);
        } else {
            DatePropertiesGetters propGetter = DatePropertiesGetters.valueOf(rightName.toUpperCase());
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(propGetter.getFunctionName());
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SPACE);
            this.write(op);
            this.write(ASEmitterTokens.SPACE);
            this.getWalker().walk((IASNode)node.getRightOperandNode());
        }
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }

    public static enum DatePropertiesSetters {
        TIME("time", "setTime"),
        FULLYEAR("fullYear", "setFullYear"),
        MONTH("month", "setMonth"),
        DATE("date", "setDate"),
        DAY("day", "setDay"),
        FULLYEARUTC("fullYearUTC", "setUTCFullYear"),
        MONTHUTC("monthUTC", "setUTCMonth"),
        DATEUTC("dateUTC", "setUTCDate"),
        DAYUTC("day", "setUTCDay"),
        HOURS("hours", "setHours"),
        MINUTES("minutes", "setMinutes"),
        SECONDS("seconds", "setSeconds"),
        MILLISECONDS("milliseconds", "setMilliseconds"),
        HOURSUTC("hoursUTC", "setUTCHours"),
        MINUTESUTC("minutesUTC", "setUTCMinutes"),
        SECONDSUTC("secondsUTC", "setUTCSeconds"),
        MILLISECONDSUTC("millisecondsUTC", "setUTCMilliseconds");

        private String value;
        private String functionName;

        private DatePropertiesSetters(String value, String functionName) {
            this.value = value;
            this.functionName = functionName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum DatePropertiesGetters {
        TIME("time", "getTime"),
        FULLYEAR("fullYear", "getFullYear"),
        MONTH("month", "getMonth"),
        DATE("date", "getDate"),
        DAY("day", "getDay"),
        FULLYEARUTC("fullYearUTC", "getUTCFullYear"),
        MONTHUTC("monthUTC", "getUTCMonth"),
        DATEUTC("dateUTC", "getUTCDate"),
        DAYUTC("dayUTC", "getUTCDay"),
        HOURS("hours", "getHours"),
        MINUTES("minutes", "getMinutes"),
        SECONDS("seconds", "getSeconds"),
        MILLISECONDS("milliseconds", "getMilliseconds"),
        HOURSUTC("hoursUTC", "getUTCHours"),
        MINUTESUTC("minutesUTC", "getUTCMinutes"),
        SECONDSUTC("secondsUTC", "getUTCSeconds"),
        MILLISECONDSUTC("millisecondsUTC", "getUTCMilliseconds"),
        TIMEZONEOFFSET("timezoneOffset", "getTimezoneOffset");

        private String value;
        private String functionName;

        private DatePropertiesGetters(String value, String functionName) {
            this.value = value;
            this.functionName = functionName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String getValue() {
            return this.value;
        }
    }
}

