////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

package mx.globalization
{

/**
 *  The NationalDigitsType class enumerates constants that indicate digit sets 
 *  used by the NumberFormatter class.  The value of each constant represents 
 *  the Unicode value for the zero digit in the specified decimal digit set.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.1
 *  @playerversion AIR 2.0
 *  @productversion Royale 0.9.8
 */
public class NationalDigitsType
{
	/**
	 *  Represents the Unicode value for the zero digit of the Arabic-Indic digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const ARABIC_INDIC:uint = 0x0660;

	/**
	 *  Represents the Unicode value for the zero digit of the Balinese digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const BALINESE:uint = 0x1B50;

	/**
	 *  Represents the Unicode value for the zero digit of the Bengali digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const BENGALI:uint = 0x09E6;

	/**
	 *  Represents the Unicode value for the zero digit of the Cham digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const CHAM:uint = 0xAA50;

	/**
	 *  Represents the Unicode value for the zero digit of the Devanagari digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const DEVANAGARI:uint = 0x0966;

	/**
	 *  Represents the Unicode value for the zero digit of the Latin-1 (European) digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const EUROPEAN:uint = 0x0030;

	/**
	 *  Represents the Unicode value for the zero digit of the Extended Arabic-Indic digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const EXTENDED_ARABIC_INDIC:uint = 0x06F0;

	/**
	 *  Represents the Unicode value for the zero digit of the Fullwidth digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const FULL_WIDTH:uint = 0xFF10;

	/**
	 *  Represents the Unicode value for the zero digit of the Gujarati digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const GUJARATI:uint = 0x0AE6;

	/**
	 *  Represents the Unicode value for the zero digit of the Gurmukhi digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const GURMUKHI:uint = 0x0A66;

	/**
	 *  Represents the Unicode value for the zero digit of the Kannada digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const KANNADA:uint = 0x0CE6;

	/**
	 *  Represents the Unicode value for the zero digit of the Kayah Li digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const KAYAH_LI:uint = 0xA900;

	/**
	 *  Represents the Unicode value for the zero digit of the Khmer digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const KHMER:uint = 0x17E0;

	/**
	 *  Represents the Unicode value for the zero digit of the Lao digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const LAO:uint = 0x0ED0;

	/**
	 *  Represents the Unicode value for the zero digit of the Lepcha digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const LEPCHA:uint = 0x1C40;

	/**
	 *  Represents the Unicode value for the zero digit of the Limbu digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const LIMBU:uint = 0x1946;

	/**
	 *  Represents the Unicode value for the zero digit of the Malayalam digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const MALAYALAM:uint = 0x0D66;

	/**
	 *  Represents the Unicode value for the zero digit of the Mongolian digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const MONGOLIAN:uint = 0x1810;

	/**
	 *  Represents the Unicode value for the zero digit of the Myanmar digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const MYANMAR:uint = 0x1040;

	/**
	 *  Represents the Unicode value for the zero digit of the Myanmar Shan digit set
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const MYANMAR_SHAN:uint = 0x1090;

	/**
	 *  Represents the Unicode value for the zero digit of the New Tai Lue digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const NEW_TAI_LUE:uint = 0x19D0;

	/**
	 *  Represents the Unicode value for the zero digit of the Nko digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const NKO:uint = 0x07C0;

	/**
	 *  Represents the Unicode value for the zero digit of the Ol Chiki digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const OL_CHIKI:uint = 0x1C50;

	/**
	 *  Represents the Unicode value for the zero digit of the Oriya digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const ORIYA:uint = 0x0B66;

	/**
	 *  Represents the Unicode value for the zero digit of the Osmanya digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const OSMANYA:uint = 0x104A0;

	/**
	 *  Represents the Unicode value for the zero digit of the Saurashtra digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const SAURASHTRA:uint = 0xA8D0;

	/**
	 *  Represents the Unicode value for the zero digit of the Sundanese digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const SUNDANESE:uint = 0x1BB0;

	/**
	 *  Represents the Unicode value for the zero digit of the Tamil digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const TAMIL:uint = 0x0BE6;

	/**
	 *  Represents the Unicode value for the zero digit of the Telugu digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const TELUGU:uint = 0x0C66;

	/**
	 *  Represents the Unicode value for the zero digit of the Thai digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const THAI:uint = 0x0E50;

	/**
	 *  Represents the Unicode value for the zero digit of the Tibetan digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const TIBETAN:uint = 0x0F20;

	/**
	 *  Represents the Unicode value for the zero digit of the Vai digit set.
	 *
	 *  @langversion 3.0
	 *  @playerversion Flash 10.1
	 *  @playerversion AIR 2.0
	 *  @productversion Royale 0.9.8
	 */
	public static const VAI:uint = 0xA620;
}

}
