/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.scopes;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.scopes.IDefinitionStore;
import org.apache.royale.compiler.internal.scopes.SmallDefinitionStore2;
import org.apache.royale.compiler.internal.scopes.SmallDefinitionStoreBase;
import org.apache.royale.compiler.scopes.IDefinitionSet;

public final class SmallDefinitionStore1
extends SmallDefinitionStoreBase {
    IDefinitionSet definitionSet0;

    @Override
    public int getCapacity() {
        return 1;
    }

    @Override
    public IDefinitionStore createLargerStore() {
        return new SmallDefinitionStore2(this);
    }

    @Override
    public IDefinitionSet getDefinitionSetByName(String baseName) {
        assert (baseName != null) : "The baseName of a definition must be non-null";
        if (baseName.equals(SmallDefinitionStore1.getBaseName(this.definitionSet0))) {
            return this.definitionSet0;
        }
        return null;
    }

    @Override
    public void putDefinitionSetByName(String baseName, IDefinitionSet set) {
        if (baseName.equals(SmallDefinitionStore1.getBaseName(this.definitionSet0))) {
            this.definitionSet0 = set;
        }
    }

    @Override
    public Collection<String> getAllNames() {
        int n = this.getCapacity();
        ArrayList<String> list = new ArrayList<String>(n);
        SmallDefinitionStore1.addBaseNameToList(list, this.definitionSet0);
        return list;
    }

    @Override
    public Collection<IDefinitionSet> getAllDefinitionSets() {
        int n = this.getCapacity();
        ArrayList<IDefinitionSet> list = new ArrayList<IDefinitionSet>(n);
        SmallDefinitionStore1.addDefinitionSetToList(list, this.definitionSet0);
        return list;
    }

    @Override
    public Collection<IDefinition> getAllDefinitions() {
        int n = this.getCapacity();
        ArrayList<IDefinition> list = new ArrayList<IDefinition>(n);
        SmallDefinitionStore1.addDefinitionsToList(list, this.definitionSet0);
        return list;
    }

    @Override
    protected int findIndexForBaseName(String baseName) {
        assert (baseName != null) : "The baseName of a definition must be non-null";
        if (baseName.equals(SmallDefinitionStore1.getBaseName(this.definitionSet0))) {
            return 0;
        }
        return -1;
    }

    @Override
    protected int findAvailableIndex() {
        if (this.definitionSet0 == null) {
            return 0;
        }
        return -1;
    }

    @Override
    public IDefinitionSet getDefinitionSet(int i) {
        assert (i >= 0 && i < this.getCapacity()) : "The index must be within the capacity of the store";
        switch (i) {
            case 0: {
                return this.definitionSet0;
            }
        }
        return null;
    }

    @Override
    public void setDefinitionSet(int i, IDefinitionSet definitionSet) {
        assert (i >= 0 && i < this.getCapacity()) : "The index must be within the capacity of the store";
        switch (i) {
            case 0: {
                this.definitionSet0 = definitionSet;
            }
        }
    }
}

