/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.fxg.flex;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.common.Multiname;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.fxg.flex.FXGSymbolClass;
import org.apache.royale.compiler.fxg.swf.FXG2SWFTranscoder;
import org.apache.royale.compiler.internal.fxg.dom.CDATANode;
import org.apache.royale.compiler.internal.fxg.dom.GraphicContentNode;
import org.apache.royale.compiler.internal.fxg.dom.GraphicNode;
import org.apache.royale.compiler.internal.fxg.dom.GroupNode;
import org.apache.royale.compiler.internal.fxg.dom.IMaskableNode;
import org.apache.royale.compiler.internal.fxg.dom.IMaskingNode;
import org.apache.royale.compiler.internal.fxg.dom.ITextNode;
import org.apache.royale.compiler.internal.fxg.dom.RichTextNode;
import org.apache.royale.compiler.internal.fxg.dom.TextGraphicNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.BRNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.DivNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.ImgNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.LinkNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.ParagraphNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.SpanNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.TCYNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.TabNode;
import org.apache.royale.compiler.internal.fxg.dom.richtext.TextLayoutFormatNode;
import org.apache.royale.compiler.internal.fxg.dom.types.BlendMode;
import org.apache.royale.compiler.internal.fxg.dom.types.MaskType;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.problems.FXGDefinitionNotFoundProblem;
import org.apache.royale.compiler.problems.FXGUndefinedPropertyProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.swf.tags.DefineSpriteTag;
import org.apache.royale.swf.tags.ICharacterTag;
import org.apache.royale.swf.tags.ITag;
import org.apache.royale.swf.tags.PlaceObject3Tag;
import org.apache.royale.utils.StringUtils;

public class FlexFXG2SWFTranscoder
extends FXG2SWFTranscoder {
    private String packageName;
    private final ICompilerProject project;
    private final ITypeDefinition stringType;
    private final ITypeDefinition objectType;
    private final ITypeDefinition anyType;
    private final HashMap<String, Integer> nameCounter;
    private Map<String, ITypeDefinition> dependencies;
    public static String packageSpriteVisualElement = "spark.core.SpriteVisualElement";
    private static final String packageShaderFilter = "spark.filters.ShaderFilter";
    private static final String packageLuminosityMaskShader = "mx.graphics.shaderClasses.LuminosityMaskShader";
    private static final String packageIFlexModuleFactory = "mx.core.IFlexModuleFactory";
    private static final String packageFlashEvent = "flash.events.Event";
    private static final String packageBreakElement = "flashx.textLayout.elements.BreakElement";
    private static final String packageDivElement = "flashx.textLayout.elements.DivElement";
    private static final String packageLinkElement = "flashx.textLayout.elements.LinkElement";
    private static final String packageImgElement = "flashx.textLayout.elements.InlineGraphicElement";
    private static final String packageRichText = "spark.components.RichText";
    private static final String packageParagraphElement = "flashx.textLayout.elements.ParagraphElement";
    private static final String packageSpanElement = "flashx.textLayout.elements.SpanElement";
    private static final String packageTabElement = "flashx.textLayout.elements.TabElement";
    private static final String packageTCYElement = "flashx.textLayout.elements.TCYElement";
    private static final String packageTextLayoutFormat = "flashx.textLayout.formats.TextLayoutFormat";

    public FlexFXG2SWFTranscoder(ICompilerProject project) {
        this.project = project;
        this.stringType = project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING);
        this.objectType = project.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT);
        this.anyType = project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
        this.nameCounter = new HashMap();
        this.dependencies = new HashMap<String, ITypeDefinition>();
    }

    @Override
    public FXGSymbolClass transcode(IFXGNode node, String packageName, String className, Map<ITag, ITag> extraTags, Collection<ICompilerProblem> problems) {
        this.packageName = packageName;
        super.transcode(node, packageName, className, extraTags, problems);
        this.addDependency(packageSpriteVisualElement);
        StringBuilder buf = new StringBuilder(512);
        buf.append("package ").append(packageName).append("\n");
        buf.append("{\n\n");
        buf.append("import ").append(packageSpriteVisualElement).append(";\n\n");
        buf.append("public class ").append(className).append(" extends " + packageSpriteVisualElement + "\n");
        buf.append("{\n");
        buf.append("    public function ").append(className).append("()\n");
        buf.append("    {\n");
        buf.append("        super();\n");
        if (node instanceof GraphicNode) {
            GraphicNode graphicNode = (GraphicNode)node;
            if (!Double.isNaN(graphicNode.viewWidth)) {
                buf.append("        viewWidth = ").append(graphicNode.viewWidth).append(";\n");
            }
            if (!Double.isNaN(graphicNode.viewHeight)) {
                buf.append("        viewHeight = ").append(graphicNode.viewHeight).append(";\n");
            }
            if (graphicNode.getMaskType() == MaskType.ALPHA && graphicNode.mask != null) {
                int maskIndex = graphicNode.mask.getMaskIndex();
                buf.append("        this.cacheAsBitmap = true;\n");
                buf.append("        this.mask = this.getChildAt(").append(maskIndex).append(");\n");
            }
        }
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("}\n");
        this.graphicClass.setGeneratedSource(buf.toString());
        return this.graphicClass;
    }

    private void addDependency(String qname) {
        this.getDefinition(qname);
    }

    private ITypeDefinition getDefinition(String qname) {
        ITypeDefinition definition = this.dependencies.get(qname);
        if (definition == null) {
            ASProjectScope scope = (ASProjectScope)this.project.getScope();
            definition = (ITypeDefinition)scope.findDefinitionByName(Multiname.crackDottedQName(this.project, qname, true), true);
            if (definition == null) {
                this.problems.add(new FXGDefinitionNotFoundProblem(qname));
                return null;
            }
            this.dependencies.put(qname, definition);
        }
        return definition;
    }

    @Override
    public FXG2SWFTranscoder newInstance() {
        FlexFXG2SWFTranscoder graphics = new FlexFXG2SWFTranscoder(this.project);
        graphics.packageName = this.packageName;
        graphics.graphicClass = this.graphicClass;
        graphics.definitions = this.definitions;
        graphics.extraTags = this.extraTags;
        graphics.imageMap = this.imageMap;
        graphics.depthMap = this.depthMap;
        return graphics;
    }

    @Override
    protected PlaceObject3Tag mask(IMaskableNode node, DefineSpriteTag parentSprite) {
        IMaskingNode mask = node.getMask();
        PlaceObject3Tag po3 = super.mask(node, parentSprite);
        if (mask != null) {
            MaskType maskType = node.getMaskType();
            if (maskType != MaskType.CLIP) {
                int maskIndex = this.getSpriteDepth(parentSprite) - 1;
                mask.setMaskIndex(maskIndex);
            }
            if (maskType == MaskType.LUMINOSITY) {
                String className = this.createUniqueName(this.graphicClass.getClassName() + "_Mask");
                FXGSymbolClass symbolClass = new FXGSymbolClass();
                symbolClass.setPackageName(this.packageName);
                symbolClass.setClassName(className);
                this.graphicClass.addAdditionalSymbolClass(symbolClass);
                int mode = 0;
                if (node.getLuminosityClip()) {
                    mode += 2;
                }
                if (node.getLuminosityInvert()) {
                    ++mode;
                }
                this.addDependency(packageShaderFilter);
                this.addDependency(packageLuminosityMaskShader);
                StringBuilder buf = new StringBuilder(768);
                buf.append("package ").append(this.packageName).append("\n");
                buf.append("{\n\n");
                buf.append("import flash.display.Sprite;\n");
                buf.append("import ").append(packageShaderFilter).append(";\n");
                buf.append("import ").append(packageLuminosityMaskShader).append(";\n\n");
                buf.append("public class ").append(className).append(" extends Sprite\n");
                buf.append("{\n");
                buf.append("    public function ").append(className).append("()\n");
                buf.append("    {\n");
                buf.append("        super();\n");
                buf.append("        this.cacheAsBitmap = true;\n");
                buf.append("        var shader:LuminosityMaskShader = new LuminosityMaskShader();\n");
                buf.append("        shader.mode = ").append(mode).append(";\n");
                buf.append("        var filter:ShaderFilter = new ShaderFilter(shader);\n");
                buf.append("        this.filters = [filter.clone()];\n");
                buf.append("    }\n");
                buf.append("}\n");
                buf.append("}\n");
                symbolClass.setGeneratedSource(buf.toString());
                symbolClass.setSymbol(po3.getCharacter());
            }
        }
        return po3;
    }

    @Override
    protected PlaceObject3Tag graphicContentNode(GraphicContentNode node) {
        boolean hasMaskAndFilters = node.mask != null && node.filters != null;
        PlaceObject3Tag po3 = super.graphicContentNode(node);
        if (po3 != null && !(node instanceof ITextNode) && this.hasAdvancedGraphics(node)) {
            SymbolClassType symbolClassType = SymbolClassType.SHAPE;
            if (hasMaskAndFilters || node instanceof GroupNode) {
                symbolClassType = SymbolClassType.SPRITE;
            }
            this.advancedGraphics(node, po3.getCharacter(), symbolClassType);
        }
        return po3;
    }

    @Override
    protected PlaceObject3Tag group(GroupNode node) {
        PlaceObject3Tag po3 = super.group(node);
        if (po3 != null && this.hasAdvancedGraphics(node)) {
            this.advancedGraphics(node, po3.getCharacter(), SymbolClassType.SPRITE);
        }
        return po3;
    }

    private boolean hasAdvancedGraphics(IMaskableNode node) {
        if (node.getMask() != null && (node.getMaskType() == MaskType.ALPHA || node.getMaskType() == MaskType.LUMINOSITY)) {
            return true;
        }
        if (node instanceof GraphicContentNode) {
            GraphicContentNode graphicNode = (GraphicContentNode)node;
            if (graphicNode.blendMode.needsPixelBenderSupport()) {
                return true;
            }
        }
        return false;
    }

    private void advancedGraphics(GraphicContentNode node, ICharacterTag symbol, SymbolClassType symbolClassType) {
        IMaskingNode maskNode = node.getMask();
        String className = this.graphicClass.getClassName();
        if (maskNode != null) {
            className = className + "_Maskee";
        }
        className = this.createUniqueName(className);
        FXGSymbolClass symbolClass = new FXGSymbolClass();
        symbolClass.setPackageName(this.packageName);
        symbolClass.setClassName(className);
        this.graphicClass.addAdditionalSymbolClass(symbolClass);
        StringBuilder buf = new StringBuilder(512);
        buf.append("package ").append(this.packageName).append("\n");
        buf.append("{\n\n");
        String baseClassName = null;
        if (symbolClassType == SymbolClassType.SPRITE) {
            buf.append("import flash.display.Sprite;\n");
            baseClassName = "Sprite";
        } else {
            buf.append("import flash.display.Shape;\n");
            baseClassName = "Shape";
        }
        String blendModeClass = null;
        BlendMode blendmode = node.blendMode;
        if (blendmode != null && blendmode.needsPixelBenderSupport()) {
            blendModeClass = blendmode.getClassName();
            this.addDependency(blendModeClass);
            buf.append("import ").append(blendModeClass).append(";\n\n");
        }
        buf.append("public class ").append(className).append(" extends ").append(baseClassName).append("\n");
        buf.append("{\n");
        buf.append("    public function ").append(className).append("()\n");
        buf.append("    {\n");
        buf.append("        super();\n");
        buf.append("        this.cacheAsBitmap = true;\n");
        if (maskNode != null) {
            int maskIndex = maskNode.getMaskIndex();
            if (symbolClassType == SymbolClassType.SPRITE) {
                buf.append("        this.mask = this.getChildAt(").append(maskIndex).append(");\n");
            } else {
                buf.append("        this.mask = this.parent.getChildAt(").append(maskIndex).append(");\n");
            }
        }
        if (blendModeClass != null) {
            buf.append("        this.blendShader = new ").append(Multiname.getBaseNameForQName(blendModeClass)).append("();\n");
        }
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("}\n");
        symbolClass.setGeneratedSource(buf.toString());
        symbolClass.setSymbol(symbol);
    }

    @Override
    protected PlaceObject3Tag richtext(RichTextNode node) {
        return this.flexText(node);
    }

    @Override
    protected PlaceObject3Tag text(TextGraphicNode node) {
        return this.flexText(node);
    }

    private PlaceObject3Tag flexText(GraphicContentNode node) {
        if (node instanceof ITextNode) {
            IMaskingNode maskNode;
            ITextNode textNode = (ITextNode)((Object)node);
            String className = this.createUniqueName(this.graphicClass.getClassName() + "_Text");
            FXGSymbolClass spriteSymbolClass = new FXGSymbolClass();
            spriteSymbolClass.setPackageName(this.packageName);
            spriteSymbolClass.setClassName(className);
            this.graphicClass.addAdditionalSymbolClass(spriteSymbolClass);
            DefineSpriteTag textSprite = this.createDefineSpriteTag(className);
            PlaceObject3Tag po3 = this.PlaceObject3Tag(textSprite, node.createGraphicContext());
            this.spriteStack.push(textSprite);
            this.addDependency(packageFlashEvent);
            this.addDependency(packageTextLayoutFormat);
            this.addDependency(packageIFlexModuleFactory);
            this.addDependency(packageRichText);
            this.addDependency(packageSpriteVisualElement);
            StringBuilder buf = new StringBuilder(4096);
            buf.append("package ").append(this.packageName).append("\n");
            buf.append("{\n\n");
            buf.append("import flashx.textLayout.elements.*;\n");
            buf.append("import mx.core.mx_internal;\n");
            buf.append("import ").append(packageFlashEvent).append(";\n");
            buf.append("import ").append(packageTextLayoutFormat).append(";\n");
            buf.append("import ").append(packageIFlexModuleFactory).append(";\n");
            buf.append("import ").append(packageRichText).append(";\n");
            buf.append("import ").append(packageSpriteVisualElement).append(";\n");
            buf.append("use namespace mx_internal;\n\n");
            String blendModeClass = null;
            BlendMode blendmode = node.blendMode;
            if (blendmode != null && blendmode.needsPixelBenderSupport()) {
                blendModeClass = blendmode.getClassName();
                this.addDependency(blendModeClass);
                buf.append("import ").append(blendModeClass).append(";\n\n");
            }
            buf.append("public class ").append(className).append(" extends " + packageSpriteVisualElement + "\n");
            buf.append("{\n");
            buf.append("    public function ").append(className).append("()\n");
            buf.append("    {\n");
            buf.append("        super();\n");
            buf.append("        this.nestedSpriteVisualElement = true;\n");
            if (this.hasAdvancedGraphics(node)) {
                buf.append("        this.cacheAsBitmap = true;\n");
            }
            if ((maskNode = node.getMask()) != null && (node.getMaskType() == MaskType.ALPHA || node.getMaskType() == MaskType.LUMINOSITY)) {
                int maskIndex = maskNode.getMaskIndex();
                buf.append("        this.mask = this.parent.getChildAt(").append(maskIndex).append(");\n");
            }
            if (blendModeClass != null) {
                buf.append("        this.blendShader = new ").append(Multiname.getBaseNameForQName(blendModeClass)).append("();\n");
            }
            buf.append("        createText();\n");
            buf.append("    }\n");
            buf.append("\n");
            buf.append("    private var _richTextComponent:RichText;\n\n");
            buf.append("    private function createText():void\n");
            buf.append("    {\n");
            SourceContext textSource = this.generateRichText(textNode);
            if (textSource.functionBuffer != null) {
                buf.append(textSource.functionBuffer.toString());
            }
            buf.append("    }\n");
            if (textSource.classBuffer != null) {
                buf.append(textSource.classBuffer.toString());
            }
            buf.append(this.generateModuleFactoryOverride("_richTextComponent"));
            buf.append("}\n");
            buf.append("}\n");
            spriteSymbolClass.setGeneratedSource(buf.toString());
            spriteSymbolClass.setSymbol(textSprite);
            this.spriteStack.pop();
            return po3;
        }
        return null;
    }

    private String createUniqueName(String baseName) {
        String suffix;
        if (this.nameCounter.containsKey(baseName)) {
            int counterValue = this.nameCounter.get(baseName) + 1;
            this.nameCounter.put(baseName, counterValue);
            suffix = String.valueOf(counterValue);
        } else {
            suffix = "0";
            this.nameCounter.put(baseName, 0);
        }
        return baseName + '_' + suffix;
    }

    private SourceContext generateRichText(ITextNode textNode) {
        SourceContext srcContext = new SourceContext(1024, 0);
        StringBuilder buf = srcContext.functionBuffer;
        Variables varContext = new Variables();
        IClassDefinition definition = (IClassDefinition)this.getDefinition(packageRichText);
        if (definition != null) {
            varContext.setVar(definition, NodeType.RICHTEXT);
            String elementVar = varContext.elementVar;
            this.generateTextVariable(textNode, srcContext, varContext);
            buf.append("        _richTextComponent = ").append(elementVar).append(";\r\n");
            buf.append("        addChild(").append(elementVar).append(");\r\n");
            buf.append("        var addHandler:Function = function(event:Event):void\r\n");
            buf.append("        {\r\n");
            buf.append("            removeEventListener(Event.ADDED_TO_STAGE, addHandler);\r\n\r\n");
            buf.append("            // If we don't have a module factory by now then use the root\r\n");
            buf.append("            if (moduleFactory == null && root is IFlexModuleFactory)\r\n");
            buf.append("                moduleFactory = IFlexModuleFactory(root);\r\n");
            buf.append("        };\r\n");
            buf.append("        addEventListener(Event.ADDED_TO_STAGE, addHandler);\r\n");
        }
        return srcContext;
    }

    private String generateModuleFactoryOverride(String elementVar) {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("\r\n    /**\r\n");
        buf.append("     *  @private\r\n");
        buf.append("     *  Create a module factory override so we do not try to use a RichText's\r\n");
        buf.append("     *  styles until we have a module factory. The module factory will tell us\r\n");
        buf.append("     *  which style manager to use.\r\n");
        buf.append("     */\r\n");
        buf.append("    override public function set moduleFactory(factory:IFlexModuleFactory):void\r\n");
        buf.append("    {\r\n");
        buf.append("        ").append(elementVar).append(".regenerateStyleCache(true);\r\n");
        buf.append("        ").append(elementVar).append(".styleChanged(null);\r\n");
        buf.append("        ").append(elementVar).append(".stylesInitialized();\r\n");
        buf.append("        ").append(elementVar).append(".validateProperties();\r\n");
        buf.append("        ").append(elementVar).append(".validateSize();\r\n");
        buf.append("        ").append(elementVar).append(".setLayoutBoundsSize(NaN, NaN);\r\n");
        buf.append("        ").append(elementVar).append(".validateDisplayList();\r\n");
        buf.append("        invalidateSize();\r\n");
        buf.append("    }\r\n");
        return buf.toString();
    }

    private void generateTextVariable(ITextNode textNode, SourceContext srcContext, Variables varContext) {
        StringBuilder buf = srcContext.functionBuffer;
        Map<String, String> attributes = textNode.getTextAttributes();
        List<ITextNode> children = textNode.getTextChildren();
        String currentVar = varContext.elementVar;
        String contentVar = varContext.contentVar;
        String parentClass = varContext.elementClass;
        String parentChildrenVar = varContext.elementChildrenVar;
        IClassDefinition type = varContext.type;
        if (!varContext.varDeclared) {
            buf.append("        var ").append(currentVar).append(":").append(parentClass).append(" = new ").append(parentClass).append("();\r\n");
            if (contentVar != null) {
                buf.append("        var ").append(contentVar).append(":Array = [];\r\n");
            }
        } else {
            buf.append("        ").append(currentVar).append(" = new ").append(parentClass).append("();\r\n");
            if (contentVar != null) {
                buf.append("        ").append(contentVar).append(" = [];\r\n");
            }
        }
        this.generateAttributes(textNode, type, attributes, srcContext, currentVar);
        if (!(textNode instanceof RichTextNode)) {
            this.generateProperties(srcContext, textNode, currentVar, varContext);
        }
        if (children != null && children.size() > 0) {
            Iterator<ITextNode> iter = children.iterator();
            while (iter.hasNext()) {
                String elementVar = null;
                ITextNode child = iter.next();
                IClassDefinition definition = null;
                if (child instanceof RichTextNode) {
                    definition = (IClassDefinition)this.getDefinition(packageRichText);
                    if (definition == null) continue;
                    varContext.setVar(definition, NodeType.RICHTEXT);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof ParagraphNode) {
                    definition = (IClassDefinition)this.getDefinition(packageParagraphElement);
                    if (definition == null) continue;
                    varContext.setVar(definition, NodeType.PARAGRAPH);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof SpanNode) {
                    definition = (IClassDefinition)this.getDefinition(packageSpanElement);
                    if (definition == null) continue;
                    varContext.setVar(definition, NodeType.SPAN);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof DivNode) {
                    definition = (IClassDefinition)this.getDefinition(packageDivElement);
                    if (definition == null) continue;
                    varContext.setVar(definition, NodeType.DIV);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof CDATANode) {
                    String text = this.formatString(((CDATANode)child).content);
                    buf.append("        ").append(contentVar).append(".push(").append(text).append(");\r\n");
                    continue;
                }
                if (child instanceof BRNode) {
                    this.addDependency(packageBreakElement);
                    buf.append("        ").append(contentVar).append(".push(new BreakElement());\r\n");
                    continue;
                }
                if (child instanceof ImgNode) {
                    definition = (IClassDefinition)this.getDefinition(packageImgElement);
                    if (definition == null) continue;
                    varContext.setVar(definition, NodeType.IMG);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof LinkNode) {
                    definition = (IClassDefinition)this.getDefinition(packageLinkElement);
                    if (definition == null) continue;
                    varContext.setVar(definition, NodeType.LINK);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof TabNode) {
                    definition = (IClassDefinition)this.getDefinition(packageTabElement);
                    if (definition == null) continue;
                    varContext.setVar(definition, NodeType.TAB);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof TCYNode) {
                    definition = (IClassDefinition)this.getDefinition(packageTCYElement);
                    if (definition == null) continue;
                    varContext.setVar(definition, NodeType.TCY);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (!(child instanceof TextGraphicNode) || (definition = (IClassDefinition)this.getDefinition(packageRichText)) == null) continue;
                varContext.setVar(definition, NodeType.RICHTEXT);
                elementVar = varContext.elementVar;
                this.generateTextVariable(child, srcContext, varContext);
                buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
            }
        }
        if (parentChildrenVar != null && contentVar != null) {
            buf.append("        ").append(currentVar).append(".").append(parentChildrenVar).append(" = ").append(contentVar).append(";\r\n");
        }
        if (textNode instanceof RichTextNode) {
            this.generateProperties(srcContext, textNode, currentVar, varContext);
        }
    }

    private void generateProperties(SourceContext srcContext, ITextNode parentNode, String parentVar, Variables varContext) {
        Map<String, ITextNode> properties = parentNode.getTextProperties();
        if (properties != null) {
            StringBuilder buf = srcContext.functionBuffer;
            for (Map.Entry<String, ITextNode> entry : properties.entrySet()) {
                IClassDefinition definition;
                String propertyName = entry.getKey();
                ITextNode node = entry.getValue();
                if (!(node instanceof TextLayoutFormatNode) || (definition = (IClassDefinition)this.getDefinition(packageTextLayoutFormat)) == null) continue;
                varContext.setVar(definition, NodeType.TEXT_LAYOUT_FORMAT);
                this.generateTextVariable(node, srcContext, varContext);
                if (parentNode instanceof RichTextNode) {
                    buf.append("        ").append(parentVar).append(".textFlow.").append(propertyName).append(" = ").append(varContext.elementVar).append(";\r\n");
                    continue;
                }
                buf.append("        ").append(parentVar).append(".").append(propertyName).append(" = ").append(varContext.elementVar).append(";\r\n");
            }
        }
    }

    private void generateAttributes(ITextNode node, IClassDefinition type, Map<String, String> attributes, SourceContext srcContext, String variableName) {
        if (attributes != null) {
            StringBuilder buf = srcContext.functionBuffer;
            if (node instanceof ImgNode) {
                String imgSource = attributes.get("source");
                if ((imgSource = this.parseSource(imgSource)) != null) {
                    String resolvedPath;
                    File f = new File(imgSource);
                    if (!f.isAbsolute() && this.resourceResolver != null && (resolvedPath = this.resourceResolver.resolve(imgSource)) != null) {
                        imgSource = resolvedPath;
                    }
                    imgSource = imgSource.replace('\\', '/');
                    if (srcContext.classBuffer == null) {
                        srcContext.classBuffer = new StringBuilder(128);
                    }
                    StringBuilder classBuf = srcContext.classBuffer;
                    String imgVar = this.createUniqueName("img");
                    classBuf.append("\n");
                    classBuf.append("    [Embed(source=\"").append(imgSource).append("\")]\n");
                    classBuf.append("    private static var ").append(imgVar).append(":Class;\n");
                    buf.append("        ").append(variableName).append(".source = ").append(imgVar).append(";\n");
                    attributes.remove("source");
                }
            }
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attribName = entry.getKey();
                String attribValue = entry.getValue();
                String thisAttrib = null;
                IDefinition propertyDefinition = ((RoyaleProject)this.project).resolveProperty(type, attribName);
                if (propertyDefinition != null) {
                    ITypeDefinition propertyType = propertyDefinition.resolveType(this.project);
                    thisAttrib = propertyType.isInstanceOf(this.stringType, this.project) || propertyType == this.objectType || propertyType == this.anyType ? attribName + " = \"" + attribValue + "\"" : attribName + " = " + attribValue;
                } else if (((RoyaleProject)this.project).resolveStyle(type, attribName) != null) {
                    thisAttrib = "setStyle(\"" + attribName + "\", \"" + attribValue + "\")";
                } else {
                    this.problems.add(new FXGUndefinedPropertyProblem(attribName));
                    continue;
                }
                if (thisAttrib == null) continue;
                buf.append("        " + variableName + '.' + thisAttrib + ";\r\n");
            }
        }
    }

    private String formatString(String content) {
        if (content != null) {
            return StringUtils.formatString(content);
        }
        return content;
    }

    @Override
    public ITypeDefinition[] getDependencies() {
        return this.dependencies.values().toArray(new ITypeDefinition[0]);
    }

    private static class Variable {
        private int count;
        private boolean reusableVar;
        private String elementClass;
        private String elementVar;
        private String contentVar;
        private String elementChildrenVar;

        private Variable(String elementClass, String elementVar, String contentVar, String elementChildrenVar, boolean reusableVar) {
            this.elementClass = elementClass;
            this.elementVar = elementVar;
            this.contentVar = contentVar;
            this.elementChildrenVar = elementChildrenVar;
            this.reusableVar = reusableVar;
        }
    }

    private static class Variables {
        private Variable divVar;
        private Variable formatVar;
        private Variable imgVar;
        private Variable linkVar;
        private Variable paragraphVar;
        private Variable richTextVar;
        private Variable spanVar;
        private Variable tabVar;
        private Variable tcyVar;
        private Variable textLayoutFormatVar;
        private IClassDefinition type;
        private boolean varDeclared;
        private String elementClass;
        private String elementVar;
        private String contentVar;
        private String elementChildrenVar;

        private Variables() {
        }

        private void setVar(IClassDefinition type, NodeType nodeType) {
            this.type = type;
            Variable var = this.getVar(nodeType);
            if (var != null) {
                var.count++;
                if (!var.reusableVar) {
                    this.varDeclared = false;
                    this.elementVar = var.elementVar + var.count;
                    this.contentVar = var.contentVar + var.count;
                } else {
                    this.varDeclared = var.count > 1;
                    this.elementVar = var.elementVar;
                    this.contentVar = var.contentVar;
                }
                this.elementClass = var.elementClass;
                this.elementChildrenVar = var.elementChildrenVar;
            }
        }

        private Variable getVar(NodeType nodeType) {
            switch (nodeType) {
                case DIV: {
                    if (this.divVar == null) {
                        this.divVar = new Variable("DivElement", "divElement", "divContent", "mxmlChildren", false);
                    }
                    return this.divVar;
                }
                case FORMAT: {
                    if (this.formatVar == null) {
                        this.formatVar = new Variable("TextLayoutFormat", "formatElement", null, null, false);
                    }
                    return this.formatVar;
                }
                case IMG: {
                    if (this.imgVar == null) {
                        this.imgVar = new Variable("InlineGraphicElement", "imgElement", null, null, true);
                    }
                    return this.imgVar;
                }
                case LINK: {
                    if (this.linkVar == null) {
                        this.linkVar = new Variable("LinkElement", "linkElement", "linkContent", "mxmlChildren", true);
                    }
                    return this.linkVar;
                }
                case PARAGRAPH: {
                    if (this.paragraphVar == null) {
                        this.paragraphVar = new Variable("ParagraphElement", "paragraphElement", "paragraphContent", "mxmlChildren", true);
                    }
                    return this.paragraphVar;
                }
                case RICHTEXT: {
                    if (this.richTextVar == null) {
                        this.richTextVar = new Variable("RichText", "textElement", "textContent", "content", true);
                    }
                    return this.richTextVar;
                }
                case SPAN: {
                    if (this.spanVar == null) {
                        this.spanVar = new Variable("SpanElement", "spanElement", "spanContent", "mxmlChildren", true);
                    }
                    return this.spanVar;
                }
                case TAB: {
                    if (this.tabVar == null) {
                        this.tabVar = new Variable("TabElement", "tabElement", null, null, true);
                    }
                    return this.tabVar;
                }
                case TCY: {
                    if (this.tcyVar == null) {
                        this.tcyVar = new Variable("TCYElement", "tcyElement", "tcyContent", "mxmlChildren", true);
                    }
                    return this.tcyVar;
                }
                case TEXT_LAYOUT_FORMAT: {
                    if (this.textLayoutFormatVar == null) {
                        this.textLayoutFormatVar = new Variable("TextLayoutFormat", "tlfElement", null, null, true);
                    }
                    return this.textLayoutFormatVar;
                }
            }
            return null;
        }
    }

    private static class SourceContext {
        private StringBuilder functionBuffer;
        private StringBuilder classBuffer;

        private SourceContext(int functionSize, int classSize) {
            if (functionSize > 0) {
                this.functionBuffer = new StringBuilder(functionSize);
            }
            if (classSize > 0) {
                this.classBuffer = new StringBuilder(classSize);
            }
        }
    }

    private static enum NodeType {
        DIV,
        FORMAT,
        IMG,
        LINK,
        PARAGRAPH,
        RICHTEXT,
        SPAN,
        TAB,
        TCY,
        TEXT_LAYOUT_FORMAT;

    }

    private static enum SymbolClassType {
        SPRITE,
        SHAPE;

    }
}

