/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.header;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.action.Action;
import org.apache.rocketmq.common.action.RocketMQAction;
import org.apache.rocketmq.common.resource.ResourceType;
import org.apache.rocketmq.common.resource.RocketMQResource;
import org.apache.rocketmq.remoting.annotation.CFNotNull;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.rpc.TopicRequestHeader;

@RocketMQAction(value=208, action={Action.GET})
public class GetConsumeStatsRequestHeader
extends TopicRequestHeader {
    private static final String TOPIC_NAME_SEPARATOR = ";";
    @CFNotNull
    @RocketMQResource(value=ResourceType.GROUP)
    private String consumerGroup;
    @RocketMQResource(value=ResourceType.TOPIC)
    private String topic;
    @RocketMQResource(value=ResourceType.TOPIC, splitter=";")
    private String topicList;

    @Override
    public void checkFields() throws RemotingCommandException {
    }

    public List<String> fetchTopicList() {
        if (StringUtils.isBlank((CharSequence)this.topicList)) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split((String)this.topicList, (String)TOPIC_NAME_SEPARATOR));
    }

    public void updateTopicList(List<String> topicList) {
        if (topicList == null || topicList.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        topicList.forEach(topic -> sb.append((String)topic).append(TOPIC_NAME_SEPARATOR));
        this.setTopicList(sb.toString());
    }

    public String getTopicList() {
        return this.topicList;
    }

    public void setTopicList(String topicList) {
        this.topicList = topicList;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("consumerGroup", (Object)this.consumerGroup).add("topic", (Object)this.topic).toString();
    }
}

