/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.openmeetings.cli.CleanupUnit;
import org.apache.openmeetings.util.OmFileHelper;

public class CleanupEntityUnit
extends CleanupUnit {
    private static final long serialVersionUID = 1L;
    private final List<File> invalid;
    private final List<File> deleted;
    private long sizeInvalid = 0L;
    private long sizeDeleted = 0L;
    protected final int missing;

    public CleanupEntityUnit() {
        this.invalid = new ArrayList<File>();
        this.deleted = new ArrayList<File>();
        this.missing = 0;
    }

    public CleanupEntityUnit(File parent, List<File> invalid, List<File> deleted, int missing) {
        super(parent);
        this.invalid = invalid;
        this.deleted = deleted;
        this.missing = missing;
        for (File i : invalid) {
            this.sizeInvalid += OmFileHelper.getSize((File)i);
        }
        for (File i : deleted) {
            this.sizeDeleted += OmFileHelper.getSize((File)i);
        }
    }

    @Override
    public void cleanup() throws IOException {
        for (File i : this.invalid) {
            FileUtils.deleteQuietly((File)i);
        }
        for (File i : this.deleted) {
            FileUtils.deleteQuietly((File)i);
        }
    }

    public long getSizeInvalid() {
        return this.sizeInvalid;
    }

    public String getHumanInvalid() {
        return OmFileHelper.getHumanSize((long)this.sizeInvalid);
    }

    public long getSizeDeleted() {
        return this.sizeDeleted;
    }

    public String getHumanDeleted() {
        return OmFileHelper.getHumanSize((long)this.sizeDeleted);
    }

    public int getMissing() {
        return this.missing;
    }
}

