/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.util;

import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.GroupUserDao;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.FileSystemResource;
import org.apache.wicket.resource.FileSystemResourceReference;
import org.apache.wicket.util.string.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupLogoResourceReference
extends FileSystemResourceReference {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(GroupLogoResourceReference.class);
    @Inject
    private GroupUserDao groupUserDao;
    @Inject
    private RoomDao roomDao;

    public GroupLogoResourceReference() {
        super(GroupLogoResourceReference.class, "grouplogo");
        Injector.get().inject((Object)this);
    }

    public IResource getResource() {
        return new FileSystemResource(){
            private static final long serialVersionUID = 1L;

            protected String getMimeType() throws IOException {
                return "image/png";
            }

            protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attrs) {
                Long id = null;
                boolean allowed = false;
                WebSession ws = WebSession.get();
                if (ws.isSignedIn()) {
                    PageParameters params = attrs.getParameters();
                    StringValue inId = params.get("id");
                    try {
                        id = inId.toOptionalLong();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    boolean bl = allowed = id == null || AuthLevelUtil.hasAdminLevel(WebSession.getRights()) || null != GroupLogoResourceReference.this.groupUserDao.getByGroupAndUser(id, WebSession.getUserId());
                    if (!allowed && ws.getInvitation() != null) {
                        Room r;
                        Room room = r = ws.getInvitation().getRoom() == null ? null : GroupLogoResourceReference.this.roomDao.get(ws.getInvitation().getRoom().getId());
                        if (r != null && r.getGroups() != null) {
                            for (RoomGroup rg : r.getGroups()) {
                                if (!rg.getGroup().getId().equals(id)) continue;
                                allowed = true;
                                break;
                            }
                        }
                    }
                }
                if (allowed) {
                    return this.createResourceResponse(attrs, OmFileHelper.getGroupLogo(id, (boolean)true).toPath());
                }
                log.debug("Not authorized");
                AbstractResource.ResourceResponse rr = new AbstractResource.ResourceResponse();
                rr.setError(Integer.valueOf(403));
                return rr;
            }
        };
    }

    public static String getUrl(RequestCycle rc, Long groupId) {
        PageParameters pp = new PageParameters();
        if (groupId != null) {
            pp.add("id", (Object)groupId);
        }
        File img = OmFileHelper.getGroupLogo((Long)groupId, (boolean)true);
        return rc.urlFor((ResourceReference)new GroupLogoResourceReference(), pp.add("anticache", (Object)img.lastModified())).toString();
    }
}

