/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.pages.auth;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.spinner.SpinnerAjaxButton;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.web.app.OtpManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.pages.auth.SignInDialog;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;

public class OtpDialog
extends Modal<User> {
    private static final long serialVersionUID = 1L;
    private static final String TYPE_OTP = "type-otp";
    private static final String TYPE_FALLBACK = "type-fallback";
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private final OtpForm form = new OtpForm("form");
    private final RadioGroup<String> radioGroup = new RadioGroup("type", (IModel)Model.of((Serializable)((Object)"type-otp")));
    @Inject
    private OtpManager otpManager;
    @Inject
    private UserDao userDao;

    public OtpDialog(String id, IModel<User> model) {
        super(id, model);
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("otp.label"));
        this.setUseCloseHandler(true);
        this.addButton((Component)new SpinnerAjaxButton("button", (IModel)new ResourceModel("54"), (Form)this.form, Buttons.Type.Outline_Primary));
        this.addButton((Component)OmModalCloseButton.of());
        this.add(new Component[]{this.form});
        super.onInitialize();
    }

    public Modal<User> show(IPartialPageRequestHandler handler) {
        this.form.reset(handler);
        return super.show(handler);
    }

    private SignInDialog getSignin() {
        return (SignInDialog)this.getPage().get("signin");
    }

    public void onClose(IPartialPageRequestHandler handler) {
        this.getSignin().show(handler);
    }

    private class OtpForm
    extends Form<String> {
        private static final long serialVersionUID = 1L;
        private final WebMarkupContainer otpBlock;
        private final WebMarkupContainer fallbackBlock;
        private final RequiredTextField<String> otpField;
        private final RequiredTextField<String> fallbackField;

        public OtpForm(String id) {
            super(id);
            this.otpBlock = new WebMarkupContainer("otp-block");
            this.fallbackBlock = new WebMarkupContainer("fallback-block");
            this.otpField = new RequiredTextField<String>("otp", (IModel)Model.of((Serializable)((Object)""))){
                private static final long serialVersionUID = 1L;

                protected String[] getInputTypes() {
                    return new String[]{"number"};
                }
            };
            this.fallbackField = new RequiredTextField("fallback", (IModel)Model.of((Serializable)((Object)"")));
        }

        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{OtpDialog.this.feedback.setOutputMarkupId(true)});
            this.add(new Component[]{this.otpBlock.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
            this.otpBlock.add(new Component[]{this.otpField.setLabel((IModel)new ResourceModel("otp.label"))});
            this.add(new Component[]{this.fallbackBlock.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
            this.fallbackBlock.add(new Component[]{this.fallbackField.setLabel((IModel)new ResourceModel("otp.fallback.label"))});
            this.add(new Component[]{OtpDialog.this.radioGroup.add(new Component[]{new Radio(OtpDialog.TYPE_OTP, (IModel)Model.of((Serializable)((Object)OtpDialog.TYPE_OTP)))}).add(new Component[]{new Radio(OtpDialog.TYPE_FALLBACK, (IModel)Model.of((Serializable)((Object)OtpDialog.TYPE_FALLBACK)))}).setOutputMarkupId(true)});
            OtpDialog.this.radioGroup.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    OtpForm.this.updateForm((IPartialPageRequestHandler)target);
                }
            }});
            this.add(new Component[]{new AjaxButton("submit"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                    OtpForm.this.onSubmit(target);
                }

                protected void onError(AjaxRequestTarget target) {
                    OtpForm.this.onError(target);
                }
            }});
        }

        protected void onError() {
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(this::onError);
        }

        private void onError(AjaxRequestTarget target) {
            SignInDialog.penalty();
            target.add(new Component[]{OtpDialog.this.feedback});
        }

        protected void onSubmit() {
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(this::onSubmit);
        }

        protected void onValidate() {
            User u = (User)OtpDialog.this.getModelObject();
            String otp = (String)this.otpField.getConvertedInput();
            try {
                Integer.valueOf(otp);
                if (!OtpDialog.this.otpManager.verify(u.getOtpSecret(), otp)) {
                    this.error((Serializable)((Object)this.getString("otp.invalid")));
                }
            }
            catch (NumberFormatException e) {
                String fallback = (String)this.fallbackField.getConvertedInput();
                String[] codes = Optional.of(u.getOtpRecoveryCodes()).map(str -> str.split(" ")).orElse(new String[0]);
                if (Stream.of(codes).anyMatch(str -> str.equalsIgnoreCase(fallback))) {
                    u.setOtpRecoveryCodes(Stream.of(codes).filter(str -> !Strings.isEmpty((String)str)).filter(str -> !str.equalsIgnoreCase(fallback)).collect(Collectors.joining(" ")));
                    OtpDialog.this.userDao.update(u, u.getId());
                    return;
                }
                this.error((Serializable)((Object)this.getString("otp.fallback.invalid")));
            }
        }

        private void onSubmit(AjaxRequestTarget target) {
            User u = (User)OtpDialog.this.getModelObject();
            WebSession ws = WebSession.get();
            ws.signIn(u);
            OtpDialog.this.getSignin().finalStep(true, User.Type.USER, target);
        }

        private void updateForm(IPartialPageRequestHandler handler) {
            boolean isOtp = OtpDialog.TYPE_OTP.equals(OtpDialog.this.radioGroup.getModelObject());
            this.otpBlock.setVisible(isOtp);
            this.fallbackBlock.setVisible(!isOtp);
            handler.add(new Component[]{this.otpBlock, this.fallbackBlock});
        }

        private void reset(IPartialPageRequestHandler handler) {
            OtpDialog.this.radioGroup.setModelObject((Object)OtpDialog.TYPE_OTP);
            this.otpField.setModelObject((Object)"");
            this.fallbackField.setModelObject((Object)"");
            handler.add(new Component[]{OtpDialog.this.radioGroup});
            this.updateForm(handler);
        }
    }
}

