/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.labels;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Map;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.web.admin.labels.LangPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public class AddLanguageDialog
extends Modal<String> {
    private static final long serialVersionUID = 1L;
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private final Form<Void> form = new Form("addLangForm");
    private final RequiredTextField<String> iso = new RequiredTextField("iso", (IModel)Model.of((Serializable)((Object)"")));
    private final LangPanel langPanel;

    public AddLanguageDialog(String id, LangPanel langPanel) {
        super(id);
        this.langPanel = langPanel;
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("362"));
        this.addButton((Component)new BootstrapAjaxButton("button", (IModel)new ResourceModel("366"), this.form, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                try {
                    LabelDao.add((Locale)Locale.forLanguageTag((String)AddLanguageDialog.this.iso.getModelObject()));
                    AddLanguageDialog.this.langPanel.getLangForm().updateLanguages(target);
                    AddLanguageDialog.this.close((IPartialPageRequestHandler)target);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)("Failed to add, " + e.getMessage())));
                    target.add(new Component[]{AddLanguageDialog.this.feedback});
                }
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{AddLanguageDialog.this.feedback});
            }
        });
        this.add(new Component[]{this.form.add(new Component[]{this.feedback.setOutputMarkupId(true), this.iso.setOutputMarkupId(true)})});
        this.iso.add((IValidator)new IValidator<String>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<String> s) {
                try {
                    new Locale.Builder().setLanguageTag((String)s.getValue()).build();
                }
                catch (IllformedLocaleException e) {
                    s.error((IValidationError)new ValidationError("Invalid code, please specify valid ISO code"));
                    return;
                }
                Locale l = Locale.forLanguageTag((String)s.getValue());
                for (Map.Entry e : LabelDao.getLanguages()) {
                    if (!((Locale)e.getValue()).equals(l)) continue;
                    s.error((IValidationError)new ValidationError("This code already added"));
                    break;
                }
            }
        });
        super.onInitialize();
    }

    public Modal<String> show(IPartialPageRequestHandler handler) {
        this.iso.setModelObject((Object)"");
        handler.add(new Component[]{this.iso});
        return super.show(handler);
    }
}

