/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import org.asteriskjava.pbx.asterisk.wrap.events.ChannelState;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public enum PeerState {
    DOWN(1, "Down", "OnHook", false),
    UP(2, "Up", "OnPhone", true),
    UNKNOWN(0, "Unknown", "Unknown", false),
    NOTSET(0, "Not Set", "", false),
    UNMONITORED(0, "Unmonitored", "Unmonitored", true),
    DND(3, "DND", "DND", true),
    RINGING(4, "Ringing", "Ringing", true),
    OFF_LINE(1, "Off line", "Offline", true),
    UNREGISTERED(0, "Unregistered", "Unregistered", true),
    REGISTERED(0, "Registered", "Registered", false),
    BUSY(2, "Busy", "Busy", true),
    RING(4, "Ring", "Dialing", true),
    EXTERNAL(0, "External", "External", false);

    private static final Log logger;
    final String _asteriskStateName;
    final String label;
    private boolean _visible;
    private int _priority;

    public static PeerState valueByName(String value) {
        PeerState status = NOTSET;
        for (PeerState aState : PeerState.values()) {
            if (aState.getAsteriskStateName().compareToIgnoreCase(value) != 0) continue;
            status = aState;
            break;
        }
        return status;
    }

    private String getAsteriskStateName() {
        return this._asteriskStateName;
    }

    public static PeerState valueByChannelState(ChannelState state) {
        PeerState status = NOTSET;
        for (PeerState aState : PeerState.values()) {
            if (aState.getAsteriskStateName().compareToIgnoreCase(state.name()) != 0) continue;
            status = aState;
            break;
        }
        if (status == NOTSET) {
            logger.warn("Unknown channelState: " + (Object)((Object)state) + " recieved", new Throwable("Unknown channelState"));
        }
        return status;
    }

    private PeerState(int priority, String asteriskStateName, String label, boolean visible) {
        this._asteriskStateName = asteriskStateName;
        this.label = label;
        this._visible = visible;
        this._priority = priority;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.label;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public int getPriority() {
        return this._priority;
    }

    static {
        logger = LogFactory.getLog(PeerState.class);
    }
}

