/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.lock.LockableSet;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.BridgeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.LinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.UnlinkEvent;
import org.asteriskjava.pbx.internal.core.CoherentEventFactory;
import org.asteriskjava.pbx.internal.core.FilteredManagerListener;
import org.asteriskjava.pbx.internal.core.FilteredManagerListenerWrapper;
import org.asteriskjava.pbx.internal.core.ListenerManager;
import org.asteriskjava.pbx.internal.eventQueue.EventLifeMonitor;
import org.asteriskjava.pbx.util.LogTime;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class CoherentManagerEventQueue
implements ManagerEventListener,
Runnable {
    private static final Log logger = LogFactory.getLog(CoherentManagerEventQueue.class);
    private final ListenerManager listeners = new ListenerManager();
    private volatile boolean _stop = false;
    private static final int QUEUE_SIZE = 1000;
    private final BlockingQueue<EventLifeMonitor<ManagerEvent>> _eventQueue = new LinkedBlockingQueue<EventLifeMonitor<ManagerEvent>>(1000);
    long suppressQueueSizeErrorUntil = 0L;
    private LockableSet<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> globalEvents = new LockableSet(new HashSet());
    private final ExecutorService executors = Executors.newCachedThreadPool();

    public CoherentManagerEventQueue(String name, ManagerConnection connection) {
        connection.addEventListener(this);
        Thread _th = new Thread(this);
        _th.setName("EventQueue: " + name);
        _th.setDaemon(true);
        _th.start();
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
        boolean wanted = false;
        try (Locker.LockCloser closer = this.globalEvents.withLock();){
            Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> shadowEvent = CoherentEventFactory.getShadowEvent(event);
            if (this.globalEvents.contains(shadowEvent)) {
                wanted = true;
            }
        }
        if (wanted) {
            this._eventQueue.add(new EventLifeMonitor<ManagerEvent>(event));
            if (this._eventQueue.remainingCapacity() < 100 && this.suppressQueueSizeErrorUntil < System.currentTimeMillis()) {
                this.suppressQueueSizeErrorUntil = System.currentTimeMillis() + 1000L;
                logger.error("EventQueue more than 90% full");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this._stop) {
                try {
                    EventLifeMonitor<ManagerEvent> elm = this._eventQueue.poll(2L, TimeUnit.SECONDS);
                    if (elm == null) continue;
                    if (elm.getEvent().getClass() == PoisonQueueEvent.class) {
                        logger.warn("Got Poison event");
                        return;
                    }
                    org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent iEvent = CoherentEventFactory.build(elm.getEvent());
                    if (iEvent == null) continue;
                    this.dispatchEvent(iEvent);
                    elm.assessAge();
                }
                catch (Exception e) {
                    if (this._stop) continue;
                    logger.error(e, e);
                }
            }
            return;
        }
        finally {
            logger.warn("Shutting down!");
        }
    }

    public void stop() {
        this._stop = true;
        try {
            this._eventQueue.put(new EventLifeMonitor<PoisonQueueEvent>(new PoisonQueueEvent()));
        }
        catch (InterruptedException e) {
            logger.error(e, e);
        }
    }

    public void dispatchEvent(org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent event) {
        List<FilteredManagerListenerWrapper> listenerCopy;
        if (logger.isDebugEnabled()) {
            logger.debug("dispatch=" + event.toString());
        }
        try (Locker.LockCloser closer = this.listeners.withLock();){
            listenerCopy = this.listeners.getCopyAsList();
        }
        try {
            LogTime totalTime = new LogTime();
            CountDownLatch latch = new CountDownLatch(listenerCopy.size());
            for (FilteredManagerListenerWrapper filter : listenerCopy) {
                if (filter.requiredEvents.contains(event.getClass())) {
                    this.dispatchEventOnThread(event, filter, latch);
                    continue;
                }
                latch.countDown();
            }
            if (!latch.await(2L, TimeUnit.SECONDS)) {
                logger.error("Timeout waiting for event to be processed " + event);
            }
            if (totalTime.timeTaken() > 100L) {
                logger.warn("Too long to process event " + event + " time taken: " + totalTime.timeTaken());
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    private void dispatchEventOnThread(final org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent event, final FilteredManagerListenerWrapper filter, final CountDownLatch latch) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    LogTime time = new LogTime();
                    filter._listener.onManagerEvent(event);
                    if (time.timeTaken() > 500L) {
                        logger.warn("ManagerListener :" + filter._listener.getName() + " is taken too long to process event " + event + " time taken: " + time.timeTaken());
                    }
                }
                catch (Exception e) {
                    logger.error(e, e);
                }
                finally {
                    latch.countDown();
                }
            }
        };
        this.executors.execute(runner);
    }

    public void addListener(FilteredManagerListener<org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> listener) {
        try (Locker.LockCloser closer = this.listeners.withLock();){
            this.listeners.addListener(listener);
            try (Locker.LockCloser closer2 = this.globalEvents.withLock();){
                Collection<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> expandEvents = this.expandEvents(listener.requiredEvents());
                this.globalEvents.addAll(expandEvents);
            }
        }
        logger.debug("listener  added " + listener);
    }

    Collection<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> expandEvents(Collection<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> events) {
        HashSet<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> requiredEvents = new HashSet<Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>>();
        for (Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> event : events) {
            requiredEvents.add(event);
            if (!event.equals(BridgeEvent.class)) continue;
            requiredEvents.add(UnlinkEvent.class);
            requiredEvents.add(LinkEvent.class);
        }
        return requiredEvents;
    }

    public void removeListener(FilteredManagerListener<org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> melf) {
        if (melf != null) {
            try (Locker.LockCloser closer = this.listeners.withLock();){
                this.listeners.removeListener(melf);
                try (Locker.LockCloser closer2 = this.globalEvents.withLock();){
                    this.globalEvents.clear();
                    Iterator<FilteredManagerListenerWrapper> itr = this.listeners.iterator();
                    while (itr.hasNext()) {
                        FilteredManagerListenerWrapper readdContainer = itr.next();
                        this.globalEvents.addAll(this.expandEvents(readdContainer._listener.requiredEvents()));
                    }
                }
            }
        }
    }

    public void transferListeners(CoherentManagerEventQueue eventQueue) {
        try (Locker.LockCloser closer = this.listeners.withLock();
             Locker.LockCloser closer2 = eventQueue.listeners.withLock();){
            Iterator<FilteredManagerListenerWrapper> itr = eventQueue.listeners.iterator();
            while (itr.hasNext()) {
                FilteredManagerListenerWrapper listener = itr.next();
                this.addListener(listener._listener);
            }
            eventQueue.listeners.clear();
        }
    }

    class PoisonQueueEvent
    extends ManagerEvent {
        private static final long serialVersionUID = 1L;

        public PoisonQueueEvent() {
            super("PoisonQueueEvent");
        }
    }
}

