/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.methods;

import com.github.caldav4j.model.request.CalDAVReportRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import org.apache.http.HttpResponse;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.client.methods.XmlEntity;
import org.apache.jackrabbit.webdav.header.DepthHeader;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCalDAVReportMethod
extends BaseDavRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpCalDAVReportMethod.class);
    private CalendarBuilder calendarBuilder = null;

    public HttpCalDAVReportMethod(URI uri, CalDAVReportRequest reportRequest, int depth) throws IOException {
        super(uri);
        this.processReportRequest(reportRequest);
        this.setDepth(depth);
    }

    public HttpCalDAVReportMethod(URI uri, CalDAVReportRequest reportRequest) throws IOException {
        this(uri, reportRequest, 1);
    }

    public HttpCalDAVReportMethod(String uri, CalDAVReportRequest reportRequest, int depth) throws IOException {
        this(URI.create(uri), reportRequest, depth);
    }

    public HttpCalDAVReportMethod(String uri, CalDAVReportRequest reportRequest) throws IOException {
        this(uri, reportRequest, 1);
    }

    public String getMethod() {
        return "REPORT";
    }

    private void processReportRequest(CalDAVReportRequest reportRequest) throws IOException {
        this.setEntity(XmlEntity.create((XmlSerializable)reportRequest));
    }

    public void setDepth(int depth) {
        DepthHeader dh = new DepthHeader(depth);
        this.setHeader(dh.getHeaderName(), dh.getHeaderValue());
    }

    public boolean succeeded(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        return statusCode == 200 || statusCode == 207;
    }

    public CalendarBuilder getCalendarBuilder() {
        return this.calendarBuilder;
    }

    public void setCalendarBuilder(CalendarBuilder calendarBuilder) {
        this.calendarBuilder = calendarBuilder;
    }

    public Calendar getResponseBodyAsCalendar(HttpResponse response) throws IOException {
        Calendar calendarResponse = null;
        if (this.succeeded(response)) {
            try (InputStream in = response.getEntity().getContent();){
                calendarResponse = this.calendarBuilder.build(in);
            }
            catch (ParserException e) {
                throw new IOException("Error parsing calendar from response", e);
            }
        }
        return calendarResponse;
    }

    public DavProperty getDavProperty(HttpResponse response, String urlPath, DavPropertyName property) throws DavException {
        MultiStatusResponse[] responses = this.getResponseBodyAsMultiStatus(response).getResponses();
        if (responses != null && this.succeeded(response)) {
            for (MultiStatusResponse r : responses) {
                if (!r.getHref().equals(urlPath)) continue;
                DavPropertySet props = r.getProperties(200);
                return props.get(property);
            }
        }
        return null;
    }

    public Collection<DavProperty> getDavProperties(HttpResponse response, DavPropertyName property) throws DavException {
        ArrayList<DavProperty> set = new ArrayList<DavProperty>();
        MultiStatusResponse[] responses = this.getResponseBodyAsMultiStatus(response).getResponses();
        if (responses != null && this.succeeded(response)) {
            for (MultiStatusResponse r : responses) {
                DavPropertySet props = r.getProperties(200);
                if (props.isEmpty()) continue;
                set.add(props.get(property));
            }
        }
        return set;
    }

    public MultiStatusResponse getResponseBodyAsMultiStatusResponse(HttpResponse httpResponse, String uri) throws DavException {
        MultiStatusResponse[] responses;
        for (MultiStatusResponse response : responses = this.getResponseBodyAsMultiStatus(httpResponse).getResponses()) {
            if (!response.getHref().equals(uri)) continue;
            return response;
        }
        return null;
    }
}

