/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.StoreLatencyPlugin;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.ringbuffer.RingbufferStore;
import com.hazelcast.ringbuffer.RingbufferStoreFactory;
import com.hazelcast.ringbuffer.impl.LatencyTrackingRingbufferStore;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Arrays;

public final class RingbufferStoreWrapper
implements RingbufferStore<Data> {
    private final ObjectNamespace objectNamespace;
    private final NodeEngine nodeEngine;
    private final String userCodeNamespace;
    private boolean enabled;
    private InMemoryFormat inMemoryFormat;
    private RingbufferStore store;
    private SerializationService serializationService;

    private RingbufferStoreWrapper(ObjectNamespace objectNamespace, NodeEngine nodeEngine, String userCodeNamespace) {
        this.objectNamespace = objectNamespace;
        this.nodeEngine = nodeEngine;
        this.userCodeNamespace = userCodeNamespace;
    }

    public static RingbufferStoreWrapper create(ObjectNamespace namespace, RingbufferStoreConfig storeConfig, InMemoryFormat inMemoryFormat, SerializationService serializationService, ClassLoader classLoader, NodeEngine nodeEngine, String userCodeNamespace) {
        Preconditions.checkNotNull(namespace, "namespace should not be null");
        Preconditions.checkNotNull(serializationService, "serializationService should not be null");
        RingbufferStoreWrapper storeWrapper = new RingbufferStoreWrapper(namespace, nodeEngine, userCodeNamespace);
        storeWrapper.serializationService = serializationService;
        if (storeConfig == null || !storeConfig.isEnabled()) {
            return storeWrapper;
        }
        RingbufferStore ringbufferStore = RingbufferStoreWrapper.createRingbufferStore(namespace, storeConfig, classLoader, nodeEngine, userCodeNamespace);
        if (ringbufferStore != null) {
            storeWrapper.enabled = storeConfig.isEnabled();
            storeWrapper.inMemoryFormat = inMemoryFormat;
            storeWrapper.store = ringbufferStore;
        }
        return storeWrapper;
    }

    private static RingbufferStore createRingbufferStore(ObjectNamespace namespace, RingbufferStoreConfig storeConfig, ClassLoader classLoader, NodeEngine nodeEngine, String userCodeNamespace) {
        RingbufferStore store = RingbufferStoreWrapper.getRingbufferStore(storeConfig, classLoader);
        if (store == null) {
            store = RingbufferStoreWrapper.getRingbufferStoreFactory(namespace, storeConfig, classLoader, nodeEngine, userCodeNamespace);
        }
        return store;
    }

    private static RingbufferStore getRingbufferStore(RingbufferStoreConfig storeConfig, ClassLoader classLoader) {
        if (storeConfig == null) {
            return null;
        }
        return RingbufferStoreWrapper.getOrInstantiate(storeConfig.getStoreImplementation(), classLoader, storeConfig.getClassName());
    }

    private static RingbufferStore getRingbufferStoreFactory(ObjectNamespace objectNamespace, RingbufferStoreConfig storeConfig, ClassLoader classLoader, NodeEngine nodeEngine, String userCodeNamespace) {
        String className;
        if (storeConfig == null) {
            return null;
        }
        RingbufferStoreFactory implementation = storeConfig.getFactoryImplementation();
        RingbufferStoreFactory factory = RingbufferStoreWrapper.getOrInstantiate(implementation, classLoader, className = storeConfig.getFactoryClassName());
        if (factory == null) {
            return null;
        }
        return NamespaceUtil.callWithNamespace(nodeEngine, userCodeNamespace, () -> factory.newRingbufferStore(objectNamespace.getObjectName(), storeConfig.getProperties()));
    }

    private static <T> T getOrInstantiate(T instance, ClassLoader classLoader, String className) {
        if (instance != null) {
            return instance;
        }
        try {
            return ClassLoaderUtil.newInstance(classLoader, className);
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
            return null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void instrument(NodeEngine nodeEngine) {
        Diagnostics diagnostics = ((NodeEngineImpl)nodeEngine).getDiagnostics();
        StoreLatencyPlugin storeLatencyPlugin = diagnostics.getPlugin(StoreLatencyPlugin.class);
        if (!this.enabled || storeLatencyPlugin == null) {
            return;
        }
        this.store = new LatencyTrackingRingbufferStore(this.store, storeLatencyPlugin, this.objectNamespace);
    }

    @Override
    public void store(long sequence, Data value) {
        NamespaceUtil.runWithNamespace(this.nodeEngine, this.userCodeNamespace, () -> {
            Object actualValue = this.isBinaryFormat() ? (Object)Arrays.copyOf(value.toByteArray(), value.totalSize()) : this.serializationService.toObject(value);
            this.store.store(sequence, actualValue);
        });
    }

    public void storeAll(long firstItemSequence, Data[] items) {
        NamespaceUtil.runWithNamespace(this.nodeEngine, this.userCodeNamespace, () -> {
            Object[] storedItems = new Object[items.length];
            for (int i = 0; i < items.length; ++i) {
                Data value = items[i];
                storedItems[i] = this.isBinaryFormat() ? (Object)Arrays.copyOf(value.toByteArray(), value.totalSize()) : this.serializationService.toObject(value);
            }
            this.store.storeAll(firstItemSequence, storedItems);
        });
    }

    private boolean isBinaryFormat() {
        return this.inMemoryFormat.equals((Object)InMemoryFormat.BINARY) || this.inMemoryFormat.equals((Object)InMemoryFormat.NATIVE);
    }

    @Override
    public Data load(long sequence) {
        return NamespaceUtil.callWithNamespace(this.nodeEngine, this.userCodeNamespace, () -> {
            Object val = this.store.load(sequence);
            if (val == null) {
                return null;
            }
            if (this.isBinaryFormat()) {
                byte[] dataBuffer = (byte[])val;
                return new HeapData(Arrays.copyOf(dataBuffer, dataBuffer.length));
            }
            return (HeapData)this.serializationService.toData(val);
        });
    }

    @Override
    public long getLargestSequence() {
        return this.store.getLargestSequence();
    }
}

