/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.AbstractHazelcastConnectorSupplier;
import com.hazelcast.security.PermissionsUtil;
import javax.annotation.Nonnull;

class ProcessorFunctionConnectorSupplier
extends AbstractHazelcastConnectorSupplier {
    private static final long serialVersionUID = 1L;
    private final FunctionEx<HazelcastInstance, Processor> processorFunction;

    ProcessorFunctionConnectorSupplier(String dataConnectionName, String clientXml, FunctionEx<HazelcastInstance, Processor> processorFunction) {
        super(dataConnectionName, clientXml);
        this.processorFunction = processorFunction;
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) {
        PermissionsUtil.checkPermission(this.processorFunction, context);
        super.init(context);
    }

    @Override
    protected Processor createProcessor(HazelcastInstance instance, SerializationService serializationService) {
        return this.processorFunction.apply(instance);
    }
}

