/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.logging.ILogger;
import javax.annotation.Nonnull;

public interface Processor {
    default public boolean isCooperative() {
        return true;
    }

    default public void init(@Nonnull Outbox outbox, @Nonnull Context context) throws Exception {
    }

    default public void process(int ordinal, @Nonnull Inbox inbox) {
        throw new UnsupportedOperationException("Missing implementation in " + this.getClass());
    }

    public boolean tryProcessWatermark(@Nonnull Watermark var1);

    default public boolean tryProcessWatermark(int ordinal, @Nonnull Watermark watermark) {
        return true;
    }

    default public boolean tryProcess() {
        return true;
    }

    default public boolean completeEdge(int ordinal) {
        return true;
    }

    default public boolean complete() {
        return true;
    }

    default public boolean saveToSnapshot() {
        return true;
    }

    default public boolean snapshotCommitPrepare() {
        return true;
    }

    default public boolean snapshotCommitFinish(boolean success) {
        return true;
    }

    default public void restoreFromSnapshot(@Nonnull Inbox inbox) {
        throw new JetException("Processor " + this.getClass().getName() + " does not override the restoreFromSnapshot() method");
    }

    default public boolean finishSnapshotRestore() {
        return true;
    }

    default public void close() throws Exception {
    }

    default public boolean closeIsCooperative() {
        return false;
    }

    public static interface Context
    extends ProcessorSupplier.Context {
        @Override
        @Nonnull
        public ILogger logger();

        public int localProcessorIndex();

        public int globalProcessorIndex();

        default public int[] processorPartitions() {
            int[] memberPartitions = this.memberPartitions();
            int[] res = new int[memberPartitions.length / this.localParallelism() + (memberPartitions.length % this.localParallelism() > this.localProcessorIndex() ? 1 : 0)];
            int i = this.localProcessorIndex();
            int j = 0;
            while (i < memberPartitions.length) {
                res[j] = memberPartitions[i];
                i += this.localParallelism();
                ++j;
            }
            return res;
        }
    }
}

