/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.iobuffer;

import com.hazelcast.internal.tpcengine.iobuffer.IOBufferAllocator;
import com.hazelcast.internal.tpcengine.net.AsyncSocket;
import com.hazelcast.internal.tpcengine.util.BitUtil;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class IOBuffer {
    IOBuffer next;
    AsyncSocket socket;
    boolean trackRelease;
    IOBufferAllocator allocator;
    boolean concurrent;
    AtomicInteger refCount = new AtomicInteger();
    private ByteBuffer buff;

    public IOBuffer(int size) {
        this(size, false);
    }

    public IOBuffer(int size, boolean direct) {
        this.buff = direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    public IOBuffer(ByteBuffer buffer) {
        this.buff = buffer;
    }

    public ByteBuffer byteBuffer() {
        return this.buff;
    }

    public void clear() {
        this.buff.clear();
    }

    public int position() {
        return this.buff.position();
    }

    public void position(int position) {
        this.buff.position(position);
    }

    public void incPosition(int delta) {
        this.buff.position(this.buff.position() + delta);
    }

    public void flip() {
        this.buff.flip();
    }

    public int remaining() {
        return this.buff.remaining();
    }

    public void ensureRemaining(int remaining) {
        if (this.buff.remaining() < remaining) {
            int newCapacity = BitUtil.nextPowerOfTwo(this.buff.capacity() + remaining);
            ByteBuffer newBuffer = this.buff.hasArray() ? ByteBuffer.allocate(newCapacity) : ByteBuffer.allocateDirect(newCapacity);
            this.buff.flip();
            newBuffer.put(this.buff);
            this.buff = newBuffer;
        }
    }

    public byte getByte(int index) {
        return this.buff.get(index);
    }

    public void writeByte(byte value) {
        this.ensureRemaining(1);
        this.buff.put(value);
    }

    public void writeSizedBytes(byte[] src) {
        this.ensureRemaining(4 + src.length);
        this.buff.putInt(src.length);
        this.buff.put(src);
    }

    public void writeBytes(byte[] src) {
        this.ensureRemaining(src.length);
        this.buff.put(src);
    }

    public void readBytes(byte[] dst, int len) {
        this.buff.get(dst, 0, len);
    }

    public char readChar() {
        return this.buff.getChar();
    }

    public void writeChar(char value) {
        this.ensureRemaining(2);
        this.buff.putChar(value);
    }

    public void writeShortL(short v) {
        this.ensureRemaining(4);
        this.buff.put((byte)(v & 0xFF));
        this.buff.put((byte)(v >>> 8 & 0xFF));
    }

    public int getInt(int index) {
        return this.buff.getInt(index);
    }

    public int readInt() {
        return this.buff.getInt();
    }

    public void putInt(int index, int value) {
        this.buff.putInt(index, value);
    }

    public void writeInt(int value) {
        this.ensureRemaining(4);
        this.buff.putInt(value);
    }

    public void writeIntL(int v) {
        this.ensureRemaining(4);
        this.buff.put((byte)(v & 0xFF));
        this.buff.put((byte)(v >>> 8 & 0xFF));
        this.buff.put((byte)(v >>> 16 & 0xFF));
        this.buff.put((byte)(v >>> 24 & 0xFF));
    }

    public long readLong() {
        return this.buff.getLong();
    }

    public long getLong(int index) {
        return this.buff.getLong(index);
    }

    public void putLong(int index, long value) {
        this.buff.putLong(index, value);
    }

    public void writeLong(long value) {
        this.ensureRemaining(8);
        this.buff.putLong(value);
    }

    public void write(ByteBuffer src) {
        this.write(src, src.remaining());
    }

    public void write(ByteBuffer src, int count) {
        this.ensureRemaining(count);
        if (src.remaining() <= count) {
            this.buff.put(src);
        } else {
            int limit = src.limit();
            src.limit(src.position() + count);
            this.buff.put(src);
            src.limit(limit);
        }
    }

    public void writeString(String s) {
        int length = s.length();
        this.ensureRemaining(4 + length * 2);
        this.buff.putInt(length);
        for (int k = 0; k < length; ++k) {
            this.buff.putChar(s.charAt(k));
        }
    }

    public void readString(StringBuffer sb) {
        int size = this.buff.getInt();
        for (int k = 0; k < size; ++k) {
            sb.append(this.buff.getChar());
        }
    }

    public String readString() {
        StringBuilder sb = new StringBuilder();
        int size = this.buff.getInt();
        for (int k = 0; k < size; ++k) {
            sb.append(this.buff.getChar());
        }
        return sb.toString();
    }

    public void acquire() {
        if (this.allocator == null) {
            return;
        }
        if (this.concurrent) {
            int current;
            do {
                if ((current = this.refCount.get()) != 0) continue;
                throw new IllegalStateException("Can't acquire a freed IOBuffer");
            } while (!this.refCount.compareAndSet(current, current + 1));
        } else {
            this.refCount.lazySet(this.refCount.get() + 1);
        }
    }

    public int refCount() {
        return this.refCount.get();
    }

    public void release() {
        block8: {
            if (this.allocator == null) {
                return;
            }
            if (this.concurrent) {
                int current;
                while ((current = this.refCount.get()) > 0) {
                    if (!this.refCount.compareAndSet(current, current - 1)) continue;
                    if (current == 1) {
                        this.allocator.free(this);
                    }
                    break block8;
                }
                throw new IllegalStateException("Too many releases. Ref counter must be larger than 0, current:" + current);
            }
            int current = this.refCount.get();
            if (current == 1) {
                this.refCount.lazySet(0);
                this.allocator.free(this);
            } else if (current > 1) {
                this.refCount.lazySet(current - 1);
            } else {
                throw new IllegalStateException("Too many releases. Ref counter must be larger than 0, current:" + current);
            }
        }
    }
}

