/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.store;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.eviction.EvictionChecker;
import com.hazelcast.internal.nearcache.NearCacheRecord;
import com.hazelcast.internal.nearcache.impl.maxsize.EntryCountNearCacheEvictionChecker;
import com.hazelcast.internal.nearcache.impl.preloader.NearCachePreloader;
import com.hazelcast.internal.nearcache.impl.store.AbstractNearCacheRecordStore;
import com.hazelcast.internal.nearcache.impl.store.HeapNearCacheRecordMap;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class BaseHeapNearCacheRecordStore<K, V, R extends NearCacheRecord>
extends AbstractNearCacheRecordStore<K, V, K, R, HeapNearCacheRecordMap<K, R>> {
    private static final int DEFAULT_INITIAL_CAPACITY = 1000;
    private final NearCachePreloader<K> nearCachePreloader;
    private final BiFunction<? super K, ? super R, ? extends R> invalidatorFunction = this.createInvalidatorFunction();

    BaseHeapNearCacheRecordStore(String name, NearCacheConfig nearCacheConfig, SerializationService serializationService, ClassLoader classLoader) {
        super(nearCacheConfig, serializationService, classLoader);
        NearCachePreloaderConfig preloaderConfig = nearCacheConfig.getPreloaderConfig();
        this.nearCachePreloader = preloaderConfig.isEnabled() ? new NearCachePreloader(name, preloaderConfig, this.nearCacheStats, serializationService) : null;
    }

    @Override
    protected EvictionChecker createNearCacheEvictionChecker(EvictionConfig evictionConfig, NearCacheConfig nearCacheConfig) {
        MaxSizePolicy maxSizePolicy = evictionConfig.getMaxSizePolicy();
        if (maxSizePolicy == MaxSizePolicy.ENTRY_COUNT) {
            return new EntryCountNearCacheEvictionChecker(evictionConfig.getSize(), this.records);
        }
        throw new IllegalArgumentException(String.format("Invalid max-size policy (%s) for %s! Only %s is supported.", new Object[]{maxSizePolicy, this.getClass().getName(), MaxSizePolicy.ENTRY_COUNT}));
    }

    @Override
    protected HeapNearCacheRecordMap<K, R> createNearCacheRecordMap(NearCacheConfig nearCacheConfig) {
        return new HeapNearCacheRecordMap(this.serializationService, 1000);
    }

    @Override
    public R getRecord(K key) {
        return (R)((NearCacheRecord)((HeapNearCacheRecordMap)this.records).get(key));
    }

    @Override
    protected R putRecord(K key, R record) {
        NearCacheRecord oldRecord = (NearCacheRecord)((HeapNearCacheRecordMap)this.records).put(key, record);
        this.nearCacheStats.incrementOwnedEntryMemoryCost(this.getTotalStorageMemoryCost(key, record));
        if (oldRecord != null) {
            this.nearCacheStats.decrementOwnedEntryMemoryCost(this.getTotalStorageMemoryCost(key, oldRecord));
        }
        return (R)oldRecord;
    }

    @Override
    protected boolean containsRecordKey(K key) {
        return ((HeapNearCacheRecordMap)this.records).containsKey(key);
    }

    @Override
    public void onEvict(K key, R record, boolean wasExpired) {
        if (!this.canUpdateStats(record)) {
            return;
        }
        super.onEvict(key, record, wasExpired);
        this.nearCacheStats.decrementOwnedEntryMemoryCost(this.getTotalStorageMemoryCost(key, record));
    }

    @Override
    public void doExpiration() {
        for (Map.Entry entry : ((HeapNearCacheRecordMap)this.records).entrySet()) {
            Object key = entry.getKey();
            NearCacheRecord value = (NearCacheRecord)entry.getValue();
            if (!this.isRecordExpired(value)) continue;
            this.invalidate(key);
            this.onExpire(key, value);
        }
    }

    @Override
    public void loadKeys(DataStructureAdapter<Object, ?> adapter) {
        if (this.nearCachePreloader != null) {
            this.nearCachePreloader.loadKeys(adapter);
        }
    }

    @Override
    public void storeKeys() {
        if (this.nearCachePreloader != null) {
            this.nearCachePreloader.storeKeys(((HeapNearCacheRecordMap)this.records).keySet().iterator());
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.nearCachePreloader != null) {
            this.nearCachePreloader.destroy();
        }
    }

    @Override
    @Nullable
    public V tryPublishReserved(K key, V value, long reservationId, boolean deserialize) {
        NearCacheRecord existingRecord = ((HeapNearCacheRecordMap)this.records).applyIfPresent(key, (key1, reservedRecord) -> this.publishReservedRecord(key1, value, reservedRecord, reservationId));
        if (existingRecord == null || !deserialize) {
            return null;
        }
        Object cachedValue = existingRecord.getValue();
        return cachedValue instanceof Data ? this.toValue(cachedValue) : cachedValue;
    }

    @Override
    protected R reserveForReadUpdate(K key, Data keyData, long reservationId) {
        return (R)((NearCacheRecord)((HeapNearCacheRecordMap)this.records).applyIfAbsent(key, new ReadUpdateReservation(keyData, reservationId)));
    }

    @Override
    protected R reserveForWriteUpdate(K key, Data keyData, long reservationId) {
        return (R)((NearCacheRecord)((HeapNearCacheRecordMap)this.records).apply(key, new WriteUpdateReservation(keyData, reservationId)));
    }

    @Override
    public void invalidate(K key) {
        ((HeapNearCacheRecordMap)this.records).applyIfPresent(key, this.invalidatorFunction);
        this.nearCacheStats.incrementInvalidationRequests();
    }

    private BiFunction<K, R, R> createInvalidatorFunction() {
        return (key, record) -> {
            if (this.canUpdateStats(record)) {
                this.nearCacheStats.decrementOwnedEntryCount();
                this.nearCacheStats.decrementOwnedEntryMemoryCost(this.getTotalStorageMemoryCost(key, record));
                this.nearCacheStats.incrementInvalidations();
            }
            return null;
        };
    }

    private class ReadUpdateReservation
    implements Function<K, R> {
        private final Data keyData;
        private final long reservationId;

        ReadUpdateReservation(Data keyData, long reservationId) {
            this.keyData = keyData;
            this.reservationId = reservationId;
        }

        @Override
        public R apply(K key) {
            return BaseHeapNearCacheRecordStore.this.newReservationRecord(key, this.keyData, this.reservationId);
        }
    }

    private class WriteUpdateReservation
    implements BiFunction<K, R, R> {
        private final Data keyData;
        private final long reservationId;

        WriteUpdateReservation(Data keyData, long reservationId) {
            this.keyData = keyData;
            this.reservationId = reservationId;
        }

        @Override
        public R apply(K key, R existingRecord) {
            return BaseHeapNearCacheRecordStore.this.reserveForWriteUpdate(key, this.keyData, existingRecord, this.reservationId);
        }
    }
}

