/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.concurrent.TimeUnit;

public class MetricsPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.metrics.period.seconds", 60, TimeUnit.SECONDS);
    private final MetricsRegistry metricsRegistry;
    private final long periodMillis;
    private final MetricsCollectorImpl metricCollector = new MetricsCollectorImpl();

    public MetricsPlugin(NodeEngineImpl nodeEngine) {
        this(nodeEngine.getLogger(MetricsPlugin.class), nodeEngine.getMetricsRegistry(), nodeEngine.getProperties());
    }

    public MetricsPlugin(ILogger logger, MetricsRegistry metricsRegistry, HazelcastProperties properties) {
        super(logger);
        this.metricsRegistry = metricsRegistry;
        this.periodMillis = properties.getMillis(PERIOD_SECONDS);
    }

    @Override
    public void onStart() {
        this.logger.info("Plugin:active, period-millis:" + this.periodMillis);
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        this.metricCollector.writer = writer;
        this.metricCollector.timeMillis = System.currentTimeMillis();
        this.metricsRegistry.collect(this.metricCollector);
        this.metricCollector.writer = null;
    }

    private static class MetricsCollectorImpl
    implements MetricsCollector {
        private static final String SECTION_NAME = "Metric";
        private DiagnosticsLogWriter writer;
        private long timeMillis;

        private MetricsCollectorImpl() {
        }

        @Override
        public void collectLong(MetricDescriptor descriptor, long value) {
            if (descriptor.isTargetIncluded(MetricTarget.DIAGNOSTICS)) {
                this.writer.writeSectionKeyValue(SECTION_NAME, this.timeMillis, descriptor.metricString(), value);
            }
        }

        @Override
        public void collectDouble(MetricDescriptor descriptor, double value) {
            if (descriptor.isTargetIncluded(MetricTarget.DIAGNOSTICS)) {
                this.writer.writeSectionKeyValue(SECTION_NAME, this.timeMillis, descriptor.metricString(), value);
            }
        }

        @Override
        public void collectException(MetricDescriptor descriptor, Exception e) {
            if (descriptor.isTargetIncluded(MetricTarget.DIAGNOSTICS)) {
                this.writer.writeSectionKeyValue(SECTION_NAME, this.timeMillis, descriptor.metricString(), e.getClass().getName() + ":" + e.getMessage());
            }
        }

        @Override
        public void collectNoValue(MetricDescriptor descriptor) {
            if (descriptor.isTargetIncluded(MetricTarget.DIAGNOSTICS)) {
                this.writer.writeSectionKeyValue(SECTION_NAME, this.timeMillis, descriptor.metricString(), "NA");
            }
        }
    }
}

