/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.crdt;

import com.hazelcast.internal.crdt.CRDTDataSerializerHook;
import com.hazelcast.internal.crdt.CRDTReplicationAwareService;
import com.hazelcast.internal.crdt.CRDTReplicationMigrationService;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Map;

public abstract class AbstractCRDTReplicationOperation<T extends IdentifiedDataSerializable>
extends Operation
implements IdentifiedDataSerializable,
MigrationCycleOperation {
    private Map<String, T> replicationData;

    protected AbstractCRDTReplicationOperation() {
    }

    public AbstractCRDTReplicationOperation(Map<String, T> replicationData) {
        this.replicationData = replicationData;
    }

    @Override
    public void run() throws Exception {
        CRDTReplicationAwareService service = (CRDTReplicationAwareService)this.getService();
        for (Map.Entry<String, T> entry : this.replicationData.entrySet()) {
            service.merge(entry.getKey(), (IdentifiedDataSerializable)entry.getValue());
        }
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        CRDTReplicationMigrationService replicationMigrationService = (CRDTReplicationMigrationService)this.getNodeEngine().getService("hz:impl:CRDTReplicationMigrationService");
        replicationMigrationService.scheduleMigrationTask(0L);
    }

    @Override
    public int getFactoryId() {
        return CRDTDataSerializerHook.F_ID;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeMapStringKey(this.replicationData, out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.replicationData = SerializationUtil.readMapStringKey(in);
    }
}

