/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientSqlResubmissionMode;
import com.hazelcast.internal.util.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ClientSqlConfig {
    public static final ClientSqlResubmissionMode DEFAULT_RESUBMISSION_MODE = ClientSqlResubmissionMode.NEVER;
    private ClientSqlResubmissionMode resubmissionMode = DEFAULT_RESUBMISSION_MODE;

    public ClientSqlConfig() {
    }

    public ClientSqlConfig(@Nonnull ClientSqlConfig sqlConfig) {
        this.resubmissionMode = sqlConfig.getResubmissionMode();
    }

    @Nonnull
    public ClientSqlConfig setResubmissionMode(@Nonnull ClientSqlResubmissionMode resubmissionMode) {
        Preconditions.isNotNull(resubmissionMode, "resubmissionMode");
        this.resubmissionMode = resubmissionMode;
        return this;
    }

    @Nonnull
    public ClientSqlResubmissionMode getResubmissionMode() {
        return this.resubmissionMode;
    }

    public String toString() {
        return "ClientSqlConfig{resubmissionMode=" + this.resubmissionMode + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientSqlConfig that = (ClientSqlConfig)o;
        return this.resubmissionMode == that.resubmissionMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resubmissionMode});
    }
}

