/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderEnd;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderEnd;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitReader;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitWriter;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.ByteUtil;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.LittleEndianBitConverter;

public class StreamObjectHeaderEnd16bit
extends StreamObjectHeaderEnd {
    public StreamObjectHeaderEnd16bit(int type) throws TikaException {
        this.type = StreamObjectTypeHeaderEnd.fromIntVal(type);
        if (this.type == null) {
            throw new TikaException(String.format(Locale.US, "The type value %d is not defined for the stream object end 16-bit header", type));
        }
    }

    public StreamObjectHeaderEnd16bit(StreamObjectTypeHeaderEnd headerType) {
        this.type = headerType;
    }

    public StreamObjectHeaderEnd16bit() {
    }

    @Override
    public List<Byte> serializeToByteList() throws IOException {
        BitWriter bitFieldWriter = new BitWriter(2);
        bitFieldWriter.appendInit32(3, 2);
        bitFieldWriter.appendUInit32(this.type.getIntVal(), 14);
        return bitFieldWriter.getByteList();
    }

    public short toUint16() throws IOException {
        List<Byte> bytes = this.serializeToByteList();
        return LittleEndianBitConverter.ToUInt16(ByteUtil.toByteArray(bytes), 0);
    }

    @Override
    protected int doDeserializeFromByteArray(byte[] byteArray, int startIndex) throws IOException, TikaException {
        BitReader reader = new BitReader(byteArray, startIndex);
        int headerType = reader.readInt32(2);
        if (headerType != 3) {
            throw new TikaException(String.format(Locale.US, "Failed to get the StreamObjectHeaderEnd16bit header type value, expect value %d, but actual value is %s", 3, headerType));
        }
        int typeValue = reader.readUInt32(14);
        this.type = StreamObjectTypeHeaderEnd.fromIntVal(typeValue);
        if (this.type == null) {
            throw new TikaException(String.format(Locale.US, "Failed to get the StreamObjectHeaderEnd16bit type value, the value %d is not defined", typeValue));
        }
        return 2;
    }
}

