/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.text;

import java.util.ArrayList;
import org.apache.nifi.util.text.DateTimeFormatterMatcher;
import org.apache.nifi.util.text.DateTimeMatcher;
import org.apache.nifi.util.text.ListDateTimeMatcher;
import org.apache.nifi.util.text.RegexDateTimeMatcher;
import org.apache.nifi.util.text.StartsWithDigitsDateTimeMatcher;

class DateTimeMatcherCompiler {
    DateTimeMatcherCompiler() {
    }

    DateTimeMatcher compile(String format) {
        RegexDateTimeMatcher regexMatcher = new RegexDateTimeMatcher.Compiler().compile(format);
        ArrayList<DateTimeMatcher> matchers = new ArrayList<DateTimeMatcher>(4);
        int minLength = regexMatcher.getMinInputLength();
        int maxLength = regexMatcher.getMaxInputLength();
        matchers.add(input -> input.length() >= minLength && input.length() <= maxLength);
        if (format.startsWith("yyyy")) {
            matchers.add(new StartsWithDigitsDateTimeMatcher(4));
        } else if (format.startsWith("yy") || format.startsWith("mm")) {
            matchers.add(new StartsWithDigitsDateTimeMatcher(2));
        } else if (format.startsWith("H") || format.startsWith("h")) {
            matchers.add(new StartsWithDigitsDateTimeMatcher(1));
        } else if (format.startsWith("M") && !format.startsWith("MMM")) {
            matchers.add(new StartsWithDigitsDateTimeMatcher(1));
        }
        matchers.add(regexMatcher);
        matchers.add(new DateTimeFormatterMatcher(format));
        return new ListDateTimeMatcher(matchers);
    }
}

