/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.convert;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.convert._MessageUtils;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DoubleConverter
implements Converter {
    public static final String CONVERTER_ID = "jakarta.faces.Double";
    public static final String STRING_ID = "jakarta.faces.converter.STRING";
    public static final String DOUBLE_ID = "jakarta.faces.converter.DoubleConverter.DOUBLE";

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value != null && (value = value.trim()).length() > 0) {
            try {
                value = this.fixLocale(facesContext, value);
                return this.stringToDouble(value);
            }
            catch (NumberFormatException e) {
                throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, DOUBLE_ID, new Object[]{value, "4214", _MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
            }
        }
        return null;
    }

    private String fixLocale(FacesContext facesContext, String value) {
        Locale loc = facesContext.getViewRoot().getLocale();
        if (loc == null || loc == Locale.US) {
            return value;
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(loc);
        char decSep = dfs.getDecimalSeparator();
        if (decSep != '.' && value.lastIndexOf(decSep) >= 0) {
            StringBuffer sbVal = new StringBuffer();
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) == decSep) {
                    sbVal.append('.');
                    continue;
                }
                sbVal.append(value.charAt(i));
            }
            value = sbVal.toString();
        }
        return value;
    }

    private Double stringToDouble(String value) {
        if (value.length() >= 23) {
            StringBuffer normalized = new StringBuffer();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '.') continue;
                normalized.append(c);
            }
            String normalizedString = normalized.toString();
            if (normalizedString.contains("22250738585072012") && normalizedString.contains("e-")) {
                throw new NumberFormatException("Not Allowed! This value could possibly kill the VM!");
            }
        }
        return Double.valueOf(value);
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return Double.toString(((Number)value).doubleValue());
        }
        catch (Exception e) {
            throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, STRING_ID, new Object[]{value, _MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
        }
    }
}

