/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import javax.faces.component.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class _ComponentChildrenList
extends AbstractList<UIComponent>
implements Serializable,
RandomAccess {
    private static final long serialVersionUID = -6775078929331154224L;
    private UIComponent _component;
    private List<UIComponent> _list = new ArrayList<UIComponent>(4);

    _ComponentChildrenList(UIComponent component) {
        this._component = component;
    }

    @Override
    public UIComponent get(int index) {
        return this._list.get(index);
    }

    @Override
    public int size() {
        return this._list.size();
    }

    @Override
    public UIComponent set(int index, UIComponent value) {
        this.checkValue(value);
        this.removeChildrenFromParent(value);
        UIComponent child = this._list.set(index, value);
        if (child != value) {
            this.updateParent(value);
            if (child != null) {
                this.childRemoved(child);
            }
        }
        return child;
    }

    @Override
    public boolean add(UIComponent value) {
        this.checkValue(value);
        this.removeChildrenFromParent(value);
        boolean res = this._list.add(value);
        this.updateParent(value);
        return res;
    }

    @Override
    public void add(int index, UIComponent value) {
        this.checkValue(value);
        this.removeChildrenFromParent(value);
        this._list.add(index, value);
        this.updateParent(value);
    }

    @Override
    public UIComponent remove(int index) {
        UIComponent child = this._list.remove(index);
        if (child != null) {
            this.childRemoved(child);
        }
        return child;
    }

    private void checkValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
    }

    private void childRemoved(UIComponent child) {
        child.setParent(null);
    }

    private void updateParent(UIComponent child) {
        child.setParent(this._component);
    }

    private void removeChildrenFromParent(UIComponent child) {
        UIComponent oldParent = child.getParent();
        if (oldParent != null && !oldParent.getChildren().remove(child) && oldParent.getFacetCount() > 0) {
            Iterator<Map.Entry<String, UIComponent>> it = oldParent.getFacets().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, UIComponent> entry = it.next();
                if (!entry.getValue().equals(child)) continue;
                it.remove();
                break;
            }
        }
    }

    @Override
    public boolean remove(Object value) {
        if (!(value instanceof UIComponent)) {
            throw new ClassCastException("value is not a UIComponent");
        }
        this.checkValue(value);
        if (this._list.remove(value)) {
            this.childRemoved((UIComponent)value);
            return true;
        }
        return false;
    }
}

