/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.BufferedGridCoverage;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridOrientation;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.IncompleteGridGeometryException;
import org.apache.sis.internal.coverage.j2d.Colorizer;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TiledImage;
import org.apache.sis.internal.coverage.j2d.WritableTiledImage;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class GridCoverageBuilder {
    private GridGeometry domain;
    private List<SampleDimension> ranges;
    private int visibleBand;
    private RenderedImage image;
    private Raster raster;
    private DataBuffer buffer;
    private Dimension size;
    private long flippedAxes;
    private Hashtable<String, Object> properties;

    public GridCoverageBuilder setDomain(GridGeometry gridGeometry) {
        this.domain = gridGeometry != GridGeometry.UNDEFINED ? gridGeometry : null;
        return this;
    }

    public GridCoverageBuilder setDomain(Envelope envelope) {
        return this.setDomain(envelope == null ? null : new GridGeometry(null, envelope, GridOrientation.HOMOTHETY));
    }

    public GridCoverageBuilder setRanges(Collection<? extends SampleDimension> collection) {
        if (collection == null) {
            this.ranges = null;
        } else {
            ArgumentChecks.ensureNonEmpty("bands", collection);
            if (this.ranges instanceof ArrayList) {
                this.ranges.clear();
                this.ranges.addAll(collection);
            } else {
                this.ranges = new ArrayList<SampleDimension>(collection);
            }
        }
        return this;
    }

    public GridCoverageBuilder setRanges(SampleDimension ... sampleDimensionArray) {
        if (sampleDimensionArray == null) {
            this.ranges = null;
        } else {
            ArgumentChecks.ensureNonEmpty("bands", sampleDimensionArray);
            this.ranges = Arrays.asList(sampleDimensionArray);
        }
        return this;
    }

    public GridCoverageBuilder addRange(SampleDimension sampleDimension) {
        ArgumentChecks.ensureNonNull("band", sampleDimension);
        if (!(this.ranges instanceof ArrayList)) {
            this.ranges = this.ranges != null ? new ArrayList<SampleDimension>(this.ranges) : new ArrayList();
        }
        this.ranges.add(sampleDimension);
        return this;
    }

    public GridCoverageBuilder setValues(RenderedImage renderedImage) {
        ArgumentChecks.ensureNonNull("data", renderedImage);
        this.image = renderedImage;
        this.raster = null;
        this.buffer = null;
        this.size = null;
        return this;
    }

    public GridCoverageBuilder setValues(Raster raster) {
        ArgumentChecks.ensureNonNull("data", raster);
        this.raster = raster;
        this.image = null;
        this.buffer = null;
        this.size = null;
        return this;
    }

    public GridCoverageBuilder setValues(DataBuffer dataBuffer, Dimension dimension) {
        ArgumentChecks.ensureNonNull("data", dataBuffer);
        if (dimension != null) {
            dimension = new Dimension(dimension);
            ArgumentChecks.ensureStrictlyPositive("width", dimension.width);
            ArgumentChecks.ensureStrictlyPositive("height", dimension.height);
        }
        this.size = dimension;
        this.buffer = dataBuffer;
        this.image = null;
        this.raster = null;
        return this;
    }

    public GridCoverageBuilder flipGridAxis(int n) {
        ArgumentChecks.ensurePositive("dimension", n);
        if (n >= 64) {
            throw new IllegalArgumentException(Errors.format((short)37, n + 1));
        }
        this.flippedAxes ^= 1L << n;
        return this;
    }

    public void addImageProperty(String string, Object object) {
        ArgumentChecks.ensureNonNull("key", string);
        ArgumentChecks.ensureNonNull("value", object);
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if (this.properties.putIfAbsent(string, object) != null) {
            throw new IllegalArgumentException(Errors.format((short)27, string));
        }
    }

    public GridCoverage build() throws IllegalStateException {
        GridGeometry gridGeometry = this.domain;
        List<SampleDimension> list = this.ranges;
        try {
            if (this.image == null) {
                if (this.raster == null) {
                    if (this.buffer == null) {
                        throw new IllegalStateException(GridCoverageBuilder.missingProperty("values"));
                    }
                    if (this.size != null) {
                        gridGeometry = GridCoverage2D.addExtentIfAbsent(gridGeometry, new Rectangle(this.size));
                        GridCoverageBuilder.verifyGridExtent(gridGeometry.getExtent(), this.size.width, this.size.height);
                    } else if (gridGeometry == null) {
                        throw new IncompleteGridGeometryException(GridCoverageBuilder.missingProperty("size"));
                    }
                    list = GridCoverage2D.defaultIfAbsent(list, null, this.buffer.getNumBanks());
                    return new BufferedGridCoverage(this.domainWithAxisFlips(gridGeometry), list, this.buffer);
                }
                list = GridCoverage2D.defaultIfAbsent(list, null, this.raster.getNumBands());
                SampleModel sampleModel = this.raster.getSampleModel();
                Colorizer colorizer = new Colorizer(Colorizer.GRAYSCALE);
                ColorModel colorModel = colorizer.initialize(list.get(this.visibleBand)) || colorizer.initialize(sampleModel, this.visibleBand) ? colorizer.createColorModel(ImageUtilities.getBandType(sampleModel), list.size(), this.visibleBand) : Colorizer.NULL_COLOR_MODEL;
                if (this.raster instanceof WritableRaster) {
                    WritableRaster writableRaster = (WritableRaster)this.raster;
                    this.image = colorModel != null && (writableRaster.getMinX() | writableRaster.getMinY()) == 0 ? new BufferedImage(colorModel, writableRaster, false, this.properties) : new WritableTiledImage((Map<String, Object>)this.properties, colorModel, writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, writableRaster);
                } else {
                    this.image = new TiledImage(this.properties, colorModel, this.raster.getWidth(), this.raster.getHeight(), 0, 0, this.raster);
                }
            }
            return new GridCoverage2D(this.domainWithAxisFlips(gridGeometry), list, this.image);
        }
        catch (ArithmeticException | IllegalArgumentException | NullPointerException | TransformException throwable) {
            throw new IllegalStateException(Resources.format((short)3), throwable);
        }
    }

    private GridGeometry domainWithAxisFlips(GridGeometry gridGeometry) throws TransformException {
        long l = this.flippedAxes;
        if (l != 0L && (gridGeometry = GridCoverage2D.addExtentIfAbsent(gridGeometry, this.image)) != null && gridGeometry.isDefined(4)) {
            int n;
            GridExtent gridExtent = gridGeometry.getExtent();
            int n2 = gridExtent.getDimension();
            MatrixSIS matrixSIS = Matrices.createDiagonal((int)(gridGeometry.getTargetDimension() + 1), (int)(n2 + 1));
            do {
                n = Long.numberOfTrailingZeros(l);
                matrixSIS.setElement(n, n, -1.0);
                matrixSIS.setElement(n, n2, gridExtent.getSize(n, false));
            } while ((l &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
            gridGeometry = new GridGeometry(gridGeometry, gridExtent, (MathTransform)MathTransforms.linear((Matrix)matrixSIS));
        }
        return gridGeometry;
    }

    private static void verifyGridExtent(GridExtent gridExtent, int ... nArray) {
        int[] nArray2 = gridExtent.getSubspaceDimensions(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            long l = gridExtent.getSize(nArray2[i]);
            if ((long)n == l) continue;
            throw new IllegalGridGeometryException(Resources.format((short)44, i, n, l));
        }
    }

    private static String missingProperty(String string) {
        return Errors.format((short)89, string);
    }
}

