/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.logout;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasLogoutActionBuilder<U extends CommonProfile>
implements LogoutActionBuilder<U> {
    private static final Logger logger = LoggerFactory.getLogger(CasLogoutActionBuilder.class);
    private final String serverLogoutUrl;
    private final String postLogoutUrlParameter;

    public CasLogoutActionBuilder(String serverLogoutUrl, String postLogoutUrlParameter) {
        if (CommonHelper.isNotBlank(serverLogoutUrl)) {
            CommonHelper.assertNotBlank("postLogoutUrlParameter", postLogoutUrlParameter);
        }
        this.serverLogoutUrl = serverLogoutUrl;
        this.postLogoutUrlParameter = postLogoutUrlParameter;
    }

    @Override
    public RedirectAction getLogoutAction(WebContext context, U currentProfile, String targetUrl) {
        if (CommonHelper.isBlank(this.serverLogoutUrl)) {
            return null;
        }
        String redirectUrl = this.serverLogoutUrl;
        if (CommonHelper.isNotBlank(targetUrl)) {
            redirectUrl = CommonHelper.addParameter(redirectUrl, this.postLogoutUrlParameter, targetUrl);
        }
        logger.debug("redirectUrl: {}", (Object)redirectUrl);
        return RedirectAction.redirect(redirectUrl);
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), "serverLogoutUrl", this.serverLogoutUrl, "postLogoutUrlParameter", this.postLogoutUrlParameter);
    }
}

