/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.io.Serializable;
import java.util.HashSet;
import net.sf.ehcache.Element;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.ObjectClassNode;
import org.apache.directory.api.ldap.model.filter.ScopeNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.Optimizer;
import org.apache.directory.server.xdbm.search.PartitionSearchResult;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.apache.directory.server.xdbm.search.evaluator.BaseLevelScopeEvaluator;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSearchEngine
implements SearchEngine {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSearchEngine.class);
    private final Optimizer optimizer;
    private final Store db;
    private final CursorBuilder cursorBuilder;
    private final EvaluatorBuilder evaluatorBuilder;

    public DefaultSearchEngine(Store db, CursorBuilder cursorBuilder, EvaluatorBuilder evaluatorBuilder, Optimizer optimizer) {
        this.db = db;
        this.optimizer = optimizer;
        this.cursorBuilder = cursorBuilder;
        this.evaluatorBuilder = evaluatorBuilder;
    }

    @Override
    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    @Override
    public PartitionSearchResult computeResult(PartitionTxn partitionTxn, SchemaManager schemaManager, SearchOperationContext searchContext) throws LdapException {
        AndNode root;
        SearchScope scope = searchContext.getScope();
        Dn baseDn = searchContext.getDn();
        AliasDerefMode aliasDerefMode = searchContext.getAliasDerefMode();
        ExprNode filter = searchContext.getFilter();
        String baseId = this.db.getEntryId(partitionTxn, baseDn);
        PartitionSearchResult searchResult = new PartitionSearchResult(schemaManager);
        HashSet<IndexEntry<String, String>> resultSet = new HashSet<IndexEntry<String, String>>();
        if (baseId == null) {
            if (((Partition)this.db).getSuffixDn().equals((Object)baseDn)) {
                searchResult.setResultSet(resultSet);
                return searchResult;
            }
            throw new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_648, (Object[])new Object[]{baseDn}));
        }
        Dn aliasedBase = null;
        if (this.db.getAliasCache() != null) {
            Element aliasBaseElement = this.db.getAliasCache().get((Serializable)((Object)baseId));
            if (aliasBaseElement != null) {
                aliasedBase = (Dn)aliasBaseElement.getObjectValue();
            }
        } else {
            aliasedBase = this.db.getAliasIndex().reverseLookup(partitionTxn, baseId);
        }
        Dn effectiveBase = baseDn;
        String effectiveBaseId = baseId;
        if (aliasedBase != null && aliasDerefMode.isDerefFindingBase()) {
            effectiveBase = !aliasedBase.isSchemaAware() ? new Dn(schemaManager, aliasedBase) : aliasedBase;
            effectiveBaseId = this.db.getEntryId(partitionTxn, effectiveBase);
        }
        if (scope == SearchScope.OBJECT) {
            Evaluator<ExprNode> evaluator;
            IndexEntry indexEntry = new IndexEntry();
            indexEntry.setId(effectiveBaseId);
            Entry entry = this.db.fetch(partitionTxn, (String)indexEntry.getId(), effectiveBase);
            if (filter instanceof ObjectClassNode) {
                ScopeNode node = new ScopeNode(aliasDerefMode, effectiveBase, effectiveBaseId, scope);
                evaluator = new BaseLevelScopeEvaluator(this.db, node);
            } else {
                this.optimizer.annotate(partitionTxn, filter);
                evaluator = this.evaluatorBuilder.build(partitionTxn, filter);
                if (evaluator == null) {
                    ScopeNode node = new ScopeNode(aliasDerefMode, effectiveBase, effectiveBaseId, scope);
                    evaluator = new BaseLevelScopeEvaluator(this.db, node);
                }
            }
            indexEntry.setEntry(entry);
            resultSet.add(indexEntry);
            searchResult.setEvaluator(evaluator);
            searchResult.setResultSet(resultSet);
            return searchResult;
        }
        if (filter instanceof ObjectClassNode) {
            root = new ScopeNode(aliasDerefMode, effectiveBase, effectiveBaseId, scope);
        } else {
            root = new AndNode();
            root.getChildren().add(filter);
            ScopeNode node = new ScopeNode(aliasDerefMode, effectiveBase, effectiveBaseId, scope);
            root.getChildren().add(node);
        }
        this.optimizer.annotate(partitionTxn, (ExprNode)root);
        Evaluator<ExprNode> evaluator = this.evaluatorBuilder.build(partitionTxn, (ExprNode)root);
        HashSet<String> uuidSet = new HashSet<String>();
        searchResult.setAliasDerefMode(aliasDerefMode);
        searchResult.setCandidateSet(uuidSet);
        long nbResults = this.cursorBuilder.build(partitionTxn, (ExprNode)root, searchResult);
        LOG.debug("Nb results : {} for filter : {}", (Object)nbResults, (Object)root);
        if (nbResults < Long.MAX_VALUE) {
            for (String uuid : uuidSet) {
                IndexEntry indexEntry = new IndexEntry();
                indexEntry.setId(uuid);
                resultSet.add(indexEntry);
            }
        } else {
            IndexCursorAdaptor cursor = new IndexCursorAdaptor(partitionTxn, this.db.getMasterTable().cursor(), true);
            try {
                while (cursor.next()) {
                    IndexEntry indexEntry = (IndexEntry)cursor.get();
                    IndexEntry forwardIndexEntry = new IndexEntry();
                    forwardIndexEntry.setKey(indexEntry.getKey());
                    forwardIndexEntry.setId(indexEntry.getKey());
                    forwardIndexEntry.setEntry(null);
                    resultSet.add(forwardIndexEntry);
                }
            }
            catch (CursorException ce) {
                throw new LdapOtherException(ce.getMessage(), (Throwable)ce);
            }
        }
        searchResult.setEvaluator(evaluator);
        searchResult.setResultSet(resultSet);
        return searchResult;
    }

    @Override
    public Evaluator<? extends ExprNode> evaluator(PartitionTxn partitionTxn, ExprNode filter) throws LdapException {
        return this.evaluatorBuilder.build(partitionTxn, filter);
    }
}

