/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import org.springframework.util.Assert;
import org.springframework.vault.support.VaultTransitContext;

public class Ciphertext {
    private final String ciphertext;
    private final VaultTransitContext context;

    private Ciphertext(String ciphertext, VaultTransitContext context) {
        this.ciphertext = ciphertext;
        this.context = context;
    }

    public static Ciphertext of(String ciphertext) {
        Assert.hasText((String)ciphertext, (String)"Ciphertext must not be null or empty");
        return new Ciphertext(ciphertext, VaultTransitContext.empty());
    }

    public String getCiphertext() {
        return this.ciphertext;
    }

    public VaultTransitContext getContext() {
        return this.context;
    }

    public Ciphertext with(VaultTransitContext context) {
        Assert.notNull((Object)context, (String)"VaultTransitContext must not be null");
        return new Ciphertext(this.getCiphertext(), context);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ciphertext)) {
            return false;
        }
        Ciphertext other = (Ciphertext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ciphertext = this.getCiphertext();
        String other$ciphertext = other.getCiphertext();
        if (this$ciphertext == null ? other$ciphertext != null : !this$ciphertext.equals(other$ciphertext)) {
            return false;
        }
        VaultTransitContext this$context = this.getContext();
        VaultTransitContext other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Ciphertext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ciphertext = this.getCiphertext();
        result = result * 59 + ($ciphertext == null ? 43 : $ciphertext.hashCode());
        VaultTransitContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }
}

