/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication.provider;

import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateTypeEnum;
import org.apache.directory.api.ldap.extras.controls.syncrepl.syncState.SyncStateValue;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncStateValueDecorator;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.AbandonListener;
import org.apache.directory.api.ldap.model.message.AbandonableRequest;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.event.DirectoryListener;
import org.apache.directory.server.core.api.event.EventType;
import org.apache.directory.server.core.api.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapProtocolUtils;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.server.ldap.replication.provider.ReplicaEventLog;
import org.apache.mina.core.future.WriteFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReplSearchListener
implements DirectoryListener,
AbandonListener {
    private static final Logger LOG = LoggerFactory.getLogger(SyncReplSearchListener.class);
    private LdapSession session;
    private SearchRequest searchRequest;
    private volatile boolean pushInRealTime;
    private final ReplicaEventLog consumerMsgLog;
    private static String replConsumerConfigDn = Strings.toLowerCaseAscii("ou=replConsumers,ads-serverId=ldapServer,ou=servers,ads-directoryServiceId=default,ou=config");
    private static String schemaDn = Strings.toLowerCaseAscii("ou=schema");
    private static String replConsumerDn = Strings.toLowerCaseAscii("ou=consumers,ou=system");

    SyncReplSearchListener(LdapSession session, SearchRequest searchRequest, ReplicaEventLog consumerMsgLog, boolean pushInRealTime) {
        this.pushInRealTime = pushInRealTime;
        this.setSession(session);
        this.setSearchRequest(searchRequest);
        this.consumerMsgLog = consumerMsgLog;
    }

    public void setSession(LdapSession session) {
        this.session = session;
    }

    public void setSearchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        if (searchRequest != null) {
            searchRequest.addAbandonListener(this);
        }
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    @Override
    public void requestAbandoned(AbandonableRequest searchRequest) {
        try {
            if (this.session != null) {
                this.session.getCoreSession().getDirectoryService().getEventService().removeListener(this);
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_164, new Object[0]), e);
        }
    }

    private SyncStateValue createControl(DirectoryService directoryService, SyncStateTypeEnum operation, Entry entry) throws LdapInvalidAttributeValueException {
        SyncStateValueDecorator syncStateValue = new SyncStateValueDecorator(directoryService.getLdapCodecService());
        syncStateValue.setSyncStateType(operation);
        String uuidStr = entry.get("entryUUID").getString();
        syncStateValue.setEntryUUID(Strings.uuidToBytes(uuidStr));
        syncStateValue.setCookie(this.getCookie(entry));
        return syncStateValue;
    }

    private void sendResult(SearchResultEntry searchResultEntry, Entry entry, EventType eventType, SyncStateValue syncStateValue) {
        searchResultEntry.addControl(syncStateValue);
        LOG.debug("sending event {} of entry {}", (Object)eventType, (Object)entry.getDn());
        WriteFuture future = this.session.getIoSession().write(searchResultEntry);
        this.handleWriteFuture(future, entry, eventType);
    }

    @Override
    public void entryAdded(AddOperationContext addContext) {
        Entry entry = addContext.getEntry();
        if (this.isConfigEntry(entry) || this.isNotValidForReplication(addContext)) {
            return;
        }
        try {
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.ADD, entry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(entry.getDn());
                resultEntry.setEntry(entry);
                SyncStateValue syncAdd = this.createControl(this.session.getCoreSession().getDirectoryService(), SyncStateTypeEnum.ADD, entry);
                this.sendResult(resultEntry, entry, EventType.ADD, syncAdd);
            }
        }
        catch (LdapInvalidAttributeValueException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    @Override
    public void entryDeleted(DeleteOperationContext deleteContext) {
        Entry entry = deleteContext.getEntry();
        if (this.isConfigEntry(entry) || this.isNotValidForReplication(deleteContext)) {
            return;
        }
        this.sendDeletedEntry(((ClonedServerEntry)entry).getClonedEntry());
    }

    private void sendDeletedEntry(Entry entry) {
        try {
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.DELETE, entry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(entry.getDn());
                resultEntry.setEntry(entry);
                SyncStateValue syncDelete = this.createControl(this.session.getCoreSession().getDirectoryService(), SyncStateTypeEnum.DELETE, entry);
                this.sendResult(resultEntry, entry, EventType.DELETE, syncDelete);
            }
        }
        catch (LdapInvalidAttributeValueException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    @Override
    public void entryModified(ModifyOperationContext modifyContext) {
        Entry alteredEntry = modifyContext.getAlteredEntry();
        if (this.isConfigEntry(alteredEntry) || this.isNotValidForReplication(modifyContext)) {
            return;
        }
        try {
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.MODIFY, alteredEntry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(modifyContext.getDn());
                resultEntry.setEntry(alteredEntry);
                SyncStateValue syncModify = this.createControl(this.session.getCoreSession().getDirectoryService(), SyncStateTypeEnum.MODIFY, alteredEntry);
                this.sendResult(resultEntry, alteredEntry, EventType.MODIFY, syncModify);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    @Override
    public void entryMoved(MoveOperationContext moveContext) {
        Entry entry = moveContext.getModifiedEntry();
        if (this.isConfigEntry(entry) || this.isNotValidForReplication(moveContext)) {
            return;
        }
        try {
            if (!moveContext.getNewSuperior().isDescendantOf(this.consumerMsgLog.getSearchCriteria().getBase())) {
                this.sendDeletedEntry(moveContext.getOriginalEntry());
                return;
            }
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.MODDN, entry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(moveContext.getDn());
                resultEntry.setEntry(entry);
                SyncStateValue syncModify = this.createControl(this.session.getCoreSession().getDirectoryService(), SyncStateTypeEnum.MODDN, entry);
                this.sendResult(resultEntry, entry, EventType.MOVE, syncModify);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    @Override
    public void entryMovedAndRenamed(MoveAndRenameOperationContext moveAndRenameContext) {
        Entry entry = moveAndRenameContext.getModifiedEntry();
        if (this.isConfigEntry(entry) || this.isNotValidForReplication(moveAndRenameContext)) {
            return;
        }
        try {
            if (!moveAndRenameContext.getNewSuperiorDn().isDescendantOf(this.consumerMsgLog.getSearchCriteria().getBase())) {
                this.sendDeletedEntry(entry);
                return;
            }
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.MODDN, entry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(entry.getDn());
                resultEntry.setEntry(entry);
                SyncStateValue syncModify = this.createControl(this.session.getCoreSession().getDirectoryService(), SyncStateTypeEnum.MODDN, entry);
                this.sendResult(resultEntry, entry, EventType.MOVE_AND_RENAME, syncModify);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    @Override
    public void entryRenamed(RenameOperationContext renameContext) {
        Entry entry = renameContext.getModifiedEntry();
        if (this.isConfigEntry(entry) || this.isNotValidForReplication(renameContext)) {
            return;
        }
        try {
            this.consumerMsgLog.log(new ReplicaEventMessage(ChangeType.MODDN, entry));
            if (this.pushInRealTime) {
                SearchResultEntryImpl resultEntry = new SearchResultEntryImpl(this.searchRequest.getMessageId());
                resultEntry.setObjectName(entry.getDn());
                resultEntry.setEntry(entry);
                SyncStateValue syncModify = this.createControl(this.session.getCoreSession().getDirectoryService(), SyncStateTypeEnum.MODDN, entry);
                syncModify.setCookie(this.getCookie(entry));
                this.sendResult(resultEntry, entry, EventType.RENAME, syncModify);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public boolean isPushInRealTime() {
        return this.pushInRealTime;
    }

    public void setPushInRealTime(boolean pushInRealTime) {
        this.pushInRealTime = pushInRealTime;
    }

    private byte[] getCookie(Entry entry) throws LdapInvalidAttributeValueException {
        String csn = entry.get("entryCSN").getString();
        return LdapProtocolUtils.createCookie(this.consumerMsgLog.getId(), csn);
    }

    private void handleWriteFuture(WriteFuture future, Entry entry, EventType event) {
        future.awaitUninterruptibly(10000L);
        if (!future.isWritten()) {
            LOG.error("Failed to write to the consumer {} during the event {} on entry {}", new Object[]{this.consumerMsgLog.getId(), event, entry.getDn()});
            LOG.error("", future.getException());
            this.pushInRealTime = false;
        } else {
            try {
                this.consumerMsgLog.setLastSentCsn(entry.get("entryCSN").getString());
            }
            catch (Exception e) {
                LOG.error("No entry CSN attribute found", e);
            }
        }
    }

    private boolean isConfigEntry(Entry entry) {
        String name = Strings.toLowerCaseAscii(entry.getDn().getName());
        if (name.endsWith(replConsumerConfigDn) || name.endsWith(schemaDn) || name.endsWith(replConsumerDn)) {
            return true;
        }
        return name.startsWith("ads-transportid") && name.endsWith("ou=config");
    }

    private boolean isNotValidForReplication(AbstractChangeOperationContext ctx) {
        if (ctx.isGenerateNoReplEvt()) {
            return true;
        }
        return this.isMmrConfiguredToReceiver(ctx);
    }

    private boolean isMmrConfiguredToReceiver(AbstractChangeOperationContext ctx) {
        if (ctx.isReplEvent()) {
            boolean skip;
            boolean bl = skip = ctx.getRid() == this.consumerMsgLog.getId();
            if (skip) {
                LOG.debug("RID in operation context matches with the ID of replication event log {} for host {}", (Object)this.consumerMsgLog.getName(), (Object)this.consumerMsgLog.getHostName());
            }
            return skip;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SyncReplSearchListener : \n");
        sb.append('\'').append(this.searchRequest).append("', ");
        sb.append('\'').append(this.pushInRealTime).append("', \n");
        sb.append(this.consumerMsgLog);
        sb.append('\n');
        return sb.toString();
    }
}

