/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.LinkedAvlNode;
import org.apache.directory.server.i18n.I18n;

public class AvlTreeSingleton<K>
implements AvlTree<K> {
    private final LinkedAvlNode<K> singleton;
    private final Comparator<K> comparator;

    public AvlTreeSingleton(K key, Comparator<K> comparator) {
        this.singleton = new LinkedAvlNode<K>(key);
        this.comparator = comparator;
    }

    @Override
    public LinkedAvlNode<K> find(K key) {
        if (key != null && this.comparator.compare(key, this.singleton.key) == 0) {
            return this.singleton;
        }
        return null;
    }

    @Override
    public LinkedAvlNode<K> findGreater(K key) {
        if (key != null && this.comparator.compare(key, this.singleton.key) < 0) {
            return this.singleton;
        }
        return null;
    }

    @Override
    public LinkedAvlNode<K> findGreaterOrEqual(K key) {
        if (key != null && this.comparator.compare(key, this.singleton.key) <= 0) {
            return this.singleton;
        }
        return null;
    }

    @Override
    public LinkedAvlNode<K> findLess(K key) {
        if (key != null && this.comparator.compare(key, this.singleton.key) > 0) {
            return this.singleton;
        }
        return null;
    }

    @Override
    public LinkedAvlNode<K> findLessOrEqual(K key) {
        if (key != null && this.comparator.compare(key, this.singleton.key) >= 0) {
            return this.singleton;
        }
        return null;
    }

    @Override
    public Comparator<K> getComparator() {
        return this.comparator;
    }

    @Override
    public LinkedAvlNode<K> getFirst() {
        return this.singleton;
    }

    @Override
    public List<K> getKeys() {
        return Collections.singletonList(this.singleton.getKey());
    }

    @Override
    public LinkedAvlNode<K> getLast() {
        return this.singleton;
    }

    @Override
    public LinkedAvlNode<K> getRoot() {
        return this.singleton;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public K insert(K key) {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_444, new Object[0]));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void printTree() {
        System.out.println("[ " + this.singleton + " ]");
    }

    @Override
    public K remove(K key) {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_444, new Object[0]));
    }
}

