/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.monitor;

import java.util.ServiceLoader;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClientService;
import org.apache.knox.gateway.topology.monitor.RemoteConfigurationMonitor;
import org.apache.knox.gateway.topology.monitor.RemoteConfigurationMonitorProvider;

public class RemoteConfigurationMonitorFactory {
    private static final GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static RemoteConfigurationRegistryClientService remoteConfigRegistryClientService = null;

    public static void setClientService(RemoteConfigurationRegistryClientService clientService) {
        remoteConfigRegistryClientService = clientService;
    }

    private static RemoteConfigurationRegistryClientService getClientService() {
        GatewayServices services;
        if (remoteConfigRegistryClientService == null && (services = GatewayServer.getGatewayServices()) != null) {
            remoteConfigRegistryClientService = (RemoteConfigurationRegistryClientService)services.getService("RemoteConfigRegistryClientService");
        }
        return remoteConfigRegistryClientService;
    }

    public static RemoteConfigurationMonitor get(GatewayConfig config) {
        RemoteConfigurationMonitor rcm = null;
        ServiceLoader<RemoteConfigurationMonitorProvider> providers = ServiceLoader.load(RemoteConfigurationMonitorProvider.class);
        for (RemoteConfigurationMonitorProvider provider : providers) {
            try {
                rcm = provider.newInstance(config, RemoteConfigurationMonitorFactory.getClientService());
                if (rcm == null) continue;
                break;
            }
            catch (Exception e) {
                log.remoteConfigurationMonitorInitFailure(e.getLocalizedMessage(), e);
            }
        }
        return rcm;
    }
}

