/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.knox.gateway.SpiGatewayMessages;
import org.apache.knox.gateway.SpiGatewayResources;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.config.Configure;
import org.apache.knox.gateway.config.Default;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.dispatch.AbstractGatewayDispatch;
import org.apache.knox.gateway.dispatch.InputStreamEntity;
import org.apache.knox.gateway.dispatch.PartiallyRepeatableHttpEntity;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.util.MimeTypes;

public class DefaultDispatch
extends AbstractGatewayDispatch {
    protected static final String SET_COOKIE = "SET-COOKIE";
    protected static final String WWW_AUTHENTICATE = "WWW-AUTHENTICATE";
    protected static final SpiGatewayMessages LOG = (SpiGatewayMessages)MessagesFactory.get(SpiGatewayMessages.class);
    protected static final SpiGatewayResources RES = (SpiGatewayResources)ResourcesFactory.get(SpiGatewayResources.class);
    protected static final Auditor auditor = AuditServiceFactory.getAuditService().getAuditor("audit", "knox", "knox");
    private Set<String> outboundResponseExcludeHeaders;
    private int replayBufferSize = -1;

    @Override
    public void init() {
        super.init();
        this.outboundResponseExcludeHeaders = new HashSet<String>();
        this.outboundResponseExcludeHeaders.add(SET_COOKIE);
        this.outboundResponseExcludeHeaders.add(WWW_AUTHENTICATE);
    }

    @Override
    public void destroy() {
    }

    protected int getReplayBufferSize() {
        if (this.replayBufferSize > 0) {
            return Math.abs(this.replayBufferSize / 1024);
        }
        return this.replayBufferSize;
    }

    @Configure
    protected void setReplayBufferSize(@Default(value="-1") int size) {
        this.setReplayBufferSizeInBytes(size);
    }

    protected int getReplayBufferSizeInBytes() {
        return this.replayBufferSize;
    }

    protected void setReplayBufferSizeInBytes(int size) {
        if (size > 0) {
            size *= 1024;
        }
        this.replayBufferSize = size;
    }

    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = this.executeOutboundRequest(outboundRequest);
        this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
    }

    protected HttpResponse executeOutboundRequest(HttpUriRequest outboundRequest) throws IOException {
        HttpResponse inboundResponse;
        LOG.dispatchRequest(outboundRequest.getMethod(), outboundRequest.getURI());
        try {
            int statusCode;
            auditor.audit("dispatch", outboundRequest.getURI().toString(), "uri", "unavailable", RES.requestMethod(outboundRequest.getMethod()));
            if (!"true".equals(System.getProperty("gateway.hadoop.kerberos.secured"))) {
                this.addCredentialsToRequest(outboundRequest);
            }
            if ((statusCode = (inboundResponse = this.getHttpClient().execute(outboundRequest)).getStatusLine().getStatusCode()) != 201) {
                LOG.dispatchResponseStatusCode(statusCode);
            } else {
                Header location = inboundResponse.getFirstHeader("Location");
                if (location == null) {
                    LOG.dispatchResponseStatusCode(statusCode);
                } else {
                    LOG.dispatchResponseCreatedStatusCode(statusCode, location.getValue());
                }
            }
            auditor.audit("dispatch", outboundRequest.getURI().toString(), "uri", "success", RES.responseStatus(statusCode));
        }
        catch (Exception e) {
            auditor.audit("dispatch", outboundRequest.getURI().toString(), "uri", "failure");
            LOG.dispatchServiceConnectionException(outboundRequest.getURI(), e);
            throw new IOException(RES.dispatchConnectionError());
        }
        return inboundResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOutboundResponse(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse) throws IOException {
        outboundResponse.setStatus(inboundResponse.getStatusLine().getStatusCode());
        Header[] headers = inboundResponse.getAllHeaders();
        Set<String> excludeHeaders = this.getOutboundResponseExcludeHeaders();
        boolean hasExcludeHeaders = false;
        if (excludeHeaders != null && !excludeHeaders.isEmpty()) {
            hasExcludeHeaders = true;
        }
        for (Header header : headers) {
            String name = header.getName();
            if (hasExcludeHeaders && excludeHeaders.contains(name.toUpperCase(Locale.ROOT))) continue;
            String value = header.getValue();
            outboundResponse.addHeader(name, value);
        }
        HttpEntity entity = inboundResponse.getEntity();
        if (entity != null) {
            outboundResponse.setContentType(this.getInboundResponseContentType(entity));
            InputStream stream = entity.getContent();
            try {
                this.writeResponse(inboundRequest, outboundResponse, stream);
            }
            finally {
                this.closeInboundResponse(inboundResponse, stream);
            }
        }
    }

    private String getInboundResponseContentType(HttpEntity entity) {
        ContentType entityContentType;
        String fullContentType = null;
        if (entity != null && (entityContentType = ContentType.get((HttpEntity)entity)) != null) {
            if (entityContentType.getCharset() == null) {
                String entityMimeType = entityContentType.getMimeType();
                String defaultCharset = MimeTypes.getDefaultCharsetForMimeType((String)entityMimeType);
                if (defaultCharset != null) {
                    LOG.usingDefaultCharsetForEntity(entityMimeType, defaultCharset);
                    entityContentType = entityContentType.withCharset(defaultCharset);
                }
            } else {
                LOG.usingExplicitCharsetForEntity(entityContentType.getMimeType(), entityContentType.getCharset());
            }
            fullContentType = entityContentType.toString();
        }
        if (fullContentType == null) {
            LOG.unknownResponseEntityContentType();
        } else {
            LOG.inboundResponseEntityContentType(fullContentType);
        }
        return fullContentType;
    }

    protected void closeInboundResponse(HttpResponse response, InputStream stream) throws IOException {
        try {
            stream.close();
        }
        finally {
            if (response instanceof Closeable) {
                ((Closeable)response).close();
            }
        }
    }

    protected void addCredentialsToRequest(HttpUriRequest outboundRequest) {
    }

    protected HttpEntity createRequestEntity(HttpServletRequest request) throws IOException {
        String contentType = request.getContentType();
        int contentLength = request.getContentLength();
        ServletInputStream contentStream = request.getInputStream();
        Object entity = contentType == null ? new InputStreamEntity((InputStream)contentStream, contentLength) : new InputStreamEntity((InputStream)contentStream, contentLength, ContentType.parse((String)contentType));
        GatewayConfig config = (GatewayConfig)request.getServletContext().getAttribute("org.apache.knox.gateway.config");
        if (config != null && config.isHadoopKerberosSecured()) {
            boolean delegationTokenPresent = false;
            String queryString = request.getQueryString();
            if (queryString != null) {
                boolean bl = delegationTokenPresent = queryString.startsWith("delegation=") || queryString.contains("&delegation=");
            }
            if (this.replayBufferSize < 0) {
                this.replayBufferSize = config.getHttpServerRequestBuffer();
            }
            if (!delegationTokenPresent && this.replayBufferSize > 0) {
                entity = new PartiallyRepeatableHttpEntity((HttpEntity)entity, this.replayBufferSize);
            }
        }
        return entity;
    }

    @Override
    public void doGet(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException, URISyntaxException {
        HttpGet method = new HttpGet(url);
        this.copyRequestHeaderFields((HttpUriRequest)method, request);
        this.executeRequest((HttpUriRequest)method, request, response);
    }

    @Override
    public void doOptions(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException, URISyntaxException {
        HttpOptions method = new HttpOptions(url);
        this.executeRequest((HttpUriRequest)method, request, response);
    }

    @Override
    public void doPut(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException, URISyntaxException {
        HttpPut method = new HttpPut(url);
        HttpEntity entity = this.createRequestEntity(request);
        method.setEntity(entity);
        this.copyRequestHeaderFields((HttpUriRequest)method, request);
        this.executeRequest((HttpUriRequest)method, request, response);
    }

    @Override
    public void doPost(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException, URISyntaxException {
        HttpPost method = new HttpPost(url);
        HttpEntity entity = this.createRequestEntity(request);
        method.setEntity(entity);
        this.copyRequestHeaderFields((HttpUriRequest)method, request);
        this.executeRequest((HttpUriRequest)method, request, response);
    }

    @Override
    public void doDelete(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException, URISyntaxException {
        HttpDelete method = new HttpDelete(url);
        this.copyRequestHeaderFields((HttpUriRequest)method, request);
        this.executeRequest((HttpUriRequest)method, request, response);
    }

    @Override
    public void doHead(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException, URISyntaxException {
        HttpHead method = new HttpHead(url);
        this.copyRequestHeaderFields((HttpUriRequest)method, request);
        this.executeRequest((HttpUriRequest)method, request, response);
    }

    public Set<String> getOutboundResponseExcludeHeaders() {
        return this.outboundResponseExcludeHeaders;
    }
}

