/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.twitter;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth1Token;
import java.util.Arrays;
import java.util.Locale;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.core.profile.converter.DateConverter;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.definition.OAuth10ProfileDefinition;
import org.pac4j.oauth.profile.twitter.TwitterProfile;

public class TwitterProfileDefinition
extends OAuth10ProfileDefinition<TwitterProfile> {
    public static final String CONTRIBUTORS_ENABLED = "contributors_enabled";
    public static final String CREATED_AT = "created_at";
    public static final String DEFAULT_PROFILE = "default_profile";
    public static final String DEFAULT_PROFILE_IMAGE = "default_profile_image";
    public static final String DESCRIPTION = "description";
    public static final String EMAIL = "email";
    public static final String FAVOURITES_COUNT = "favourites_count";
    public static final String FOLLOW_REQUEST_SENT = "follow_request_sent";
    public static final String FOLLOWERS_COUNT = "followers_count";
    public static final String FOLLOWING = "following";
    public static final String FRIENDS_COUNT = "friends_count";
    public static final String GEO_ENABLED = "geo_enabled";
    public static final String IS_TRANSLATOR = "is_translator";
    public static final String LANG = "lang";
    public static final String LISTED_COUNT = "listed_count";
    public static final String NAME = "name";
    public static final String NOTIFICATIONS = "notifications";
    public static final String PROFILE_BACKGROUND_COLOR = "profile_background_color";
    public static final String PROFILE_BACKGROUND_IMAGE_URL = "profile_background_image_url";
    public static final String PROFILE_BACKGROUND_IMAGE_URL_HTTPS = "profile_background_image_url_https";
    public static final String PROFILE_BACKGROUND_TILE = "profile_background_tile";
    public static final String PROFILE_IMAGE_URL = "profile_image_url";
    public static final String PROFILE_IMAGE_URL_HTTPS = "profile_image_url_https";
    public static final String PROFILE_LINK_COLOR = "profile_link_color";
    public static final String PROFILE_SIDEBAR_BORDER_COLOR = "profile_sidebar_border_color";
    public static final String PROFILE_SIDEBAR_FILL_COLOR = "profile_sidebar_fill_color";
    public static final String PROFILE_TEXT_COLOR = "profile_text_color";
    public static final String PROFILE_USE_BACKGROUND_IMAGE = "profile_use_background_image";
    public static final String PROTECTED = "protected";
    public static final String SCREEN_NAME = "screen_name";
    public static final String SHOW_ALL_INLINE_MEDIA = "show_all_inline_media";
    public static final String STATUSES_COUNT = "statuses_count";
    public static final String TIME_ZONE = "time_zone";
    public static final String URL = "url";
    public static final String UTC_OFFSET = "utc_offset";
    public static final String VERIFIED = "verified";
    private static final String VERIFY_CREDENTIALS_URL = "https://api.twitter.com/1.1/account/verify_credentials.json";
    private final boolean includeEmail;

    public TwitterProfileDefinition() {
        this(false);
    }

    public TwitterProfileDefinition(boolean includeEmail) {
        super(x -> new TwitterProfile());
        Arrays.stream(new String[]{DESCRIPTION, EMAIL, NAME, SCREEN_NAME, TIME_ZONE}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        Arrays.stream(new String[]{CONTRIBUTORS_ENABLED, DEFAULT_PROFILE, DEFAULT_PROFILE_IMAGE, FOLLOW_REQUEST_SENT, FOLLOWING, GEO_ENABLED, IS_TRANSLATOR, NOTIFICATIONS, PROFILE_USE_BACKGROUND_IMAGE, PROTECTED, SHOW_ALL_INLINE_MEDIA, PROFILE_BACKGROUND_TILE, VERIFIED}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.BOOLEAN));
        Arrays.stream(new String[]{FAVOURITES_COUNT, FOLLOWERS_COUNT, FRIENDS_COUNT, LISTED_COUNT, STATUSES_COUNT, UTC_OFFSET}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.INTEGER));
        Arrays.stream(new String[]{URL, PROFILE_BACKGROUND_IMAGE_URL, PROFILE_BACKGROUND_IMAGE_URL_HTTPS, PROFILE_IMAGE_URL, PROFILE_IMAGE_URL_HTTPS}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.URL));
        Arrays.stream(new String[]{PROFILE_BACKGROUND_COLOR, PROFILE_LINK_COLOR, PROFILE_SIDEBAR_BORDER_COLOR, PROFILE_SIDEBAR_FILL_COLOR, PROFILE_TEXT_COLOR}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.COLOR));
        this.primary(LANG, (AttributeConverter)Converters.LOCALE);
        this.primary(CREATED_AT, (AttributeConverter)new DateConverter("EEE MMM dd HH:mm:ss Z yyyy", Locale.US));
        this.includeEmail = includeEmail;
    }

    @Override
    public String getProfileUrl(OAuth1Token accessToken, OAuth10Configuration configuration) {
        if (this.includeEmail) {
            return "https://api.twitter.com/1.1/account/verify_credentials.json?include_email=true";
        }
        return VERIFY_CREDENTIALS_URL;
    }

    @Override
    public TwitterProfile extractUserProfile(String body) {
        TwitterProfile profile = (TwitterProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((UserProfile)profile, (Object)JsonHelper.getElement(json, "id")));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

